/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about finding statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingStatistics.Builder, FindingStatistics> {
    private static final SdkField<Map<String, Integer>> COUNT_BY_SEVERITY_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("CountBySeverity")
            .getter(getter(FindingStatistics::countBySeverity))
            .setter(setter(Builder::countBySeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countBySeverity").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_BY_SEVERITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Integer> countBySeverity;

    private FindingStatistics(BuilderImpl builder) {
        this.countBySeverity = builder.countBySeverity;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountBySeverity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCountBySeverity() {
        return countBySeverity != null && !(countBySeverity instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents a map of severity to count statistics for a set of findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountBySeverity} method.
     * </p>
     * 
     * @return Represents a map of severity to count statistics for a set of findings.
     */
    public final Map<String, Integer> countBySeverity() {
        return countBySeverity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountBySeverity() ? countBySeverity() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingStatistics)) {
            return false;
        }
        FindingStatistics other = (FindingStatistics) obj;
        return hasCountBySeverity() == other.hasCountBySeverity() && Objects.equals(countBySeverity(), other.countBySeverity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingStatistics").add("CountBySeverity", hasCountBySeverity() ? countBySeverity() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountBySeverity":
            return Optional.ofNullable(clazz.cast(countBySeverity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingStatistics, T> g) {
        return obj -> g.apply((FindingStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingStatistics> {
        /**
         * <p>
         * Represents a map of severity to count statistics for a set of findings.
         * </p>
         * 
         * @param countBySeverity
         *        Represents a map of severity to count statistics for a set of findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countBySeverity(Map<String, Integer> countBySeverity);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Integer> countBySeverity = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingStatistics model) {
            countBySeverity(model.countBySeverity);
        }

        public final Map<String, Integer> getCountBySeverity() {
            if (countBySeverity instanceof SdkAutoConstructMap) {
                return null;
            }
            return countBySeverity;
        }

        public final void setCountBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
        }

        @Override
        @Transient
        public final Builder countBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
            return this;
        }

        @Override
        public FindingStatistics build() {
            return new FindingStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
