/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFilterRequest extends GuardDutyRequest implements
        ToCopyableBuilder<CreateFilterRequest.Builder, CreateFilterRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(CreateFilterRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFilterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFilterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(CreateFilterRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rank")
            .getter(getter(CreateFilterRequest::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("FindingCriteria")
            .getter(getter(CreateFilterRequest::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateFilterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateFilterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, ACTION_FIELD, RANK_FIELD, FINDING_CRITERIA_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String detectorId;

    private final String name;

    private final String description;

    private final String action;

    private final Integer rank;

    private final FindingCriteria findingCriteria;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateFilterRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.rank = builder.rank;
        this.findingCriteria = builder.findingCriteria;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
     * </p>
     * 
     * @return The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric
     * characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
     * </p>
     * 
     * @return The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric
     *         characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the filter.
     * </p>
     * 
     * @return The description of the filter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action that is to be applied to the findings that match the filter.
     * @see FilterAction
     */
    public final FilterAction action() {
        return FilterAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action that is to be applied to the findings that match the filter.
     * @see FilterAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies the position of the filter in the list of current filters. Also specifies the order in which this
     * filter is applied to the findings.
     * </p>
     * 
     * @return Specifies the position of the filter in the list of current filters. Also specifies the order in which
     *         this filter is applied to the findings.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * <p>
     * Represents the criteria to be used in the filter for querying findings.
     * </p>
     * <p>
     * You can only use the following attributes to query findings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * accountId
     * </p>
     * </li>
     * <li>
     * <p>
     * region
     * </p>
     * </li>
     * <li>
     * <p>
     * confidence
     * </p>
     * </li>
     * <li>
     * <p>
     * id
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.accessKeyId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.principalId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.userName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.userType
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.iamInstanceProfile.id
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.imageId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.instanceId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.outpostArn
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.ipv6Addresses
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.publicDnsName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.publicIp
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.securityGroups.groupId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.securityGroups.groupName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.subnetId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.vpcId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.tags.key
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.tags.value
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.resourceType
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.actionType
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.api
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.callerType
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.errorCode
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.city.cityName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.country.countryName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.organization.asn
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.serviceName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.dnsRequestAction.domain
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.blocked
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.connectionDirection
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.localPortDetails.port
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.protocol
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.localIpDetails.ipAddressV4
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.city.cityName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.country.countryName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.organization.asn
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remotePortDetails.port
     * </p>
     * </li>
     * <li>
     * <p>
     * service.additionalInfo.threatListName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.s3BucketDetails.publicAccess.effectivePermissions
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.s3BucketDetails.name
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.s3BucketDetails.tags.key
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.s3BucketDetails.tags.value
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.s3BucketDetails.type
     * </p>
     * </li>
     * <li>
     * <p>
     * service.archived
     * </p>
     * <p>
     * When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived
     * findings are listed. When this attribute is not set, all existing findings are listed.
     * </p>
     * </li>
     * <li>
     * <p>
     * service.resourceRole
     * </p>
     * </li>
     * <li>
     * <p>
     * severity
     * </p>
     * </li>
     * <li>
     * <p>
     * type
     * </p>
     * </li>
     * <li>
     * <p>
     * updatedAt
     * </p>
     * <p>
     * Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value
     * contains milliseconds.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Represents the criteria to be used in the filter for querying findings.</p>
     *         <p>
     *         You can only use the following attributes to query findings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         accountId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         region
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         confidence
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.accessKeyId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.principalId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.userName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.userType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.iamInstanceProfile.id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.imageId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.instanceId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.outpostArn
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.ipv6Addresses
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.publicDnsName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.publicIp
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.securityGroups.groupId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.securityGroups.groupName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.subnetId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.vpcId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.tags.key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.tags.value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.resourceType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.actionType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.api
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.callerType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.errorCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.city.cityName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.country.countryName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.organization.asn
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.serviceName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.dnsRequestAction.domain
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.blocked
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.connectionDirection
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.localPortDetails.port
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.protocol
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.localIpDetails.ipAddressV4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.city.cityName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.country.countryName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.organization.asn
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remotePortDetails.port
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.additionalInfo.threatListName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.s3BucketDetails.publicAccess.effectivePermissions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.s3BucketDetails.name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.s3BucketDetails.tags.key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.s3BucketDetails.tags.value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.s3BucketDetails.type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.archived
     *         </p>
     *         <p>
     *         When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only
     *         unarchived findings are listed. When this attribute is not set, all existing findings are listed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.resourceRole
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         severity
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         updatedAt
     *         </p>
     *         <p>
     *         Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the
     *         value contains milliseconds.
     *         </p>
     *         </li>
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @return The idempotency token for the create request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be added to a new filter resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be added to a new filter resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFilterRequest)) {
            return false;
        }
        CreateFilterRequest other = (CreateFilterRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(rank(), other.rank()) && Objects.equals(findingCriteria(), other.findingCriteria())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFilterRequest").add("DetectorId", detectorId()).add("Name", name())
                .add("Description", description()).add("Action", actionAsString()).add("Rank", rank())
                .add("FindingCriteria", findingCriteria()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "FindingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFilterRequest, T> g) {
        return obj -> g.apply((CreateFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFilterRequest> {
        /**
         * <p>
         * The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric
         * characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
         * </p>
         * 
         * @param name
         *        The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include
         *        alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the filter.
         * </p>
         * 
         * @param description
         *        The description of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the action that is to be applied to the findings that match the filter.
         * </p>
         * 
         * @param action
         *        Specifies the action that is to be applied to the findings that match the filter.
         * @see FilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies the action that is to be applied to the findings that match the filter.
         * </p>
         * 
         * @param action
         *        Specifies the action that is to be applied to the findings that match the filter.
         * @see FilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterAction
         */
        Builder action(FilterAction action);

        /**
         * <p>
         * Specifies the position of the filter in the list of current filters. Also specifies the order in which this
         * filter is applied to the findings.
         * </p>
         * 
         * @param rank
         *        Specifies the position of the filter in the list of current filters. Also specifies the order in which
         *        this filter is applied to the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * <p>
         * Represents the criteria to be used in the filter for querying findings.
         * </p>
         * <p>
         * You can only use the following attributes to query findings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * accountId
         * </p>
         * </li>
         * <li>
         * <p>
         * region
         * </p>
         * </li>
         * <li>
         * <p>
         * confidence
         * </p>
         * </li>
         * <li>
         * <p>
         * id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.accessKeyId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.principalId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userType
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.iamInstanceProfile.id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.imageId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.instanceId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.outpostArn
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.ipv6Addresses
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicDnsName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicIp
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.subnetId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.vpcId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.key
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.value
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.resourceType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.actionType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.api
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.callerType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.errorCode
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.city.cityName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.serviceName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.dnsRequestAction.domain
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.blocked
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.connectionDirection
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.localPortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.protocol
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.localIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.city.cityName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remotePortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.additionalInfo.threatListName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.publicAccess.effectivePermissions
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.name
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.tags.key
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.tags.value
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.type
         * </p>
         * </li>
         * <li>
         * <p>
         * service.archived
         * </p>
         * <p>
         * When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only
         * unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * service.resourceRole
         * </p>
         * </li>
         * <li>
         * <p>
         * severity
         * </p>
         * </li>
         * <li>
         * <p>
         * type
         * </p>
         * </li>
         * <li>
         * <p>
         * updatedAt
         * </p>
         * <p>
         * Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value
         * contains milliseconds.
         * </p>
         * </li>
         * </ul>
         * 
         * @param findingCriteria
         *        Represents the criteria to be used in the filter for querying findings.</p>
         *        <p>
         *        You can only use the following attributes to query findings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        accountId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        region
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        confidence
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.accessKeyId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.principalId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.userName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.userType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.iamInstanceProfile.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.imageId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.instanceId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.outpostArn
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.ipv6Addresses
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.publicDnsName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.publicIp
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.securityGroups.groupId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.securityGroups.groupName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.subnetId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.vpcId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.tags.key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.tags.value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.resourceType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.actionType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.api
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.callerType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.errorCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.city.cityName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.country.countryName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.organization.asn
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.serviceName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.dnsRequestAction.domain
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.blocked
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.connectionDirection
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.localPortDetails.port
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.protocol
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.localIpDetails.ipAddressV4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.city.cityName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.country.countryName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.organization.asn
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remotePortDetails.port
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.additionalInfo.threatListName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.s3BucketDetails.publicAccess.effectivePermissions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.s3BucketDetails.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.s3BucketDetails.tags.key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.s3BucketDetails.tags.value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.s3BucketDetails.type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.archived
         *        </p>
         *        <p>
         *        When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only
         *        unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.resourceRole
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        severity
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        updatedAt
         *        </p>
         *        <p>
         *        Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether
         *        the value contains milliseconds.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * Represents the criteria to be used in the filter for querying findings.
         * </p>
         * <p>
         * You can only use the following attributes to query findings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * accountId
         * </p>
         * </li>
         * <li>
         * <p>
         * region
         * </p>
         * </li>
         * <li>
         * <p>
         * confidence
         * </p>
         * </li>
         * <li>
         * <p>
         * id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.accessKeyId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.principalId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userType
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.iamInstanceProfile.id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.imageId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.instanceId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.outpostArn
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.ipv6Addresses
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicDnsName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicIp
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.subnetId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.vpcId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.key
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.value
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.resourceType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.actionType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.api
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.callerType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.errorCode
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.city.cityName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.serviceName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.dnsRequestAction.domain
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.blocked
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.connectionDirection
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.localPortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.protocol
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.localIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.city.cityName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remotePortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.additionalInfo.threatListName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.publicAccess.effectivePermissions
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.name
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.tags.key
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.tags.value
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.s3BucketDetails.type
         * </p>
         * </li>
         * <li>
         * <p>
         * service.archived
         * </p>
         * <p>
         * When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only
         * unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * service.resourceRole
         * </p>
         * </li>
         * <li>
         * <p>
         * severity
         * </p>
         * </li>
         * <li>
         * <p>
         * type
         * </p>
         * </li>
         * <li>
         * <p>
         * updatedAt
         * </p>
         * <p>
         * Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value
         * contains milliseconds.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link FindingCriteria.Builder} avoiding the need to
         * create one manually via {@link FindingCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        /**
         * <p>
         * The idempotency token for the create request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the create request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to be added to a new filter resource.
         * </p>
         * 
         * @param tags
         *        The tags to be added to a new filter resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String name;

        private String description;

        private String action;

        private Integer rank;

        private FindingCriteria findingCriteria;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFilterRequest model) {
            super(model);
            detectorId(model.detectorId);
            name(model.name);
            description(model.description);
            action(model.action);
            rank(model.rank);
            findingCriteria(model.findingCriteria);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        @Transient
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(FilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        @Transient
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFilterRequest build() {
            return new CreateFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
