/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpSetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetIpSetResponse.Builder, GetIpSetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetIpSetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetIpSetResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(GetIpSetResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetIpSetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetIpSetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD,
            LOCATION_FIELD, STATUS_FIELD, TAGS_FIELD));

    private final String name;

    private final String format;

    private final String location;

    private final String status;

    private final Map<String, String> tags;

    private GetIpSetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.format = builder.format;
        this.location = builder.location;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The user-friendly name for the IPSet.
     * </p>
     * 
     * @return The user-friendly name for the IPSet.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format of the file that contains the IPSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link IpSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the IPSet.
     * @see IpSetFormat
     */
    public final IpSetFormat format() {
        return IpSetFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the file that contains the IPSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link IpSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the IPSet.
     * @see IpSetFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The URI of the file that contains the IPSet.
     * </p>
     * 
     * @return The URI of the file that contains the IPSet.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The status of IPSet file that was uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of IPSet file that was uploaded.
     * @see IpSetStatus
     */
    public final IpSetStatus status() {
        return IpSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of IPSet file that was uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of IPSet file that was uploaded.
     * @see IpSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the IPSet resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the IPSet resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpSetResponse)) {
            return false;
        }
        GetIpSetResponse other = (GetIpSetResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(location(), other.location()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIpSetResponse").add("Name", name()).add("Format", formatAsString())
                .add("Location", location()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpSetResponse, T> g) {
        return obj -> g.apply((GetIpSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIpSetResponse> {
        /**
         * <p>
         * The user-friendly name for the IPSet.
         * </p>
         * 
         * @param name
         *        The user-friendly name for the IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the file that contains the IPSet.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the IPSet.
         * @see IpSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the file that contains the IPSet.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the IPSet.
         * @see IpSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetFormat
         */
        Builder format(IpSetFormat format);

        /**
         * <p>
         * The URI of the file that contains the IPSet.
         * </p>
         * 
         * @param location
         *        The URI of the file that contains the IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The status of IPSet file that was uploaded.
         * </p>
         * 
         * @param status
         *        The status of IPSet file that was uploaded.
         * @see IpSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of IPSet file that was uploaded.
         * </p>
         * 
         * @param status
         *        The status of IPSet file that was uploaded.
         * @see IpSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetStatus
         */
        Builder status(IpSetStatus status);

        /**
         * <p>
         * The tags of the IPSet resource.
         * </p>
         * 
         * @param tags
         *        The tags of the IPSet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String name;

        private String format;

        private String location;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpSetResponse model) {
            super(model);
            name(model.name);
            format(model.format);
            location(model.location);
            status(model.status);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(IpSetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        @Transient
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(IpSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetIpSetResponse build() {
            return new GetIpSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
