/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMembersRequest extends GuardDutyRequest implements
        ToCopyableBuilder<CreateMembersRequest.Builder, CreateMembersRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(CreateMembersRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<AccountDetail>> ACCOUNT_DETAILS_FIELD = SdkField
            .<List<AccountDetail>> builder(MarshallingType.LIST)
            .memberName("AccountDetails")
            .getter(getter(CreateMembersRequest::accountDetails))
            .setter(setter(Builder::accountDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            ACCOUNT_DETAILS_FIELD));

    private final String detectorId;

    private final List<AccountDetail> accountDetails;

    private CreateMembersRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.accountDetails = builder.accountDetails;
    }

    /**
     * <p>
     * The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.
     * </p>
     * 
     * @return The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountDetails() {
        return accountDetails != null && !(accountDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty
     * administrator account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountDetails} method.
     * </p>
     * 
     * @return A list of account ID and email address pairs of the accounts that you want to associate with the
     *         GuardDuty administrator account.
     */
    public final List<AccountDetail> accountDetails() {
        return accountDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountDetails() ? accountDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersRequest)) {
            return false;
        }
        CreateMembersRequest other = (CreateMembersRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && hasAccountDetails() == other.hasAccountDetails()
                && Objects.equals(accountDetails(), other.accountDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMembersRequest").add("DetectorId", detectorId())
                .add("AccountDetails", hasAccountDetails() ? accountDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AccountDetails":
            return Optional.ofNullable(clazz.cast(accountDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersRequest, T> g) {
        return obj -> g.apply((CreateMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMembersRequest> {
        /**
         * <p>
         * The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector of the GuardDuty account that you want to associate member accounts
         *        with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty
         * administrator account.
         * </p>
         * 
         * @param accountDetails
         *        A list of account ID and email address pairs of the accounts that you want to associate with the
         *        GuardDuty administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDetails(Collection<AccountDetail> accountDetails);

        /**
         * <p>
         * A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty
         * administrator account.
         * </p>
         * 
         * @param accountDetails
         *        A list of account ID and email address pairs of the accounts that you want to associate with the
         *        GuardDuty administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDetails(AccountDetail... accountDetails);

        /**
         * <p>
         * A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty
         * administrator account.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AccountDetail>.Builder} avoiding the
         * need to create one manually via {@link List<AccountDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #accountDetails(List<AccountDetail>)}.
         * 
         * @param accountDetails
         *        a consumer that will call methods on {@link List<AccountDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountDetails(List<AccountDetail>)
         */
        Builder accountDetails(Consumer<AccountDetail.Builder>... accountDetails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<AccountDetail> accountDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersRequest model) {
            super(model);
            detectorId(model.detectorId);
            accountDetails(model.accountDetails);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final List<AccountDetail.Builder> getAccountDetails() {
            List<AccountDetail.Builder> result = AccountDetailsCopier.copyToBuilder(this.accountDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountDetails(Collection<AccountDetail.BuilderImpl> accountDetails) {
            this.accountDetails = AccountDetailsCopier.copyFromBuilder(accountDetails);
        }

        @Override
        public final Builder accountDetails(Collection<AccountDetail> accountDetails) {
            this.accountDetails = AccountDetailsCopier.copy(accountDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(AccountDetail... accountDetails) {
            accountDetails(Arrays.asList(accountDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(Consumer<AccountDetail.Builder>... accountDetails) {
            accountDetails(Stream.of(accountDetails).map(c -> AccountDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembersRequest build() {
            return new CreateMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
