/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information on which data sources are automatically enabled for new members within the
 * organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationDataSourceConfigurationsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationDataSourceConfigurationsResult.Builder, OrganizationDataSourceConfigurationsResult> {
    private static final SdkField<OrganizationS3LogsConfigurationResult> S3_LOGS_FIELD = SdkField
            .<OrganizationS3LogsConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(OrganizationDataSourceConfigurationsResult::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(OrganizationS3LogsConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final SdkField<OrganizationKubernetesConfigurationResult> KUBERNETES_FIELD = SdkField
            .<OrganizationKubernetesConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("Kubernetes")
            .getter(getter(OrganizationDataSourceConfigurationsResult::kubernetes)).setter(setter(Builder::kubernetes))
            .constructor(OrganizationKubernetesConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOGS_FIELD,
            KUBERNETES_FIELD));

    private static final long serialVersionUID = 1L;

    private final OrganizationS3LogsConfigurationResult s3Logs;

    private final OrganizationKubernetesConfigurationResult kubernetes;

    private OrganizationDataSourceConfigurationsResult(BuilderImpl builder) {
        this.s3Logs = builder.s3Logs;
        this.kubernetes = builder.kubernetes;
    }

    /**
     * <p>
     * Describes whether S3 data event logs are enabled as a data source.
     * </p>
     * 
     * @return Describes whether S3 data event logs are enabled as a data source.
     */
    public final OrganizationS3LogsConfigurationResult s3Logs() {
        return s3Logs;
    }

    /**
     * <p>
     * Describes the configuration of Kubernetes data sources.
     * </p>
     * 
     * @return Describes the configuration of Kubernetes data sources.
     */
    public final OrganizationKubernetesConfigurationResult kubernetes() {
        return kubernetes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationDataSourceConfigurationsResult)) {
            return false;
        }
        OrganizationDataSourceConfigurationsResult other = (OrganizationDataSourceConfigurationsResult) obj;
        return Objects.equals(s3Logs(), other.s3Logs()) && Objects.equals(kubernetes(), other.kubernetes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationDataSourceConfigurationsResult").add("S3Logs", s3Logs())
                .add("Kubernetes", kubernetes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        case "Kubernetes":
            return Optional.ofNullable(clazz.cast(kubernetes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationDataSourceConfigurationsResult, T> g) {
        return obj -> g.apply((OrganizationDataSourceConfigurationsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationDataSourceConfigurationsResult> {
        /**
         * <p>
         * Describes whether S3 data event logs are enabled as a data source.
         * </p>
         * 
         * @param s3Logs
         *        Describes whether S3 data event logs are enabled as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(OrganizationS3LogsConfigurationResult s3Logs);

        /**
         * <p>
         * Describes whether S3 data event logs are enabled as a data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationS3LogsConfigurationResult.Builder} avoiding the need to create one manually via
         * {@link OrganizationS3LogsConfigurationResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationS3LogsConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Logs(OrganizationS3LogsConfigurationResult)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link OrganizationS3LogsConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(OrganizationS3LogsConfigurationResult)
         */
        default Builder s3Logs(Consumer<OrganizationS3LogsConfigurationResult.Builder> s3Logs) {
            return s3Logs(OrganizationS3LogsConfigurationResult.builder().applyMutation(s3Logs).build());
        }

        /**
         * <p>
         * Describes the configuration of Kubernetes data sources.
         * </p>
         * 
         * @param kubernetes
         *        Describes the configuration of Kubernetes data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetes(OrganizationKubernetesConfigurationResult kubernetes);

        /**
         * <p>
         * Describes the configuration of Kubernetes data sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationKubernetesConfigurationResult.Builder} avoiding the need to create one manually via
         * {@link OrganizationKubernetesConfigurationResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationKubernetesConfigurationResult.Builder#build()} is
         * called immediately and its result is passed to {@link #kubernetes(OrganizationKubernetesConfigurationResult)}
         * .
         * 
         * @param kubernetes
         *        a consumer that will call methods on {@link OrganizationKubernetesConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetes(OrganizationKubernetesConfigurationResult)
         */
        default Builder kubernetes(Consumer<OrganizationKubernetesConfigurationResult.Builder> kubernetes) {
            return kubernetes(OrganizationKubernetesConfigurationResult.builder().applyMutation(kubernetes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrganizationS3LogsConfigurationResult s3Logs;

        private OrganizationKubernetesConfigurationResult kubernetes;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationDataSourceConfigurationsResult model) {
            s3Logs(model.s3Logs);
            kubernetes(model.kubernetes);
        }

        public final OrganizationS3LogsConfigurationResult.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(OrganizationS3LogsConfigurationResult.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(OrganizationS3LogsConfigurationResult s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final OrganizationKubernetesConfigurationResult.Builder getKubernetes() {
            return kubernetes != null ? kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(OrganizationKubernetesConfigurationResult.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(OrganizationKubernetesConfigurationResult kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        @Override
        public OrganizationDataSourceConfigurationsResult build() {
            return new OrganizationDataSourceConfigurationsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
