/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the GuardDuty member account that uses a free trial service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountFreeTrialInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountFreeTrialInfo.Builder, AccountFreeTrialInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountFreeTrialInfo::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<DataSourcesFreeTrial> DATA_SOURCES_FIELD = SdkField
            .<DataSourcesFreeTrial> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(AccountFreeTrialInfo::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourcesFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DATA_SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final DataSourcesFreeTrial dataSources;

    private AccountFreeTrialInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.dataSources = builder.dataSources;
    }

    /**
     * <p>
     * The account identifier of the GuardDuty member account.
     * </p>
     * 
     * @return The account identifier of the GuardDuty member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Describes the data source enabled for the GuardDuty member account.
     * </p>
     * 
     * @return Describes the data source enabled for the GuardDuty member account.
     */
    public final DataSourcesFreeTrial dataSources() {
        return dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountFreeTrialInfo)) {
            return false;
        }
        AccountFreeTrialInfo other = (AccountFreeTrialInfo) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(dataSources(), other.dataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountFreeTrialInfo").add("AccountId", accountId()).add("DataSources", dataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountFreeTrialInfo, T> g) {
        return obj -> g.apply((AccountFreeTrialInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountFreeTrialInfo> {
        /**
         * <p>
         * The account identifier of the GuardDuty member account.
         * </p>
         * 
         * @param accountId
         *        The account identifier of the GuardDuty member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Describes the data source enabled for the GuardDuty member account.
         * </p>
         * 
         * @param dataSources
         *        Describes the data source enabled for the GuardDuty member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSourcesFreeTrial dataSources);

        /**
         * <p>
         * Describes the data source enabled for the GuardDuty member account.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourcesFreeTrial.Builder} avoiding
         * the need to create one manually via {@link DataSourcesFreeTrial#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourcesFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(DataSourcesFreeTrial)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourcesFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourcesFreeTrial)
         */
        default Builder dataSources(Consumer<DataSourcesFreeTrial.Builder> dataSources) {
            return dataSources(DataSourcesFreeTrial.builder().applyMutation(dataSources).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private DataSourcesFreeTrial dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountFreeTrialInfo model) {
            accountId(model.accountId);
            dataSources(model.dataSources);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final DataSourcesFreeTrial.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        public final void setDataSources(DataSourcesFreeTrial.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(DataSourcesFreeTrial dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        @Override
        public AccountFreeTrialInfo build() {
            return new AccountFreeTrialInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
