/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about which data sources are enabled for the GuardDuty member account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourcesFreeTrial implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourcesFreeTrial.Builder, DataSourcesFreeTrial> {
    private static final SdkField<DataSourceFreeTrial> CLOUD_TRAIL_FIELD = SdkField
            .<DataSourceFreeTrial> builder(MarshallingType.SDK_POJO).memberName("CloudTrail")
            .getter(getter(DataSourcesFreeTrial::cloudTrail)).setter(setter(Builder::cloudTrail))
            .constructor(DataSourceFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrail").build()).build();

    private static final SdkField<DataSourceFreeTrial> DNS_LOGS_FIELD = SdkField
            .<DataSourceFreeTrial> builder(MarshallingType.SDK_POJO).memberName("DnsLogs")
            .getter(getter(DataSourcesFreeTrial::dnsLogs)).setter(setter(Builder::dnsLogs))
            .constructor(DataSourceFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsLogs").build()).build();

    private static final SdkField<DataSourceFreeTrial> FLOW_LOGS_FIELD = SdkField
            .<DataSourceFreeTrial> builder(MarshallingType.SDK_POJO).memberName("FlowLogs")
            .getter(getter(DataSourcesFreeTrial::flowLogs)).setter(setter(Builder::flowLogs))
            .constructor(DataSourceFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowLogs").build()).build();

    private static final SdkField<DataSourceFreeTrial> S3_LOGS_FIELD = SdkField
            .<DataSourceFreeTrial> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(DataSourcesFreeTrial::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(DataSourceFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final SdkField<KubernetesDataSourceFreeTrial> KUBERNETES_FIELD = SdkField
            .<KubernetesDataSourceFreeTrial> builder(MarshallingType.SDK_POJO).memberName("Kubernetes")
            .getter(getter(DataSourcesFreeTrial::kubernetes)).setter(setter(Builder::kubernetes))
            .constructor(KubernetesDataSourceFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_FIELD,
            DNS_LOGS_FIELD, FLOW_LOGS_FIELD, S3_LOGS_FIELD, KUBERNETES_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataSourceFreeTrial cloudTrail;

    private final DataSourceFreeTrial dnsLogs;

    private final DataSourceFreeTrial flowLogs;

    private final DataSourceFreeTrial s3Logs;

    private final KubernetesDataSourceFreeTrial kubernetes;

    private DataSourcesFreeTrial(BuilderImpl builder) {
        this.cloudTrail = builder.cloudTrail;
        this.dnsLogs = builder.dnsLogs;
        this.flowLogs = builder.flowLogs;
        this.s3Logs = builder.s3Logs;
        this.kubernetes = builder.kubernetes;
    }

    /**
     * <p>
     * Describes whether any AWS CloudTrail management event logs are enabled as data sources.
     * </p>
     * 
     * @return Describes whether any AWS CloudTrail management event logs are enabled as data sources.
     */
    public final DataSourceFreeTrial cloudTrail() {
        return cloudTrail;
    }

    /**
     * <p>
     * Describes whether any DNS logs are enabled as data sources.
     * </p>
     * 
     * @return Describes whether any DNS logs are enabled as data sources.
     */
    public final DataSourceFreeTrial dnsLogs() {
        return dnsLogs;
    }

    /**
     * <p>
     * Describes whether any VPC Flow logs are enabled as data sources.
     * </p>
     * 
     * @return Describes whether any VPC Flow logs are enabled as data sources.
     */
    public final DataSourceFreeTrial flowLogs() {
        return flowLogs;
    }

    /**
     * <p>
     * Describes whether any S3 data event logs are enabled as data sources.
     * </p>
     * 
     * @return Describes whether any S3 data event logs are enabled as data sources.
     */
    public final DataSourceFreeTrial s3Logs() {
        return s3Logs;
    }

    /**
     * <p>
     * Describes whether any Kubernetes logs are enabled as data sources.
     * </p>
     * 
     * @return Describes whether any Kubernetes logs are enabled as data sources.
     */
    public final KubernetesDataSourceFreeTrial kubernetes() {
        return kubernetes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudTrail());
        hashCode = 31 * hashCode + Objects.hashCode(dnsLogs());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourcesFreeTrial)) {
            return false;
        }
        DataSourcesFreeTrial other = (DataSourcesFreeTrial) obj;
        return Objects.equals(cloudTrail(), other.cloudTrail()) && Objects.equals(dnsLogs(), other.dnsLogs())
                && Objects.equals(flowLogs(), other.flowLogs()) && Objects.equals(s3Logs(), other.s3Logs())
                && Objects.equals(kubernetes(), other.kubernetes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourcesFreeTrial").add("CloudTrail", cloudTrail()).add("DnsLogs", dnsLogs())
                .add("FlowLogs", flowLogs()).add("S3Logs", s3Logs()).add("Kubernetes", kubernetes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudTrail":
            return Optional.ofNullable(clazz.cast(cloudTrail()));
        case "DnsLogs":
            return Optional.ofNullable(clazz.cast(dnsLogs()));
        case "FlowLogs":
            return Optional.ofNullable(clazz.cast(flowLogs()));
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        case "Kubernetes":
            return Optional.ofNullable(clazz.cast(kubernetes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourcesFreeTrial, T> g) {
        return obj -> g.apply((DataSourcesFreeTrial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourcesFreeTrial> {
        /**
         * <p>
         * Describes whether any AWS CloudTrail management event logs are enabled as data sources.
         * </p>
         * 
         * @param cloudTrail
         *        Describes whether any AWS CloudTrail management event logs are enabled as data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudTrail(DataSourceFreeTrial cloudTrail);

        /**
         * <p>
         * Describes whether any AWS CloudTrail management event logs are enabled as data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceFreeTrial.Builder} avoiding the
         * need to create one manually via {@link DataSourceFreeTrial#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudTrail(DataSourceFreeTrial)}.
         * 
         * @param cloudTrail
         *        a consumer that will call methods on {@link DataSourceFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudTrail(DataSourceFreeTrial)
         */
        default Builder cloudTrail(Consumer<DataSourceFreeTrial.Builder> cloudTrail) {
            return cloudTrail(DataSourceFreeTrial.builder().applyMutation(cloudTrail).build());
        }

        /**
         * <p>
         * Describes whether any DNS logs are enabled as data sources.
         * </p>
         * 
         * @param dnsLogs
         *        Describes whether any DNS logs are enabled as data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsLogs(DataSourceFreeTrial dnsLogs);

        /**
         * <p>
         * Describes whether any DNS logs are enabled as data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceFreeTrial.Builder} avoiding the
         * need to create one manually via {@link DataSourceFreeTrial#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #dnsLogs(DataSourceFreeTrial)}.
         * 
         * @param dnsLogs
         *        a consumer that will call methods on {@link DataSourceFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsLogs(DataSourceFreeTrial)
         */
        default Builder dnsLogs(Consumer<DataSourceFreeTrial.Builder> dnsLogs) {
            return dnsLogs(DataSourceFreeTrial.builder().applyMutation(dnsLogs).build());
        }

        /**
         * <p>
         * Describes whether any VPC Flow logs are enabled as data sources.
         * </p>
         * 
         * @param flowLogs
         *        Describes whether any VPC Flow logs are enabled as data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogs(DataSourceFreeTrial flowLogs);

        /**
         * <p>
         * Describes whether any VPC Flow logs are enabled as data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceFreeTrial.Builder} avoiding the
         * need to create one manually via {@link DataSourceFreeTrial#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #flowLogs(DataSourceFreeTrial)}.
         * 
         * @param flowLogs
         *        a consumer that will call methods on {@link DataSourceFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowLogs(DataSourceFreeTrial)
         */
        default Builder flowLogs(Consumer<DataSourceFreeTrial.Builder> flowLogs) {
            return flowLogs(DataSourceFreeTrial.builder().applyMutation(flowLogs).build());
        }

        /**
         * <p>
         * Describes whether any S3 data event logs are enabled as data sources.
         * </p>
         * 
         * @param s3Logs
         *        Describes whether any S3 data event logs are enabled as data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(DataSourceFreeTrial s3Logs);

        /**
         * <p>
         * Describes whether any S3 data event logs are enabled as data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceFreeTrial.Builder} avoiding the
         * need to create one manually via {@link DataSourceFreeTrial#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Logs(DataSourceFreeTrial)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link DataSourceFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(DataSourceFreeTrial)
         */
        default Builder s3Logs(Consumer<DataSourceFreeTrial.Builder> s3Logs) {
            return s3Logs(DataSourceFreeTrial.builder().applyMutation(s3Logs).build());
        }

        /**
         * <p>
         * Describes whether any Kubernetes logs are enabled as data sources.
         * </p>
         * 
         * @param kubernetes
         *        Describes whether any Kubernetes logs are enabled as data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetes(KubernetesDataSourceFreeTrial kubernetes);

        /**
         * <p>
         * Describes whether any Kubernetes logs are enabled as data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesDataSourceFreeTrial.Builder}
         * avoiding the need to create one manually via {@link KubernetesDataSourceFreeTrial#builder()}.
         *
         * When the {@link Consumer} completes, {@link KubernetesDataSourceFreeTrial.Builder#build()} is called
         * immediately and its result is passed to {@link #kubernetes(KubernetesDataSourceFreeTrial)}.
         * 
         * @param kubernetes
         *        a consumer that will call methods on {@link KubernetesDataSourceFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetes(KubernetesDataSourceFreeTrial)
         */
        default Builder kubernetes(Consumer<KubernetesDataSourceFreeTrial.Builder> kubernetes) {
            return kubernetes(KubernetesDataSourceFreeTrial.builder().applyMutation(kubernetes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataSourceFreeTrial cloudTrail;

        private DataSourceFreeTrial dnsLogs;

        private DataSourceFreeTrial flowLogs;

        private DataSourceFreeTrial s3Logs;

        private KubernetesDataSourceFreeTrial kubernetes;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourcesFreeTrial model) {
            cloudTrail(model.cloudTrail);
            dnsLogs(model.dnsLogs);
            flowLogs(model.flowLogs);
            s3Logs(model.s3Logs);
            kubernetes(model.kubernetes);
        }

        public final DataSourceFreeTrial.Builder getCloudTrail() {
            return cloudTrail != null ? cloudTrail.toBuilder() : null;
        }

        public final void setCloudTrail(DataSourceFreeTrial.BuilderImpl cloudTrail) {
            this.cloudTrail = cloudTrail != null ? cloudTrail.build() : null;
        }

        @Override
        public final Builder cloudTrail(DataSourceFreeTrial cloudTrail) {
            this.cloudTrail = cloudTrail;
            return this;
        }

        public final DataSourceFreeTrial.Builder getDnsLogs() {
            return dnsLogs != null ? dnsLogs.toBuilder() : null;
        }

        public final void setDnsLogs(DataSourceFreeTrial.BuilderImpl dnsLogs) {
            this.dnsLogs = dnsLogs != null ? dnsLogs.build() : null;
        }

        @Override
        public final Builder dnsLogs(DataSourceFreeTrial dnsLogs) {
            this.dnsLogs = dnsLogs;
            return this;
        }

        public final DataSourceFreeTrial.Builder getFlowLogs() {
            return flowLogs != null ? flowLogs.toBuilder() : null;
        }

        public final void setFlowLogs(DataSourceFreeTrial.BuilderImpl flowLogs) {
            this.flowLogs = flowLogs != null ? flowLogs.build() : null;
        }

        @Override
        public final Builder flowLogs(DataSourceFreeTrial flowLogs) {
            this.flowLogs = flowLogs;
            return this;
        }

        public final DataSourceFreeTrial.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(DataSourceFreeTrial.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(DataSourceFreeTrial s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final KubernetesDataSourceFreeTrial.Builder getKubernetes() {
            return kubernetes != null ? kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(KubernetesDataSourceFreeTrial.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(KubernetesDataSourceFreeTrial kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        @Override
        public DataSourcesFreeTrial build() {
            return new DataSourcesFreeTrial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
