/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Kubernetes workload involved in a Kubernetes finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesWorkloadDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesWorkloadDetails.Builder, KubernetesWorkloadDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(KubernetesWorkloadDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(KubernetesWorkloadDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> UID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uid")
            .getter(getter(KubernetesWorkloadDetails::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(KubernetesWorkloadDetails::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<Boolean> HOST_NETWORK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HostNetwork").getter(getter(KubernetesWorkloadDetails::hostNetwork))
            .setter(setter(Builder::hostNetwork))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostNetwork").build()).build();

    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField
            .<List<Container>> builder(MarshallingType.LIST)
            .memberName("Containers")
            .getter(getter(KubernetesWorkloadDetails::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Container> builder(MarshallingType.SDK_POJO)
                                            .constructor(Container::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("Volumes")
            .getter(getter(KubernetesWorkloadDetails::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            UID_FIELD, NAMESPACE_FIELD, HOST_NETWORK_FIELD, CONTAINERS_FIELD, VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String uid;

    private final String namespace;

    private final Boolean hostNetwork;

    private final List<Container> containers;

    private final List<Volume> volumes;

    private KubernetesWorkloadDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.uid = builder.uid;
        this.namespace = builder.namespace;
        this.hostNetwork = builder.hostNetwork;
        this.containers = builder.containers;
        this.volumes = builder.volumes;
    }

    /**
     * <p>
     * Kubernetes workload name.
     * </p>
     * 
     * @return Kubernetes workload name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Kubernetes workload type (e.g. Pod, Deployment, etc.).
     * </p>
     * 
     * @return Kubernetes workload type (e.g. Pod, Deployment, etc.).
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Kubernetes workload ID.
     * </p>
     * 
     * @return Kubernetes workload ID.
     */
    public final String uid() {
        return uid;
    }

    /**
     * <p>
     * Kubernetes namespace that the workload is part of.
     * </p>
     * 
     * @return Kubernetes namespace that the workload is part of.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * Whether the hostNetwork flag is enabled for the pods included in the workload.
     * </p>
     * 
     * @return Whether the hostNetwork flag is enabled for the pods included in the workload.
     */
    public final Boolean hostNetwork() {
        return hostNetwork;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Containers running as part of the Kubernetes workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return Containers running as part of the Kubernetes workload.
     */
    public final List<Container> containers() {
        return containers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Volumes used by the Kubernetes workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return Volumes used by the Kubernetes workload.
     */
    public final List<Volume> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hostNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesWorkloadDetails)) {
            return false;
        }
        KubernetesWorkloadDetails other = (KubernetesWorkloadDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type()) && Objects.equals(uid(), other.uid())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(hostNetwork(), other.hostNetwork())
                && hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && hasVolumes() == other.hasVolumes() && Objects.equals(volumes(), other.volumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesWorkloadDetails").add("Name", name()).add("Type", type()).add("Uid", uid())
                .add("Namespace", namespace()).add("HostNetwork", hostNetwork())
                .add("Containers", hasContainers() ? containers() : null).add("Volumes", hasVolumes() ? volumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "HostNetwork":
            return Optional.ofNullable(clazz.cast(hostNetwork()));
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "Volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesWorkloadDetails, T> g) {
        return obj -> g.apply((KubernetesWorkloadDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesWorkloadDetails> {
        /**
         * <p>
         * Kubernetes workload name.
         * </p>
         * 
         * @param name
         *        Kubernetes workload name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Kubernetes workload type (e.g. Pod, Deployment, etc.).
         * </p>
         * 
         * @param type
         *        Kubernetes workload type (e.g. Pod, Deployment, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Kubernetes workload ID.
         * </p>
         * 
         * @param uid
         *        Kubernetes workload ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(String uid);

        /**
         * <p>
         * Kubernetes namespace that the workload is part of.
         * </p>
         * 
         * @param namespace
         *        Kubernetes namespace that the workload is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * Whether the hostNetwork flag is enabled for the pods included in the workload.
         * </p>
         * 
         * @param hostNetwork
         *        Whether the hostNetwork flag is enabled for the pods included in the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostNetwork(Boolean hostNetwork);

        /**
         * <p>
         * Containers running as part of the Kubernetes workload.
         * </p>
         * 
         * @param containers
         *        Containers running as part of the Kubernetes workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<Container> containers);

        /**
         * <p>
         * Containers running as part of the Kubernetes workload.
         * </p>
         * 
         * @param containers
         *        Containers running as part of the Kubernetes workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Container... containers);

        /**
         * <p>
         * Containers running as part of the Kubernetes workload.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Container>.Builder} avoiding the
         * need to create one manually via {@link List<Container>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Container>.Builder#build()} is called immediately and its
         * result is passed to {@link #containers(List<Container>)}.
         * 
         * @param containers
         *        a consumer that will call methods on {@link List<Container>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(List<Container>)
         */
        Builder containers(Consumer<Container.Builder>... containers);

        /**
         * <p>
         * Volumes used by the Kubernetes workload.
         * </p>
         * 
         * @param volumes
         *        Volumes used by the Kubernetes workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * Volumes used by the Kubernetes workload.
         * </p>
         * 
         * @param volumes
         *        Volumes used by the Kubernetes workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * Volumes used by the Kubernetes workload.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Volume>.Builder} avoiding the need
         * to create one manually via {@link List<Volume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Volume>.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on {@link List<Volume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(List<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String uid;

        private String namespace;

        private Boolean hostNetwork;

        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesWorkloadDetails model) {
            name(model.name);
            type(model.type);
            uid(model.uid);
            namespace(model.namespace);
            hostNetwork(model.hostNetwork);
            containers(model.containers);
            volumes(model.volumes);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getUid() {
            return uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Boolean getHostNetwork() {
            return hostNetwork;
        }

        public final void setHostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
        }

        @Override
        public final Builder hostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainersCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder>... containers) {
            containers(Stream.of(containers).map(c -> Container.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public KubernetesWorkloadDetails build() {
            return new KubernetesWorkloadDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
