/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the port probe details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortProbeDetail implements SdkPojo, Serializable, ToCopyableBuilder<PortProbeDetail.Builder, PortProbeDetail> {
    private static final SdkField<LocalPortDetails> LOCAL_PORT_DETAILS_FIELD = SdkField
            .<LocalPortDetails> builder(MarshallingType.SDK_POJO).memberName("LocalPortDetails")
            .getter(getter(PortProbeDetail::localPortDetails)).setter(setter(Builder::localPortDetails))
            .constructor(LocalPortDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPortDetails").build()).build();

    private static final SdkField<LocalIpDetails> LOCAL_IP_DETAILS_FIELD = SdkField
            .<LocalIpDetails> builder(MarshallingType.SDK_POJO).memberName("LocalIpDetails")
            .getter(getter(PortProbeDetail::localIpDetails)).setter(setter(Builder::localIpDetails))
            .constructor(LocalIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localIpDetails").build()).build();

    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<RemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(PortProbeDetail::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(RemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PORT_DETAILS_FIELD,
            LOCAL_IP_DETAILS_FIELD, REMOTE_IP_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LocalPortDetails localPortDetails;

    private final LocalIpDetails localIpDetails;

    private final RemoteIpDetails remoteIpDetails;

    private PortProbeDetail(BuilderImpl builder) {
        this.localPortDetails = builder.localPortDetails;
        this.localIpDetails = builder.localIpDetails;
        this.remoteIpDetails = builder.remoteIpDetails;
    }

    /**
     * <p>
     * The local port information of the connection.
     * </p>
     * 
     * @return The local port information of the connection.
     */
    public final LocalPortDetails localPortDetails() {
        return localPortDetails;
    }

    /**
     * <p>
     * The local IP information of the connection.
     * </p>
     * 
     * @return The local IP information of the connection.
     */
    public final LocalIpDetails localIpDetails() {
        return localIpDetails;
    }

    /**
     * <p>
     * The remote IP information of the connection.
     * </p>
     * 
     * @return The remote IP information of the connection.
     */
    public final RemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(localIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortProbeDetail)) {
            return false;
        }
        PortProbeDetail other = (PortProbeDetail) obj;
        return Objects.equals(localPortDetails(), other.localPortDetails())
                && Objects.equals(localIpDetails(), other.localIpDetails())
                && Objects.equals(remoteIpDetails(), other.remoteIpDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortProbeDetail").add("LocalPortDetails", localPortDetails())
                .add("LocalIpDetails", localIpDetails()).add("RemoteIpDetails", remoteIpDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalPortDetails":
            return Optional.ofNullable(clazz.cast(localPortDetails()));
        case "LocalIpDetails":
            return Optional.ofNullable(clazz.cast(localIpDetails()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortProbeDetail, T> g) {
        return obj -> g.apply((PortProbeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortProbeDetail> {
        /**
         * <p>
         * The local port information of the connection.
         * </p>
         * 
         * @param localPortDetails
         *        The local port information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPortDetails(LocalPortDetails localPortDetails);

        /**
         * <p>
         * The local port information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalPortDetails.Builder} avoiding the
         * need to create one manually via {@link LocalPortDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LocalPortDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #localPortDetails(LocalPortDetails)}.
         * 
         * @param localPortDetails
         *        a consumer that will call methods on {@link LocalPortDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localPortDetails(LocalPortDetails)
         */
        default Builder localPortDetails(Consumer<LocalPortDetails.Builder> localPortDetails) {
            return localPortDetails(LocalPortDetails.builder().applyMutation(localPortDetails).build());
        }

        /**
         * <p>
         * The local IP information of the connection.
         * </p>
         * 
         * @param localIpDetails
         *        The local IP information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpDetails(LocalIpDetails localIpDetails);

        /**
         * <p>
         * The local IP information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalIpDetails.Builder} avoiding the need
         * to create one manually via {@link LocalIpDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LocalIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #localIpDetails(LocalIpDetails)}.
         * 
         * @param localIpDetails
         *        a consumer that will call methods on {@link LocalIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localIpDetails(LocalIpDetails)
         */
        default Builder localIpDetails(Consumer<LocalIpDetails.Builder> localIpDetails) {
            return localIpDetails(LocalIpDetails.builder().applyMutation(localIpDetails).build());
        }

        /**
         * <p>
         * The remote IP information of the connection.
         * </p>
         * 
         * @param remoteIpDetails
         *        The remote IP information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(RemoteIpDetails remoteIpDetails);

        /**
         * <p>
         * The remote IP information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link RemoteIpDetails.Builder} avoiding the
         * need to create one manually via {@link RemoteIpDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemoteIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteIpDetails(RemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link RemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(RemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(RemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LocalPortDetails localPortDetails;

        private LocalIpDetails localIpDetails;

        private RemoteIpDetails remoteIpDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PortProbeDetail model) {
            localPortDetails(model.localPortDetails);
            localIpDetails(model.localIpDetails);
            remoteIpDetails(model.remoteIpDetails);
        }

        public final LocalPortDetails.Builder getLocalPortDetails() {
            return localPortDetails != null ? localPortDetails.toBuilder() : null;
        }

        public final void setLocalPortDetails(LocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        @Override
        public final Builder localPortDetails(LocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final LocalIpDetails.Builder getLocalIpDetails() {
            return localIpDetails != null ? localIpDetails.toBuilder() : null;
        }

        public final void setLocalIpDetails(LocalIpDetails.BuilderImpl localIpDetails) {
            this.localIpDetails = localIpDetails != null ? localIpDetails.build() : null;
        }

        @Override
        public final Builder localIpDetails(LocalIpDetails localIpDetails) {
            this.localIpDetails = localIpDetails;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        @Override
        public PortProbeDetail build() {
            return new PortProbeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
