/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about which data sources are enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfigurations.Builder, DataSourceConfigurations> {
    private static final SdkField<S3LogsConfiguration> S3_LOGS_FIELD = SdkField
            .<S3LogsConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(DataSourceConfigurations::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(S3LogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final SdkField<KubernetesConfiguration> KUBERNETES_FIELD = SdkField
            .<KubernetesConfiguration> builder(MarshallingType.SDK_POJO).memberName("Kubernetes")
            .getter(getter(DataSourceConfigurations::kubernetes)).setter(setter(Builder::kubernetes))
            .constructor(KubernetesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetes").build()).build();

    private static final SdkField<MalwareProtectionConfiguration> MALWARE_PROTECTION_FIELD = SdkField
            .<MalwareProtectionConfiguration> builder(MarshallingType.SDK_POJO).memberName("MalwareProtection")
            .getter(getter(DataSourceConfigurations::malwareProtection)).setter(setter(Builder::malwareProtection))
            .constructor(MalwareProtectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOGS_FIELD,
            KUBERNETES_FIELD, MALWARE_PROTECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3LogsConfiguration s3Logs;

    private final KubernetesConfiguration kubernetes;

    private final MalwareProtectionConfiguration malwareProtection;

    private DataSourceConfigurations(BuilderImpl builder) {
        this.s3Logs = builder.s3Logs;
        this.kubernetes = builder.kubernetes;
        this.malwareProtection = builder.malwareProtection;
    }

    /**
     * <p>
     * Describes whether S3 data event logs are enabled as a data source.
     * </p>
     * 
     * @return Describes whether S3 data event logs are enabled as a data source.
     */
    public final S3LogsConfiguration s3Logs() {
        return s3Logs;
    }

    /**
     * <p>
     * Describes whether any Kubernetes logs are enabled as data sources.
     * </p>
     * 
     * @return Describes whether any Kubernetes logs are enabled as data sources.
     */
    public final KubernetesConfiguration kubernetes() {
        return kubernetes;
    }

    /**
     * <p>
     * Describes whether Malware Protection is enabled as a data source.
     * </p>
     * 
     * @return Describes whether Malware Protection is enabled as a data source.
     */
    public final MalwareProtectionConfiguration malwareProtection() {
        return malwareProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetes());
        hashCode = 31 * hashCode + Objects.hashCode(malwareProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurations)) {
            return false;
        }
        DataSourceConfigurations other = (DataSourceConfigurations) obj;
        return Objects.equals(s3Logs(), other.s3Logs()) && Objects.equals(kubernetes(), other.kubernetes())
                && Objects.equals(malwareProtection(), other.malwareProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfigurations").add("S3Logs", s3Logs()).add("Kubernetes", kubernetes())
                .add("MalwareProtection", malwareProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        case "Kubernetes":
            return Optional.ofNullable(clazz.cast(kubernetes()));
        case "MalwareProtection":
            return Optional.ofNullable(clazz.cast(malwareProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurations, T> g) {
        return obj -> g.apply((DataSourceConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfigurations> {
        /**
         * <p>
         * Describes whether S3 data event logs are enabled as a data source.
         * </p>
         * 
         * @param s3Logs
         *        Describes whether S3 data event logs are enabled as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(S3LogsConfiguration s3Logs);

        /**
         * <p>
         * Describes whether S3 data event logs are enabled as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3LogsConfiguration.Builder} avoiding the
         * need to create one manually via {@link S3LogsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3LogsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Logs(S3LogsConfiguration)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link S3LogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(S3LogsConfiguration)
         */
        default Builder s3Logs(Consumer<S3LogsConfiguration.Builder> s3Logs) {
            return s3Logs(S3LogsConfiguration.builder().applyMutation(s3Logs).build());
        }

        /**
         * <p>
         * Describes whether any Kubernetes logs are enabled as data sources.
         * </p>
         * 
         * @param kubernetes
         *        Describes whether any Kubernetes logs are enabled as data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetes(KubernetesConfiguration kubernetes);

        /**
         * <p>
         * Describes whether any Kubernetes logs are enabled as data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesConfiguration.Builder} avoiding
         * the need to create one manually via {@link KubernetesConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KubernetesConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #kubernetes(KubernetesConfiguration)}.
         * 
         * @param kubernetes
         *        a consumer that will call methods on {@link KubernetesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetes(KubernetesConfiguration)
         */
        default Builder kubernetes(Consumer<KubernetesConfiguration.Builder> kubernetes) {
            return kubernetes(KubernetesConfiguration.builder().applyMutation(kubernetes).build());
        }

        /**
         * <p>
         * Describes whether Malware Protection is enabled as a data source.
         * </p>
         * 
         * @param malwareProtection
         *        Describes whether Malware Protection is enabled as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtection(MalwareProtectionConfiguration malwareProtection);

        /**
         * <p>
         * Describes whether Malware Protection is enabled as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link MalwareProtectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link MalwareProtectionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MalwareProtectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #malwareProtection(MalwareProtectionConfiguration)}.
         * 
         * @param malwareProtection
         *        a consumer that will call methods on {@link MalwareProtectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareProtection(MalwareProtectionConfiguration)
         */
        default Builder malwareProtection(Consumer<MalwareProtectionConfiguration.Builder> malwareProtection) {
            return malwareProtection(MalwareProtectionConfiguration.builder().applyMutation(malwareProtection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3LogsConfiguration s3Logs;

        private KubernetesConfiguration kubernetes;

        private MalwareProtectionConfiguration malwareProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurations model) {
            s3Logs(model.s3Logs);
            kubernetes(model.kubernetes);
            malwareProtection(model.malwareProtection);
        }

        public final S3LogsConfiguration.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfiguration.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfiguration s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final KubernetesConfiguration.Builder getKubernetes() {
            return kubernetes != null ? kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(KubernetesConfiguration.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(KubernetesConfiguration kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        public final MalwareProtectionConfiguration.Builder getMalwareProtection() {
            return malwareProtection != null ? malwareProtection.toBuilder() : null;
        }

        public final void setMalwareProtection(MalwareProtectionConfiguration.BuilderImpl malwareProtection) {
            this.malwareProtection = malwareProtection != null ? malwareProtection.build() : null;
        }

        @Override
        public final Builder malwareProtection(MalwareProtectionConfiguration malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        @Override
        public DataSourceConfigurations build() {
            return new DataSourceConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
