/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRemainingFreeTrialDaysResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetRemainingFreeTrialDaysResponse.Builder, GetRemainingFreeTrialDaysResponse> {
    private static final SdkField<List<AccountFreeTrialInfo>> ACCOUNTS_FIELD = SdkField
            .<List<AccountFreeTrialInfo>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(GetRemainingFreeTrialDaysResponse::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountFreeTrialInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountFreeTrialInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAccounts")
            .getter(getter(GetRemainingFreeTrialDaysResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD,
            UNPROCESSED_ACCOUNTS_FIELD));

    private final List<AccountFreeTrialInfo> accounts;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private GetRemainingFreeTrialDaysResponse(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The member accounts which were included in a request and were processed successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return The member accounts which were included in a request and were processed successfully.
     */
    public final List<AccountFreeTrialInfo> accounts() {
        return accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The member account that was included in a request but for which the request could not be processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAccounts} method.
     * </p>
     * 
     * @return The member account that was included in a request but for which the request could not be processed.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRemainingFreeTrialDaysResponse)) {
            return false;
        }
        GetRemainingFreeTrialDaysResponse other = (GetRemainingFreeTrialDaysResponse) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRemainingFreeTrialDaysResponse").add("Accounts", hasAccounts() ? accounts() : null)
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRemainingFreeTrialDaysResponse, T> g) {
        return obj -> g.apply((GetRemainingFreeTrialDaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRemainingFreeTrialDaysResponse> {
        /**
         * <p>
         * The member accounts which were included in a request and were processed successfully.
         * </p>
         * 
         * @param accounts
         *        The member accounts which were included in a request and were processed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<AccountFreeTrialInfo> accounts);

        /**
         * <p>
         * The member accounts which were included in a request and were processed successfully.
         * </p>
         * 
         * @param accounts
         *        The member accounts which were included in a request and were processed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(AccountFreeTrialInfo... accounts);

        /**
         * <p>
         * The member accounts which were included in a request and were processed successfully.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AccountFreeTrialInfo>.Builder}
         * avoiding the need to create one manually via {@link List<AccountFreeTrialInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountFreeTrialInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #accounts(List<AccountFreeTrialInfo>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on {@link List<AccountFreeTrialInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(List<AccountFreeTrialInfo>)
         */
        Builder accounts(Consumer<AccountFreeTrialInfo.Builder>... accounts);

        /**
         * <p>
         * The member account that was included in a request but for which the request could not be processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The member account that was included in a request but for which the request could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * The member account that was included in a request but for which the request could not be processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The member account that was included in a request but for which the request could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * The member account that was included in a request but for which the request could not be processed.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UnprocessedAccount>.Builder}
         * avoiding the need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<AccountFreeTrialInfo> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRemainingFreeTrialDaysResponse model) {
            super(model);
            accounts(model.accounts);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<AccountFreeTrialInfo.Builder> getAccounts() {
            List<AccountFreeTrialInfo.Builder> result = AccountFreeTrialInfosCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<AccountFreeTrialInfo.BuilderImpl> accounts) {
            this.accounts = AccountFreeTrialInfosCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<AccountFreeTrialInfo> accounts) {
            this.accounts = AccountFreeTrialInfosCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(AccountFreeTrialInfo... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<AccountFreeTrialInfo.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> AccountFreeTrialInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountsCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRemainingFreeTrialDaysResponse build() {
            return new GetRemainingFreeTrialDaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
