/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Organization-wide EC2 instances with findings scan configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationScanEc2InstanceWithFindings implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationScanEc2InstanceWithFindings.Builder, OrganizationScanEc2InstanceWithFindings> {
    private static final SdkField<OrganizationEbsVolumes> EBS_VOLUMES_FIELD = SdkField
            .<OrganizationEbsVolumes> builder(MarshallingType.SDK_POJO).memberName("EbsVolumes")
            .getter(getter(OrganizationScanEc2InstanceWithFindings::ebsVolumes)).setter(setter(Builder::ebsVolumes))
            .constructor(OrganizationEbsVolumes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final OrganizationEbsVolumes ebsVolumes;

    private OrganizationScanEc2InstanceWithFindings(BuilderImpl builder) {
        this.ebsVolumes = builder.ebsVolumes;
    }

    /**
     * <p>
     * Whether scanning EBS volumes should be auto-enabled for new members joining the organization.
     * </p>
     * 
     * @return Whether scanning EBS volumes should be auto-enabled for new members joining the organization.
     */
    public final OrganizationEbsVolumes ebsVolumes() {
        return ebsVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationScanEc2InstanceWithFindings)) {
            return false;
        }
        OrganizationScanEc2InstanceWithFindings other = (OrganizationScanEc2InstanceWithFindings) obj;
        return Objects.equals(ebsVolumes(), other.ebsVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationScanEc2InstanceWithFindings").add("EbsVolumes", ebsVolumes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsVolumes":
            return Optional.ofNullable(clazz.cast(ebsVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationScanEc2InstanceWithFindings, T> g) {
        return obj -> g.apply((OrganizationScanEc2InstanceWithFindings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationScanEc2InstanceWithFindings> {
        /**
         * <p>
         * Whether scanning EBS volumes should be auto-enabled for new members joining the organization.
         * </p>
         * 
         * @param ebsVolumes
         *        Whether scanning EBS volumes should be auto-enabled for new members joining the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumes(OrganizationEbsVolumes ebsVolumes);

        /**
         * <p>
         * Whether scanning EBS volumes should be auto-enabled for new members joining the organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationEbsVolumes.Builder} avoiding
         * the need to create one manually via {@link OrganizationEbsVolumes#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationEbsVolumes.Builder#build()} is called immediately and
         * its result is passed to {@link #ebsVolumes(OrganizationEbsVolumes)}.
         * 
         * @param ebsVolumes
         *        a consumer that will call methods on {@link OrganizationEbsVolumes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsVolumes(OrganizationEbsVolumes)
         */
        default Builder ebsVolumes(Consumer<OrganizationEbsVolumes.Builder> ebsVolumes) {
            return ebsVolumes(OrganizationEbsVolumes.builder().applyMutation(ebsVolumes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrganizationEbsVolumes ebsVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationScanEc2InstanceWithFindings model) {
            ebsVolumes(model.ebsVolumes);
        }

        public final OrganizationEbsVolumes.Builder getEbsVolumes() {
            return ebsVolumes != null ? ebsVolumes.toBuilder() : null;
        }

        public final void setEbsVolumes(OrganizationEbsVolumes.BuilderImpl ebsVolumes) {
            this.ebsVolumes = ebsVolumes != null ? ebsVolumes.build() : null;
        }

        @Override
        public final Builder ebsVolumes(OrganizationEbsVolumes ebsVolumes) {
            this.ebsVolumes = ebsVolumes;
            return this;
        }

        @Override
        public OrganizationScanEc2InstanceWithFindings build() {
            return new OrganizationScanEc2InstanceWithFindings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
