/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information on the status of scanning EC2 instances with findings for an organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationScanEc2InstanceWithFindingsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationScanEc2InstanceWithFindingsResult.Builder, OrganizationScanEc2InstanceWithFindingsResult> {
    private static final SdkField<OrganizationEbsVolumesResult> EBS_VOLUMES_FIELD = SdkField
            .<OrganizationEbsVolumesResult> builder(MarshallingType.SDK_POJO).memberName("EbsVolumes")
            .getter(getter(OrganizationScanEc2InstanceWithFindingsResult::ebsVolumes)).setter(setter(Builder::ebsVolumes))
            .constructor(OrganizationEbsVolumesResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final OrganizationEbsVolumesResult ebsVolumes;

    private OrganizationScanEc2InstanceWithFindingsResult(BuilderImpl builder) {
        this.ebsVolumes = builder.ebsVolumes;
    }

    /**
     * <p>
     * Describes the configuration for scanning EBS volumes for an organization.
     * </p>
     * 
     * @return Describes the configuration for scanning EBS volumes for an organization.
     */
    public final OrganizationEbsVolumesResult ebsVolumes() {
        return ebsVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationScanEc2InstanceWithFindingsResult)) {
            return false;
        }
        OrganizationScanEc2InstanceWithFindingsResult other = (OrganizationScanEc2InstanceWithFindingsResult) obj;
        return Objects.equals(ebsVolumes(), other.ebsVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationScanEc2InstanceWithFindingsResult").add("EbsVolumes", ebsVolumes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsVolumes":
            return Optional.ofNullable(clazz.cast(ebsVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationScanEc2InstanceWithFindingsResult, T> g) {
        return obj -> g.apply((OrganizationScanEc2InstanceWithFindingsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationScanEc2InstanceWithFindingsResult> {
        /**
         * <p>
         * Describes the configuration for scanning EBS volumes for an organization.
         * </p>
         * 
         * @param ebsVolumes
         *        Describes the configuration for scanning EBS volumes for an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumes(OrganizationEbsVolumesResult ebsVolumes);

        /**
         * <p>
         * Describes the configuration for scanning EBS volumes for an organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationEbsVolumesResult.Builder}
         * avoiding the need to create one manually via {@link OrganizationEbsVolumesResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationEbsVolumesResult.Builder#build()} is called
         * immediately and its result is passed to {@link #ebsVolumes(OrganizationEbsVolumesResult)}.
         * 
         * @param ebsVolumes
         *        a consumer that will call methods on {@link OrganizationEbsVolumesResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsVolumes(OrganizationEbsVolumesResult)
         */
        default Builder ebsVolumes(Consumer<OrganizationEbsVolumesResult.Builder> ebsVolumes) {
            return ebsVolumes(OrganizationEbsVolumesResult.builder().applyMutation(ebsVolumes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrganizationEbsVolumesResult ebsVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationScanEc2InstanceWithFindingsResult model) {
            ebsVolumes(model.ebsVolumes);
        }

        public final OrganizationEbsVolumesResult.Builder getEbsVolumes() {
            return ebsVolumes != null ? ebsVolumes.toBuilder() : null;
        }

        public final void setEbsVolumes(OrganizationEbsVolumesResult.BuilderImpl ebsVolumes) {
            this.ebsVolumes = ebsVolumes != null ? ebsVolumes.build() : null;
        }

        @Override
        public final Builder ebsVolumes(OrganizationEbsVolumesResult ebsVolumes) {
            this.ebsVolumes = ebsVolumes;
            return this;
        }

        @Override
        public OrganizationScanEc2InstanceWithFindingsResult build() {
            return new OrganizationScanEc2InstanceWithFindingsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
