/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanCondition implements SdkPojo, Serializable, ToCopyableBuilder<ScanCondition.Builder, ScanCondition> {
    private static final SdkField<List<ScanConditionPair>> MAP_EQUALS_FIELD = SdkField
            .<List<ScanConditionPair>> builder(MarshallingType.LIST)
            .memberName("MapEquals")
            .getter(getter(ScanCondition::mapEquals))
            .setter(setter(Builder::mapEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanConditionPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanConditionPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_EQUALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ScanConditionPair> mapEquals;

    private ScanCondition(BuilderImpl builder) {
        this.mapEquals = builder.mapEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapEquals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapEquals() {
        return mapEquals != null && !(mapEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for malware scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapEquals} method.
     * </p>
     * 
     * @return Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for malware
     *         scan.
     */
    public final List<ScanConditionPair> mapEquals() {
        return mapEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMapEquals() ? mapEquals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanCondition)) {
            return false;
        }
        ScanCondition other = (ScanCondition) obj;
        return hasMapEquals() == other.hasMapEquals() && Objects.equals(mapEquals(), other.mapEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanCondition").add("MapEquals", hasMapEquals() ? mapEquals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapEquals":
            return Optional.ofNullable(clazz.cast(mapEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanCondition, T> g) {
        return obj -> g.apply((ScanCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanCondition> {
        /**
         * <p>
         * Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for malware
         * scan.
         * </p>
         * 
         * @param mapEquals
         *        Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for
         *        malware scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapEquals(Collection<ScanConditionPair> mapEquals);

        /**
         * <p>
         * Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for malware
         * scan.
         * </p>
         * 
         * @param mapEquals
         *        Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for
         *        malware scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapEquals(ScanConditionPair... mapEquals);

        /**
         * <p>
         * Represents an <i>mapEqual</i> <b/> condition to be applied to a single field when triggering for malware
         * scan.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ScanConditionPair>.Builder} avoiding
         * the need to create one manually via {@link List<ScanConditionPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScanConditionPair>.Builder#build()} is called immediately
         * and its result is passed to {@link #mapEquals(List<ScanConditionPair>)}.
         * 
         * @param mapEquals
         *        a consumer that will call methods on {@link List<ScanConditionPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapEquals(List<ScanConditionPair>)
         */
        Builder mapEquals(Consumer<ScanConditionPair.Builder>... mapEquals);
    }

    static final class BuilderImpl implements Builder {
        private List<ScanConditionPair> mapEquals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScanCondition model) {
            mapEquals(model.mapEquals);
        }

        public final List<ScanConditionPair.Builder> getMapEquals() {
            List<ScanConditionPair.Builder> result = MapEqualsCopier.copyToBuilder(this.mapEquals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapEquals(Collection<ScanConditionPair.BuilderImpl> mapEquals) {
            this.mapEquals = MapEqualsCopier.copyFromBuilder(mapEquals);
        }

        @Override
        public final Builder mapEquals(Collection<ScanConditionPair> mapEquals) {
            this.mapEquals = MapEqualsCopier.copy(mapEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEquals(ScanConditionPair... mapEquals) {
            mapEquals(Arrays.asList(mapEquals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEquals(Consumer<ScanConditionPair.Builder>... mapEquals) {
            mapEquals(Stream.of(mapEquals).map(c -> ScanConditionPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ScanCondition build() {
            return new ScanCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
