/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMalwareScanSettingsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetMalwareScanSettingsResponse.Builder, GetMalwareScanSettingsResponse> {
    private static final SdkField<ScanResourceCriteria> SCAN_RESOURCE_CRITERIA_FIELD = SdkField
            .<ScanResourceCriteria> builder(MarshallingType.SDK_POJO).memberName("ScanResourceCriteria")
            .getter(getter(GetMalwareScanSettingsResponse::scanResourceCriteria)).setter(setter(Builder::scanResourceCriteria))
            .constructor(ScanResourceCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResourceCriteria").build())
            .build();

    private static final SdkField<String> EBS_SNAPSHOT_PRESERVATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsSnapshotPreservation")
            .getter(getter(GetMalwareScanSettingsResponse::ebsSnapshotPreservationAsString))
            .setter(setter(Builder::ebsSnapshotPreservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshotPreservation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_RESOURCE_CRITERIA_FIELD,
            EBS_SNAPSHOT_PRESERVATION_FIELD));

    private final ScanResourceCriteria scanResourceCriteria;

    private final String ebsSnapshotPreservation;

    private GetMalwareScanSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.scanResourceCriteria = builder.scanResourceCriteria;
        this.ebsSnapshotPreservation = builder.ebsSnapshotPreservation;
    }

    /**
     * <p>
     * Represents the criteria to be used in the filter for scanning resources.
     * </p>
     * 
     * @return Represents the criteria to be used in the filter for scanning resources.
     */
    public final ScanResourceCriteria scanResourceCriteria() {
        return scanResourceCriteria;
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ebsSnapshotPreservation} will return {@link EbsSnapshotPreservation#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ebsSnapshotPreservationAsString}.
     * </p>
     * 
     * @return An enum value representing possible snapshot preservations.
     * @see EbsSnapshotPreservation
     */
    public final EbsSnapshotPreservation ebsSnapshotPreservation() {
        return EbsSnapshotPreservation.fromValue(ebsSnapshotPreservation);
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ebsSnapshotPreservation} will return {@link EbsSnapshotPreservation#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ebsSnapshotPreservationAsString}.
     * </p>
     * 
     * @return An enum value representing possible snapshot preservations.
     * @see EbsSnapshotPreservation
     */
    public final String ebsSnapshotPreservationAsString() {
        return ebsSnapshotPreservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanResourceCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(ebsSnapshotPreservationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMalwareScanSettingsResponse)) {
            return false;
        }
        GetMalwareScanSettingsResponse other = (GetMalwareScanSettingsResponse) obj;
        return Objects.equals(scanResourceCriteria(), other.scanResourceCriteria())
                && Objects.equals(ebsSnapshotPreservationAsString(), other.ebsSnapshotPreservationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMalwareScanSettingsResponse").add("ScanResourceCriteria", scanResourceCriteria())
                .add("EbsSnapshotPreservation", ebsSnapshotPreservationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScanResourceCriteria":
            return Optional.ofNullable(clazz.cast(scanResourceCriteria()));
        case "EbsSnapshotPreservation":
            return Optional.ofNullable(clazz.cast(ebsSnapshotPreservationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMalwareScanSettingsResponse, T> g) {
        return obj -> g.apply((GetMalwareScanSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMalwareScanSettingsResponse> {
        /**
         * <p>
         * Represents the criteria to be used in the filter for scanning resources.
         * </p>
         * 
         * @param scanResourceCriteria
         *        Represents the criteria to be used in the filter for scanning resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanResourceCriteria(ScanResourceCriteria scanResourceCriteria);

        /**
         * <p>
         * Represents the criteria to be used in the filter for scanning resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScanResourceCriteria.Builder} avoiding
         * the need to create one manually via {@link ScanResourceCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanResourceCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #scanResourceCriteria(ScanResourceCriteria)}.
         * 
         * @param scanResourceCriteria
         *        a consumer that will call methods on {@link ScanResourceCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanResourceCriteria(ScanResourceCriteria)
         */
        default Builder scanResourceCriteria(Consumer<ScanResourceCriteria.Builder> scanResourceCriteria) {
            return scanResourceCriteria(ScanResourceCriteria.builder().applyMutation(scanResourceCriteria).build());
        }

        /**
         * <p>
         * An enum value representing possible snapshot preservations.
         * </p>
         * 
         * @param ebsSnapshotPreservation
         *        An enum value representing possible snapshot preservations.
         * @see EbsSnapshotPreservation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsSnapshotPreservation
         */
        Builder ebsSnapshotPreservation(String ebsSnapshotPreservation);

        /**
         * <p>
         * An enum value representing possible snapshot preservations.
         * </p>
         * 
         * @param ebsSnapshotPreservation
         *        An enum value representing possible snapshot preservations.
         * @see EbsSnapshotPreservation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsSnapshotPreservation
         */
        Builder ebsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private ScanResourceCriteria scanResourceCriteria;

        private String ebsSnapshotPreservation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMalwareScanSettingsResponse model) {
            super(model);
            scanResourceCriteria(model.scanResourceCriteria);
            ebsSnapshotPreservation(model.ebsSnapshotPreservation);
        }

        public final ScanResourceCriteria.Builder getScanResourceCriteria() {
            return scanResourceCriteria != null ? scanResourceCriteria.toBuilder() : null;
        }

        public final void setScanResourceCriteria(ScanResourceCriteria.BuilderImpl scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria != null ? scanResourceCriteria.build() : null;
        }

        @Override
        public final Builder scanResourceCriteria(ScanResourceCriteria scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria;
            return this;
        }

        public final String getEbsSnapshotPreservation() {
            return ebsSnapshotPreservation;
        }

        public final void setEbsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
        }

        @Override
        public final Builder ebsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
            return this;
        }

        @Override
        public final Builder ebsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation(ebsSnapshotPreservation == null ? null : ebsSnapshotPreservation.toString());
            return this;
        }

        @Override
        public GetMalwareScanSettingsResponse build() {
            return new GetMalwareScanSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
