/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DestinationType;
import software.amazon.awssdk.services.guardduty.model.PublishingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationId").getter(Destination.getter(Destination::destinationId)).setter(Destination.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationId").build()}).build();
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(Destination.getter(Destination::destinationTypeAsString)).setter(Destination.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Destination.getter(Destination::statusAsString)).setter(Destination.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ID_FIELD, DESTINATION_TYPE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationId;
    private final String destinationType;
    private final String status;

    private Destination(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.destinationType = builder.destinationType;
        this.status = builder.status;
    }

    public final String destinationId() {
        return this.destinationId;
    }

    public final DestinationType destinationType() {
        return DestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final PublishingStatus status() {
        return PublishingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("DestinationId", (Object)this.destinationId()).add("DestinationType", (Object)this.destinationTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationId;
        private String destinationType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.destinationId(model.destinationId);
            this.destinationType(model.destinationType);
            this.status(model.status);
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        @Transient
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        @Transient
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        @Transient
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(PublishingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder destinationId(String var1);

        public Builder destinationType(String var1);

        public Builder destinationType(DestinationType var1);

        public Builder status(String var1);

        public Builder status(PublishingStatus var1);
    }
}

