/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AccessControlList;
import software.amazon.awssdk.services.guardduty.model.BlockPublicAccess;
import software.amazon.awssdk.services.guardduty.model.BucketPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketLevelPermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketLevelPermissions> {
    private static final SdkField<AccessControlList> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessControlList").getter(BucketLevelPermissions.getter(BucketLevelPermissions::accessControlList)).setter(BucketLevelPermissions.setter(Builder::accessControlList)).constructor(AccessControlList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControlList").build()}).build();
    private static final SdkField<BucketPolicy> BUCKET_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketPolicy").getter(BucketLevelPermissions.getter(BucketLevelPermissions::bucketPolicy)).setter(BucketLevelPermissions.setter(Builder::bucketPolicy)).constructor(BucketPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPolicy").build()}).build();
    private static final SdkField<BlockPublicAccess> BLOCK_PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlockPublicAccess").getter(BucketLevelPermissions.getter(BucketLevelPermissions::blockPublicAccess)).setter(BucketLevelPermissions.setter(Builder::blockPublicAccess)).constructor(BlockPublicAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_LIST_FIELD, BUCKET_POLICY_FIELD, BLOCK_PUBLIC_ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccessControlList accessControlList;
    private final BucketPolicy bucketPolicy;
    private final BlockPublicAccess blockPublicAccess;

    private BucketLevelPermissions(BuilderImpl builder) {
        this.accessControlList = builder.accessControlList;
        this.bucketPolicy = builder.bucketPolicy;
        this.blockPublicAccess = builder.blockPublicAccess;
    }

    public final AccessControlList accessControlList() {
        return this.accessControlList;
    }

    public final BucketPolicy bucketPolicy() {
        return this.bucketPolicy;
    }

    public final BlockPublicAccess blockPublicAccess() {
        return this.blockPublicAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevelPermissions)) {
            return false;
        }
        BucketLevelPermissions other = (BucketLevelPermissions)obj;
        return Objects.equals(this.accessControlList(), other.accessControlList()) && Objects.equals(this.bucketPolicy(), other.bucketPolicy()) && Objects.equals(this.blockPublicAccess(), other.blockPublicAccess());
    }

    public final String toString() {
        return ToString.builder((String)"BucketLevelPermissions").add("AccessControlList", (Object)this.accessControlList()).add("BucketPolicy", (Object)this.bucketPolicy()).add("BlockPublicAccess", (Object)this.blockPublicAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "BucketPolicy": {
                return Optional.ofNullable(clazz.cast(this.bucketPolicy()));
            }
            case "BlockPublicAccess": {
                return Optional.ofNullable(clazz.cast(this.blockPublicAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketLevelPermissions, T> g) {
        return obj -> g.apply((BucketLevelPermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessControlList accessControlList;
        private BucketPolicy bucketPolicy;
        private BlockPublicAccess blockPublicAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevelPermissions model) {
            this.accessControlList(model.accessControlList);
            this.bucketPolicy(model.bucketPolicy);
            this.blockPublicAccess(model.blockPublicAccess);
        }

        public final AccessControlList.Builder getAccessControlList() {
            return this.accessControlList != null ? this.accessControlList.toBuilder() : null;
        }

        public final void setAccessControlList(AccessControlList.BuilderImpl accessControlList) {
            this.accessControlList = accessControlList != null ? accessControlList.build() : null;
        }

        @Override
        @Transient
        public final Builder accessControlList(AccessControlList accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final BucketPolicy.Builder getBucketPolicy() {
            return this.bucketPolicy != null ? this.bucketPolicy.toBuilder() : null;
        }

        public final void setBucketPolicy(BucketPolicy.BuilderImpl bucketPolicy) {
            this.bucketPolicy = bucketPolicy != null ? bucketPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder bucketPolicy(BucketPolicy bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
            return this;
        }

        public final BlockPublicAccess.Builder getBlockPublicAccess() {
            return this.blockPublicAccess != null ? this.blockPublicAccess.toBuilder() : null;
        }

        public final void setBlockPublicAccess(BlockPublicAccess.BuilderImpl blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess != null ? blockPublicAccess.build() : null;
        }

        @Override
        @Transient
        public final Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        public BucketLevelPermissions build() {
            return new BucketLevelPermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketLevelPermissions> {
        public Builder accessControlList(AccessControlList var1);

        default public Builder accessControlList(Consumer<AccessControlList.Builder> accessControlList) {
            return this.accessControlList((AccessControlList)((AccessControlList.Builder)AccessControlList.builder().applyMutation(accessControlList)).build());
        }

        public Builder bucketPolicy(BucketPolicy var1);

        default public Builder bucketPolicy(Consumer<BucketPolicy.Builder> bucketPolicy) {
            return this.bucketPolicy((BucketPolicy)((BucketPolicy.Builder)BucketPolicy.builder().applyMutation(bucketPolicy)).build());
        }

        public Builder blockPublicAccess(BlockPublicAccess var1);

        default public Builder blockPublicAccess(Consumer<BlockPublicAccess.Builder> blockPublicAccess) {
            return this.blockPublicAccess((BlockPublicAccess)((BlockPublicAccess.Builder)BlockPublicAccess.builder().applyMutation(blockPublicAccess)).build());
        }
    }
}

