/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Eq")
            .getter(getter(Condition::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Neq")
            .getter(getter(Condition::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> GT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Gt")
            .getter(getter(Condition::gt)).setter(setter(Builder::gt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gt").build()).build();

    private static final SdkField<Integer> GTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Gte")
            .getter(getter(Condition::gte)).setter(setter(Builder::gte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gte").build()).build();

    private static final SdkField<Integer> LT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Lt")
            .getter(getter(Condition::lt)).setter(setter(Builder::lt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lt").build()).build();

    private static final SdkField<Integer> LTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Lte")
            .getter(getter(Condition::lte)).setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lte").build()).build();

    private static final SdkField<List<String>> EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Equals")
            .getter(getter(Condition::equalsValue))
            .setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotEquals")
            .getter(getter(Condition::notEquals))
            .setter(setter(Builder::notEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> GREATER_THAN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("GreaterThan").getter(getter(Condition::greaterThan)).setter(setter(Builder::greaterThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<Long> GREATER_THAN_OR_EQUAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("GreaterThanOrEqual").getter(getter(Condition::greaterThanOrEqual))
            .setter(setter(Builder::greaterThanOrEqual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEqual").build())
            .build();

    private static final SdkField<Long> LESS_THAN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("LessThan")
            .getter(getter(Condition::lessThan)).setter(setter(Builder::lessThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<Long> LESS_THAN_OR_EQUAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LessThanOrEqual").getter(getter(Condition::lessThanOrEqual)).setter(setter(Builder::lessThanOrEqual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEqual").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD, NEQ_FIELD, GT_FIELD,
            GTE_FIELD, LT_FIELD, LTE_FIELD, EQUALS_FIELD, NOT_EQUALS_FIELD, GREATER_THAN_FIELD, GREATER_THAN_OR_EQUAL_FIELD,
            LESS_THAN_FIELD, LESS_THAN_OR_EQUAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eq;

    private final List<String> neq;

    private final Integer gt;

    private final Integer gte;

    private final Integer lt;

    private final Integer lte;

    private final List<String> equals;

    private final List<String> notEquals;

    private final Long greaterThan;

    private final Long greaterThanOrEqual;

    private final Long lessThan;

    private final Long lessThanOrEqual;

    private Condition(BuilderImpl builder) {
        this.eq = builder.eq;
        this.neq = builder.neq;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.equals = builder.equals;
        this.notEquals = builder.notEquals;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEqual = builder.greaterThanOrEqual;
        this.lessThan = builder.lessThan;
        this.lessThanOrEqual = builder.lessThanOrEqual;
    }

    /**
     * For responses, this returns true if the service returned a value for the Eq property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     *
     * @deprecated
     */
    @Deprecated
    public final boolean hasEq() {
        return eq != null && !(eq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the <i>equal</i> condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEq} method.
     * </p>
     * 
     * @return Represents the <i>equal</i> condition to be applied to a single field when querying for findings.
     * @deprecated
     */
    @Deprecated
    public final List<String> eq() {
        return eq;
    }

    /**
     * For responses, this returns true if the service returned a value for the Neq property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     *
     * @deprecated
     */
    @Deprecated
    public final boolean hasNeq() {
        return neq != null && !(neq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNeq} method.
     * </p>
     * 
     * @return Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.
     * @deprecated
     */
    @Deprecated
    public final List<String> neq() {
        return neq;
    }

    /**
     * <p>
     * Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
     * @deprecated
     */
    @Deprecated
    public final Integer gt() {
        return gt;
    }

    /**
     * <p>
     * Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for
     *         findings.
     * @deprecated
     */
    @Deprecated
    public final Integer gte() {
        return gte;
    }

    /**
     * <p>
     * Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
     * @deprecated
     */
    @Deprecated
    public final Integer lt() {
        return lt;
    }

    /**
     * <p>
     * Represents a <i>less than or equal</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>less than or equal</i> condition to be applied to a single field when querying for
     *         findings.
     * @deprecated
     */
    @Deprecated
    public final Integer lte() {
        return lte;
    }

    /**
     * For responses, this returns true if the service returned a value for the Equals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEqualsValue() {
        return equals != null && !(equals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEqualsValue} method.
     * </p>
     * 
     * @return Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.
     */
    public final List<String> equalsValue() {
        return equals;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotEquals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotEquals() {
        return notEquals != null && !(notEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotEquals} method.
     * </p>
     * 
     * @return Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for findings.
     */
    public final List<String> notEquals() {
        return notEquals;
    }

    /**
     * <p>
     * Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
     */
    public final Long greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for
     *         findings.
     */
    public final Long greaterThanOrEqual() {
        return greaterThanOrEqual;
    }

    /**
     * <p>
     * Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
     */
    public final Long lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Represents a <i>less than or equal</i> condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a <i>less than or equal</i> condition to be applied to a single field when querying for
     *         findings.
     */
    public final Long lessThanOrEqual() {
        return lessThanOrEqual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEq() ? eq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNeq() ? neq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gt());
        hashCode = 31 * hashCode + Objects.hashCode(gte());
        hashCode = 31 * hashCode + Objects.hashCode(lt());
        hashCode = 31 * hashCode + Objects.hashCode(lte());
        hashCode = 31 * hashCode + Objects.hashCode(hasEqualsValue() ? equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotEquals() ? notEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEqual());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEqual());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return hasEq() == other.hasEq() && Objects.equals(eq(), other.eq()) && hasNeq() == other.hasNeq()
                && Objects.equals(neq(), other.neq()) && Objects.equals(gt(), other.gt()) && Objects.equals(gte(), other.gte())
                && Objects.equals(lt(), other.lt()) && Objects.equals(lte(), other.lte())
                && hasEqualsValue() == other.hasEqualsValue() && Objects.equals(equalsValue(), other.equalsValue())
                && hasNotEquals() == other.hasNotEquals() && Objects.equals(notEquals(), other.notEquals())
                && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEqual(), other.greaterThanOrEqual())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEqual(), other.lessThanOrEqual());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Condition").add("Eq", hasEq() ? eq() : null).add("Neq", hasNeq() ? neq() : null).add("Gt", gt())
                .add("Gte", gte()).add("Lt", lt()).add("Lte", lte()).add("Equals", hasEqualsValue() ? equalsValue() : null)
                .add("NotEquals", hasNotEquals() ? notEquals() : null).add("GreaterThan", greaterThan())
                .add("GreaterThanOrEqual", greaterThanOrEqual()).add("LessThan", lessThan())
                .add("LessThanOrEqual", lessThanOrEqual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "Neq":
            return Optional.ofNullable(clazz.cast(neq()));
        case "Gt":
            return Optional.ofNullable(clazz.cast(gt()));
        case "Gte":
            return Optional.ofNullable(clazz.cast(gte()));
        case "Lt":
            return Optional.ofNullable(clazz.cast(lt()));
        case "Lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "Equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "NotEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        case "GreaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "GreaterThanOrEqual":
            return Optional.ofNullable(clazz.cast(greaterThanOrEqual()));
        case "LessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "LessThanOrEqual":
            return Optional.ofNullable(clazz.cast(lessThanOrEqual()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * Represents the <i>equal</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param eq
         *        Represents the <i>equal</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * Represents the <i>equal</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param eq
         *        Represents the <i>equal</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder eq(String... eq);

        /**
         * <p>
         * Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param neq
         *        Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param neq
         *        Represents the <i>not equal</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder neq(String... neq);

        /**
         * <p>
         * Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param gt
         *        Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder gt(Integer gt);

        /**
         * <p>
         * Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for
         * findings.
         * </p>
         * 
         * @param gte
         *        Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder gte(Integer gte);

        /**
         * <p>
         * Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lt
         *        Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder lt(Integer lt);

        /**
         * <p>
         * Represents a <i>less than or equal</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lte
         *        Represents a <i>less than or equal</i> condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder lte(Integer lte);

        /**
         * <p>
         * Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param equals
         *        Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(Collection<String> equals);

        /**
         * <p>
         * Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param equals
         *        Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(String... equals);

        /**
         * <p>
         * Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param notEquals
         *        Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(Collection<String> notEquals);

        /**
         * <p>
         * Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param notEquals
         *        Represents a <i>not equal</i> <b/> condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(String... notEquals);

        /**
         * <p>
         * Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param greaterThan
         *        Represents a <i>greater than</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(Long greaterThan);

        /**
         * <p>
         * Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for
         * findings.
         * </p>
         * 
         * @param greaterThanOrEqual
         *        Represents a <i>greater than or equal</i> condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEqual(Long greaterThanOrEqual);

        /**
         * <p>
         * Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lessThan
         *        Represents a <i>less than</i> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(Long lessThan);

        /**
         * <p>
         * Represents a <i>less than or equal</i> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lessThanOrEqual
         *        Represents a <i>less than or equal</i> condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEqual(Long lessThanOrEqual);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private Integer gt;

        private Integer gte;

        private Integer lt;

        private Integer lte;

        private List<String> equals = DefaultSdkAutoConstructList.getInstance();

        private List<String> notEquals = DefaultSdkAutoConstructList.getInstance();

        private Long greaterThan;

        private Long greaterThanOrEqual;

        private Long lessThan;

        private Long lessThanOrEqual;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            eq(model.eq);
            neq(model.neq);
            gt(model.gt);
            gte(model.gte);
            lt(model.lt);
            lte(model.lte);
            equalsValue(model.equals);
            notEquals(model.notEquals);
            greaterThan(model.greaterThan);
            greaterThanOrEqual(model.greaterThanOrEqual);
            lessThan(model.lessThan);
            lessThanOrEqual(model.lessThanOrEqual);
        }

        @Deprecated
        public final Collection<String> getEq() {
            if (eq instanceof SdkAutoConstructList) {
                return null;
            }
            return eq;
        }

        @Deprecated
        public final void setEq(Collection<String> eq) {
            this.eq = EqCopier.copy(eq);
        }

        @Override
        @Transient
        @Deprecated
        public final Builder eq(Collection<String> eq) {
            this.eq = EqCopier.copy(eq);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        @Deprecated
        public final Collection<String> getNeq() {
            if (neq instanceof SdkAutoConstructList) {
                return null;
            }
            return neq;
        }

        @Deprecated
        public final void setNeq(Collection<String> neq) {
            this.neq = NeqCopier.copy(neq);
        }

        @Override
        @Transient
        @Deprecated
        public final Builder neq(Collection<String> neq) {
            this.neq = NeqCopier.copy(neq);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        @Deprecated
        public final Integer getGt() {
            return gt;
        }

        @Deprecated
        public final void setGt(Integer gt) {
            this.gt = gt;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder gt(Integer gt) {
            this.gt = gt;
            return this;
        }

        @Deprecated
        public final Integer getGte() {
            return gte;
        }

        @Deprecated
        public final void setGte(Integer gte) {
            this.gte = gte;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder gte(Integer gte) {
            this.gte = gte;
            return this;
        }

        @Deprecated
        public final Integer getLt() {
            return lt;
        }

        @Deprecated
        public final void setLt(Integer lt) {
            this.lt = lt;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder lt(Integer lt) {
            this.lt = lt;
            return this;
        }

        @Deprecated
        public final Integer getLte() {
            return lte;
        }

        @Deprecated
        public final void setLte(Integer lte) {
            this.lte = lte;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder lte(Integer lte) {
            this.lte = lte;
            return this;
        }

        public final Collection<String> getEqualsValue() {
            if (equals instanceof SdkAutoConstructList) {
                return null;
            }
            return equals;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
        }

        @Override
        @Transient
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder equalsValue(String... equals) {
            equalsValue(Arrays.asList(equals));
            return this;
        }

        public final Collection<String> getNotEquals() {
            if (notEquals instanceof SdkAutoConstructList) {
                return null;
            }
            return notEquals;
        }

        public final void setNotEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
        }

        @Override
        @Transient
        public final Builder notEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notEquals(String... notEquals) {
            notEquals(Arrays.asList(notEquals));
            return this;
        }

        public final Long getGreaterThan() {
            return greaterThan;
        }

        public final void setGreaterThan(Long greaterThan) {
            this.greaterThan = greaterThan;
        }

        @Override
        @Transient
        public final Builder greaterThan(Long greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        public final Long getGreaterThanOrEqual() {
            return greaterThanOrEqual;
        }

        public final void setGreaterThanOrEqual(Long greaterThanOrEqual) {
            this.greaterThanOrEqual = greaterThanOrEqual;
        }

        @Override
        @Transient
        public final Builder greaterThanOrEqual(Long greaterThanOrEqual) {
            this.greaterThanOrEqual = greaterThanOrEqual;
            return this;
        }

        public final Long getLessThan() {
            return lessThan;
        }

        public final void setLessThan(Long lessThan) {
            this.lessThan = lessThan;
        }

        @Override
        @Transient
        public final Builder lessThan(Long lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        public final Long getLessThanOrEqual() {
            return lessThanOrEqual;
        }

        public final void setLessThanOrEqual(Long lessThanOrEqual) {
            this.lessThanOrEqual = lessThanOrEqual;
        }

        @Override
        @Transient
        public final Builder lessThanOrEqual(Long lessThanOrEqual) {
            this.lessThanOrEqual = lessThanOrEqual;
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
