/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFiltersResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListFiltersResponse.Builder, ListFiltersResponse> {
    private static final SdkField<List<String>> FILTER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterNames")
            .getter(getter(ListFiltersResponse::filterNames))
            .setter(setter(Builder::filterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFiltersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> filterNames;

    private final String nextToken;

    private ListFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.filterNames = builder.filterNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterNames() {
        return filterNames != null && !(filterNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterNames} method.
     * </p>
     * 
     * @return A list of filter names.
     */
    public final List<String> filterNames() {
        return filterNames;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterNames() ? filterNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFiltersResponse)) {
            return false;
        }
        ListFiltersResponse other = (ListFiltersResponse) obj;
        return hasFilterNames() == other.hasFilterNames() && Objects.equals(filterNames(), other.filterNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFiltersResponse").add("FilterNames", hasFilterNames() ? filterNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterNames":
            return Optional.ofNullable(clazz.cast(filterNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFiltersResponse, T> g) {
        return obj -> g.apply((ListFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFiltersResponse> {
        /**
         * <p>
         * A list of filter names.
         * </p>
         * 
         * @param filterNames
         *        A list of filter names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterNames(Collection<String> filterNames);

        /**
         * <p>
         * A list of filter names.
         * </p>
         * 
         * @param filterNames
         *        A list of filter names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterNames(String... filterNames);

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<String> filterNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFiltersResponse model) {
            super(model);
            filterNames(model.filterNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFilterNames() {
            if (filterNames instanceof SdkAutoConstructList) {
                return null;
            }
            return filterNames;
        }

        public final void setFilterNames(Collection<String> filterNames) {
            this.filterNames = FilterNamesCopier.copy(filterNames);
        }

        @Override
        @Transient
        public final Builder filterNames(Collection<String> filterNames) {
            this.filterNames = FilterNamesCopier.copy(filterNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filterNames(String... filterNames) {
            filterNames(Arrays.asList(filterNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFiltersResponse build() {
            return new ListFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
