/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional information about the generated finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(Service::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Evidence> EVIDENCE_FIELD = SdkField.<Evidence> builder(MarshallingType.SDK_POJO)
            .memberName("Evidence").getter(getter(Service::evidence)).setter(setter(Builder::evidence))
            .constructor(Evidence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidence").build()).build();

    private static final SdkField<Boolean> ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Archived").getter(getter(Service::archived)).setter(setter(Builder::archived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archived").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(Service::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(Service::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> EVENT_FIRST_SEEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventFirstSeen").getter(getter(Service::eventFirstSeen)).setter(setter(Builder::eventFirstSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventFirstSeen").build()).build();

    private static final SdkField<String> EVENT_LAST_SEEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventLastSeen").getter(getter(Service::eventLastSeen)).setter(setter(Builder::eventLastSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventLastSeen").build()).build();

    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceRole").getter(getter(Service::resourceRole)).setter(setter(Builder::resourceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRole").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(Service::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> USER_FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserFeedback").getter(getter(Service::userFeedback)).setter(setter(Builder::userFeedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, EVIDENCE_FIELD,
            ARCHIVED_FIELD, COUNT_FIELD, DETECTOR_ID_FIELD, EVENT_FIRST_SEEN_FIELD, EVENT_LAST_SEEN_FIELD, RESOURCE_ROLE_FIELD,
            SERVICE_NAME_FIELD, USER_FEEDBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final Action action;

    private final Evidence evidence;

    private final Boolean archived;

    private final Integer count;

    private final String detectorId;

    private final String eventFirstSeen;

    private final String eventLastSeen;

    private final String resourceRole;

    private final String serviceName;

    private final String userFeedback;

    private Service(BuilderImpl builder) {
        this.action = builder.action;
        this.evidence = builder.evidence;
        this.archived = builder.archived;
        this.count = builder.count;
        this.detectorId = builder.detectorId;
        this.eventFirstSeen = builder.eventFirstSeen;
        this.eventLastSeen = builder.eventLastSeen;
        this.resourceRole = builder.resourceRole;
        this.serviceName = builder.serviceName;
        this.userFeedback = builder.userFeedback;
    }

    /**
     * <p>
     * Information about the activity that is described in a finding.
     * </p>
     * 
     * @return Information about the activity that is described in a finding.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * An evidence object associated with the service.
     * </p>
     * 
     * @return An evidence object associated with the service.
     */
    public final Evidence evidence() {
        return evidence;
    }

    /**
     * <p>
     * Indicates whether this finding is archived.
     * </p>
     * 
     * @return Indicates whether this finding is archived.
     */
    public final Boolean archived() {
        return archived;
    }

    /**
     * <p>
     * The total count of the occurrences of this finding type.
     * </p>
     * 
     * @return The total count of the occurrences of this finding type.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The detector ID for the GuardDuty service.
     * </p>
     * 
     * @return The detector ID for the GuardDuty service.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The first-seen timestamp of the activity that prompted GuardDuty to generate this finding.
     * </p>
     * 
     * @return The first-seen timestamp of the activity that prompted GuardDuty to generate this finding.
     */
    public final String eventFirstSeen() {
        return eventFirstSeen;
    }

    /**
     * <p>
     * The last-seen timestamp of the activity that prompted GuardDuty to generate this finding.
     * </p>
     * 
     * @return The last-seen timestamp of the activity that prompted GuardDuty to generate this finding.
     */
    public final String eventLastSeen() {
        return eventLastSeen;
    }

    /**
     * <p>
     * The resource role information for this finding.
     * </p>
     * 
     * @return The resource role information for this finding.
     */
    public final String resourceRole() {
        return resourceRole;
    }

    /**
     * <p>
     * The name of the AWS service (GuardDuty) that generated a finding.
     * </p>
     * 
     * @return The name of the AWS service (GuardDuty) that generated a finding.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * Feedback that was submitted about the finding.
     * </p>
     * 
     * @return Feedback that was submitted about the finding.
     */
    public final String userFeedback() {
        return userFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(evidence());
        hashCode = 31 * hashCode + Objects.hashCode(archived());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(eventFirstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(eventLastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(userFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(evidence(), other.evidence())
                && Objects.equals(archived(), other.archived()) && Objects.equals(count(), other.count())
                && Objects.equals(detectorId(), other.detectorId()) && Objects.equals(eventFirstSeen(), other.eventFirstSeen())
                && Objects.equals(eventLastSeen(), other.eventLastSeen()) && Objects.equals(resourceRole(), other.resourceRole())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(userFeedback(), other.userFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("Action", action()).add("Evidence", evidence()).add("Archived", archived())
                .add("Count", count()).add("DetectorId", detectorId()).add("EventFirstSeen", eventFirstSeen())
                .add("EventLastSeen", eventLastSeen()).add("ResourceRole", resourceRole()).add("ServiceName", serviceName())
                .add("UserFeedback", userFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Evidence":
            return Optional.ofNullable(clazz.cast(evidence()));
        case "Archived":
            return Optional.ofNullable(clazz.cast(archived()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "EventFirstSeen":
            return Optional.ofNullable(clazz.cast(eventFirstSeen()));
        case "EventLastSeen":
            return Optional.ofNullable(clazz.cast(eventLastSeen()));
        case "ResourceRole":
            return Optional.ofNullable(clazz.cast(resourceRole()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "UserFeedback":
            return Optional.ofNullable(clazz.cast(userFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * Information about the activity that is described in a finding.
         * </p>
         * 
         * @param action
         *        Information about the activity that is described in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * Information about the activity that is described in a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link Action.Builder} avoiding the need to create one
         * manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An evidence object associated with the service.
         * </p>
         * 
         * @param evidence
         *        An evidence object associated with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidence(Evidence evidence);

        /**
         * <p>
         * An evidence object associated with the service.
         * </p>
         * This is a convenience that creates an instance of the {@link Evidence.Builder} avoiding the need to create
         * one manually via {@link Evidence#builder()}.
         *
         * When the {@link Consumer} completes, {@link Evidence.Builder#build()} is called immediately and its result is
         * passed to {@link #evidence(Evidence)}.
         * 
         * @param evidence
         *        a consumer that will call methods on {@link Evidence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evidence(Evidence)
         */
        default Builder evidence(Consumer<Evidence.Builder> evidence) {
            return evidence(Evidence.builder().applyMutation(evidence).build());
        }

        /**
         * <p>
         * Indicates whether this finding is archived.
         * </p>
         * 
         * @param archived
         *        Indicates whether this finding is archived.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archived(Boolean archived);

        /**
         * <p>
         * The total count of the occurrences of this finding type.
         * </p>
         * 
         * @param count
         *        The total count of the occurrences of this finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The detector ID for the GuardDuty service.
         * </p>
         * 
         * @param detectorId
         *        The detector ID for the GuardDuty service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The first-seen timestamp of the activity that prompted GuardDuty to generate this finding.
         * </p>
         * 
         * @param eventFirstSeen
         *        The first-seen timestamp of the activity that prompted GuardDuty to generate this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFirstSeen(String eventFirstSeen);

        /**
         * <p>
         * The last-seen timestamp of the activity that prompted GuardDuty to generate this finding.
         * </p>
         * 
         * @param eventLastSeen
         *        The last-seen timestamp of the activity that prompted GuardDuty to generate this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventLastSeen(String eventLastSeen);

        /**
         * <p>
         * The resource role information for this finding.
         * </p>
         * 
         * @param resourceRole
         *        The resource role information for this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRole(String resourceRole);

        /**
         * <p>
         * The name of the AWS service (GuardDuty) that generated a finding.
         * </p>
         * 
         * @param serviceName
         *        The name of the AWS service (GuardDuty) that generated a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Feedback that was submitted about the finding.
         * </p>
         * 
         * @param userFeedback
         *        Feedback that was submitted about the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userFeedback(String userFeedback);
    }

    static final class BuilderImpl implements Builder {
        private Action action;

        private Evidence evidence;

        private Boolean archived;

        private Integer count;

        private String detectorId;

        private String eventFirstSeen;

        private String eventLastSeen;

        private String resourceRole;

        private String serviceName;

        private String userFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            action(model.action);
            evidence(model.evidence);
            archived(model.archived);
            count(model.count);
            detectorId(model.detectorId);
            eventFirstSeen(model.eventFirstSeen);
            eventLastSeen(model.eventLastSeen);
            resourceRole(model.resourceRole);
            serviceName(model.serviceName);
            userFeedback(model.userFeedback);
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        @Transient
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final Evidence.Builder getEvidence() {
            return evidence != null ? evidence.toBuilder() : null;
        }

        public final void setEvidence(Evidence.BuilderImpl evidence) {
            this.evidence = evidence != null ? evidence.build() : null;
        }

        @Override
        @Transient
        public final Builder evidence(Evidence evidence) {
            this.evidence = evidence;
            return this;
        }

        public final Boolean getArchived() {
            return archived;
        }

        public final void setArchived(Boolean archived) {
            this.archived = archived;
        }

        @Override
        @Transient
        public final Builder archived(Boolean archived) {
            this.archived = archived;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        @Transient
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getEventFirstSeen() {
            return eventFirstSeen;
        }

        public final void setEventFirstSeen(String eventFirstSeen) {
            this.eventFirstSeen = eventFirstSeen;
        }

        @Override
        @Transient
        public final Builder eventFirstSeen(String eventFirstSeen) {
            this.eventFirstSeen = eventFirstSeen;
            return this;
        }

        public final String getEventLastSeen() {
            return eventLastSeen;
        }

        public final void setEventLastSeen(String eventLastSeen) {
            this.eventLastSeen = eventLastSeen;
        }

        @Override
        @Transient
        public final Builder eventLastSeen(String eventLastSeen) {
            this.eventLastSeen = eventLastSeen;
            return this;
        }

        public final String getResourceRole() {
            return resourceRole;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        @Override
        @Transient
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getUserFeedback() {
            return userFeedback;
        }

        public final void setUserFeedback(String userFeedback) {
            this.userFeedback = userFeedback;
        }

        @Override
        @Transient
        public final Builder userFeedback(String userFeedback) {
            this.userFeedback = userFeedback;
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
