/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIpSetsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListIpSetsResponse.Builder, ListIpSetsResponse> {
    private static final SdkField<List<String>> IP_SET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpSetIds")
            .getter(getter(ListIpSetsResponse::ipSetIds))
            .setter(setter(Builder::ipSetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipSetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIpSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> ipSetIds;

    private final String nextToken;

    private ListIpSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ipSetIds = builder.ipSetIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpSetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpSetIds() {
        return ipSetIds != null && !(ipSetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the IPSet resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpSetIds} method.
     * </p>
     * 
     * @return The IDs of the IPSet resources.
     */
    public final List<String> ipSetIds() {
        return ipSetIds;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSetIds() ? ipSetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpSetsResponse)) {
            return false;
        }
        ListIpSetsResponse other = (ListIpSetsResponse) obj;
        return hasIpSetIds() == other.hasIpSetIds() && Objects.equals(ipSetIds(), other.ipSetIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIpSetsResponse").add("IpSetIds", hasIpSetIds() ? ipSetIds() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpSetIds":
            return Optional.ofNullable(clazz.cast(ipSetIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIpSetsResponse, T> g) {
        return obj -> g.apply((ListIpSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIpSetsResponse> {
        /**
         * <p>
         * The IDs of the IPSet resources.
         * </p>
         * 
         * @param ipSetIds
         *        The IDs of the IPSet resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetIds(Collection<String> ipSetIds);

        /**
         * <p>
         * The IDs of the IPSet resources.
         * </p>
         * 
         * @param ipSetIds
         *        The IDs of the IPSet resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetIds(String... ipSetIds);

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<String> ipSetIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpSetsResponse model) {
            super(model);
            ipSetIds(model.ipSetIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getIpSetIds() {
            if (ipSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ipSetIds;
        }

        public final void setIpSetIds(Collection<String> ipSetIds) {
            this.ipSetIds = IpSetIdsCopier.copy(ipSetIds);
        }

        @Override
        @Transient
        public final Builder ipSetIds(Collection<String> ipSetIds) {
            this.ipSetIds = IpSetIdsCopier.copy(ipSetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipSetIds(String... ipSetIds) {
            ipSetIds(Arrays.asList(ipSetIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIpSetsResponse build() {
            return new ListIpSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
