/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information on which data sources will be configured to be automatically enabled for new
 * members within the organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationDataSourceConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationDataSourceConfigurations.Builder, OrganizationDataSourceConfigurations> {
    private static final SdkField<OrganizationS3LogsConfiguration> S3_LOGS_FIELD = SdkField
            .<OrganizationS3LogsConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(OrganizationDataSourceConfigurations::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(OrganizationS3LogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final OrganizationS3LogsConfiguration s3Logs;

    private OrganizationDataSourceConfigurations(BuilderImpl builder) {
        this.s3Logs = builder.s3Logs;
    }

    /**
     * <p>
     * Describes whether S3 data event logs are enabled for new members of the organization.
     * </p>
     * 
     * @return Describes whether S3 data event logs are enabled for new members of the organization.
     */
    public final OrganizationS3LogsConfiguration s3Logs() {
        return s3Logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationDataSourceConfigurations)) {
            return false;
        }
        OrganizationDataSourceConfigurations other = (OrganizationDataSourceConfigurations) obj;
        return Objects.equals(s3Logs(), other.s3Logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationDataSourceConfigurations").add("S3Logs", s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationDataSourceConfigurations, T> g) {
        return obj -> g.apply((OrganizationDataSourceConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationDataSourceConfigurations> {
        /**
         * <p>
         * Describes whether S3 data event logs are enabled for new members of the organization.
         * </p>
         * 
         * @param s3Logs
         *        Describes whether S3 data event logs are enabled for new members of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(OrganizationS3LogsConfiguration s3Logs);

        /**
         * <p>
         * Describes whether S3 data event logs are enabled for new members of the organization.
         * </p>
         * This is a convenience that creates an instance of the {@link OrganizationS3LogsConfiguration.Builder}
         * avoiding the need to create one manually via {@link OrganizationS3LogsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationS3LogsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Logs(OrganizationS3LogsConfiguration)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link OrganizationS3LogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(OrganizationS3LogsConfiguration)
         */
        default Builder s3Logs(Consumer<OrganizationS3LogsConfiguration.Builder> s3Logs) {
            return s3Logs(OrganizationS3LogsConfiguration.builder().applyMutation(s3Logs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrganizationS3LogsConfiguration s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationDataSourceConfigurations model) {
            s3Logs(model.s3Logs);
        }

        public final OrganizationS3LogsConfiguration.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(OrganizationS3LogsConfiguration.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Logs(OrganizationS3LogsConfiguration s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        @Override
        public OrganizationDataSourceConfigurations build() {
            return new OrganizationDataSourceConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
