/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiCallAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiCallAction.Builder, AwsApiCallAction> {
    private static final SdkField<String> API_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Api")
            .getter(getter(AwsApiCallAction::api)).setter(setter(Builder::api))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("api").build()).build();

    private static final SdkField<String> CALLER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallerType").getter(getter(AwsApiCallAction::callerType)).setter(setter(Builder::callerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerType").build()).build();

    private static final SdkField<DomainDetails> DOMAIN_DETAILS_FIELD = SdkField
            .<DomainDetails> builder(MarshallingType.SDK_POJO).memberName("DomainDetails")
            .getter(getter(AwsApiCallAction::domainDetails)).setter(setter(Builder::domainDetails))
            .constructor(DomainDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainDetails").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(AwsApiCallAction::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<RemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(AwsApiCallAction::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(RemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(AwsApiCallAction::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD, CALLER_TYPE_FIELD,
            DOMAIN_DETAILS_FIELD, ERROR_CODE_FIELD, REMOTE_IP_DETAILS_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String api;

    private final String callerType;

    private final DomainDetails domainDetails;

    private final String errorCode;

    private final RemoteIpDetails remoteIpDetails;

    private final String serviceName;

    private AwsApiCallAction(BuilderImpl builder) {
        this.api = builder.api;
        this.callerType = builder.callerType;
        this.domainDetails = builder.domainDetails;
        this.errorCode = builder.errorCode;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The AWS API name.
     * </p>
     * 
     * @return The AWS API name.
     */
    public final String api() {
        return api;
    }

    /**
     * <p>
     * The AWS API caller type.
     * </p>
     * 
     * @return The AWS API caller type.
     */
    public final String callerType() {
        return callerType;
    }

    /**
     * <p>
     * The domain information for the AWS API call.
     * </p>
     * 
     * @return The domain information for the AWS API call.
     */
    public final DomainDetails domainDetails() {
        return domainDetails;
    }

    /**
     * <p>
     * The error code of the failed AWS API action.
     * </p>
     * 
     * @return The error code of the failed AWS API action.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The remote IP information of the connection that initiated the AWS API call.
     * </p>
     * 
     * @return The remote IP information of the connection that initiated the AWS API call.
     */
    public final RemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    /**
     * <p>
     * The AWS service name whose API was invoked.
     * </p>
     * 
     * @return The AWS service name whose API was invoked.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(api());
        hashCode = 31 * hashCode + Objects.hashCode(callerType());
        hashCode = 31 * hashCode + Objects.hashCode(domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiCallAction)) {
            return false;
        }
        AwsApiCallAction other = (AwsApiCallAction) obj;
        return Objects.equals(api(), other.api()) && Objects.equals(callerType(), other.callerType())
                && Objects.equals(domainDetails(), other.domainDetails()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(remoteIpDetails(), other.remoteIpDetails())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiCallAction").add("Api", api()).add("CallerType", callerType())
                .add("DomainDetails", domainDetails()).add("ErrorCode", errorCode()).add("RemoteIpDetails", remoteIpDetails())
                .add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Api":
            return Optional.ofNullable(clazz.cast(api()));
        case "CallerType":
            return Optional.ofNullable(clazz.cast(callerType()));
        case "DomainDetails":
            return Optional.ofNullable(clazz.cast(domainDetails()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiCallAction, T> g) {
        return obj -> g.apply((AwsApiCallAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiCallAction> {
        /**
         * <p>
         * The AWS API name.
         * </p>
         * 
         * @param api
         *        The AWS API name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder api(String api);

        /**
         * <p>
         * The AWS API caller type.
         * </p>
         * 
         * @param callerType
         *        The AWS API caller type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerType(String callerType);

        /**
         * <p>
         * The domain information for the AWS API call.
         * </p>
         * 
         * @param domainDetails
         *        The domain information for the AWS API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDetails(DomainDetails domainDetails);

        /**
         * <p>
         * The domain information for the AWS API call.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainDetails.Builder} avoiding the need to
         * create one manually via {@link DomainDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #domainDetails(DomainDetails)}.
         * 
         * @param domainDetails
         *        a consumer that will call methods on {@link DomainDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainDetails(DomainDetails)
         */
        default Builder domainDetails(Consumer<DomainDetails.Builder> domainDetails) {
            return domainDetails(DomainDetails.builder().applyMutation(domainDetails).build());
        }

        /**
         * <p>
         * The error code of the failed AWS API action.
         * </p>
         * 
         * @param errorCode
         *        The error code of the failed AWS API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The remote IP information of the connection that initiated the AWS API call.
         * </p>
         * 
         * @param remoteIpDetails
         *        The remote IP information of the connection that initiated the AWS API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(RemoteIpDetails remoteIpDetails);

        /**
         * <p>
         * The remote IP information of the connection that initiated the AWS API call.
         * </p>
         * This is a convenience that creates an instance of the {@link RemoteIpDetails.Builder} avoiding the need to
         * create one manually via {@link RemoteIpDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemoteIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteIpDetails(RemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link RemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(RemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(RemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }

        /**
         * <p>
         * The AWS service name whose API was invoked.
         * </p>
         * 
         * @param serviceName
         *        The AWS service name whose API was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private String api;

        private String callerType;

        private DomainDetails domainDetails;

        private String errorCode;

        private RemoteIpDetails remoteIpDetails;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiCallAction model) {
            api(model.api);
            callerType(model.callerType);
            domainDetails(model.domainDetails);
            errorCode(model.errorCode);
            remoteIpDetails(model.remoteIpDetails);
            serviceName(model.serviceName);
        }

        public final String getApi() {
            return api;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        @Override
        @Transient
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final String getCallerType() {
            return callerType;
        }

        public final void setCallerType(String callerType) {
            this.callerType = callerType;
        }

        @Override
        @Transient
        public final Builder callerType(String callerType) {
            this.callerType = callerType;
            return this;
        }

        public final DomainDetails.Builder getDomainDetails() {
            return domainDetails != null ? domainDetails.toBuilder() : null;
        }

        public final void setDomainDetails(DomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder domainDetails(DomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public AwsApiCallAction build() {
            return new AwsApiCallAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
