/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the elastic network interface of the EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(NetworkInterface::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(NetworkInterface::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceId").build())
            .build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName").getter(getter(NetworkInterface::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress").getter(getter(NetworkInterface::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressDetails>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressDetails>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(NetworkInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicDnsName").getter(getter(NetworkInterface::publicDnsName)).setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDnsName").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicIp").getter(getter(NetworkInterface::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIp").build()).build();

    private static final SdkField<List<SecurityGroup>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroup>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(NetworkInterface::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(NetworkInterface::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(NetworkInterface::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_ADDRESSES_FIELD,
            NETWORK_INTERFACE_ID_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<PrivateIpAddressDetails> privateIpAddresses;

    private final String publicDnsName;

    private final String publicIp;

    private final List<SecurityGroup> securityGroups;

    private final String subnetId;

    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IPv6 addresses for the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return A list of IPv6 addresses for the EC2 instance.
     */
    public final List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The private DNS name of the EC2 instance.
     * </p>
     * 
     * @return The private DNS name of the EC2 instance.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IP address of the EC2 instance.
     * </p>
     * 
     * @return The private IP address of the EC2 instance.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Other private IP address information of the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return Other private IP address information of the EC2 instance.
     */
    public final List<PrivateIpAddressDetails> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The public DNS name of the EC2 instance.
     * </p>
     * 
     * @return The public DNS name of the EC2 instance.
     */
    public final String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IP address of the EC2 instance.
     * </p>
     * 
     * @return The public IP address of the EC2 instance.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups associated with the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security groups associated with the EC2 instance.
     */
    public final List<SecurityGroup> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The subnet ID of the EC2 instance.
     * </p>
     * 
     * @return The subnet ID of the EC2 instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The VPC ID of the EC2 instance.
     * </p>
     * 
     * @return The VPC ID of the EC2 instance.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(publicDnsName(), other.publicDnsName()) && Objects.equals(publicIp(), other.publicIp())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterface").add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateDnsName", privateDnsName())
                .add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("PublicDnsName", publicDnsName()).add("PublicIp", publicIp())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SubnetId", subnetId())
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "PublicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * A list of IPv6 addresses for the EC2 instance.
         * </p>
         * 
         * @param ipv6Addresses
         *        A list of IPv6 addresses for the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * A list of IPv6 addresses for the EC2 instance.
         * </p>
         * 
         * @param ipv6Addresses
         *        A list of IPv6 addresses for the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The private DNS name of the EC2 instance.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IP address of the EC2 instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * Other private IP address information of the EC2 instance.
         * </p>
         * 
         * @param privateIpAddresses
         *        Other private IP address information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses);

        /**
         * <p>
         * Other private IP address information of the EC2 instance.
         * </p>
         * 
         * @param privateIpAddresses
         *        Other private IP address information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressDetails... privateIpAddresses);

        /**
         * <p>
         * Other private IP address information of the EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrivateIpAddressDetails>.Builder} avoiding
         * the need to create one manually via {@link List<PrivateIpAddressDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrivateIpAddressDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressDetails>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<PrivateIpAddressDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<PrivateIpAddressDetails>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder>... privateIpAddresses);

        /**
         * <p>
         * The public DNS name of the EC2 instance.
         * </p>
         * 
         * @param publicDnsName
         *        The public DNS name of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IP address of the EC2 instance.
         * </p>
         * 
         * @param publicIp
         *        The public IP address of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The security groups associated with the EC2 instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroup> securityGroups);

        /**
         * <p>
         * The security groups associated with the EC2 instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroup... securityGroups);

        /**
         * <p>
         * The security groups associated with the EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroup>.Builder} avoiding the need
         * to create one manually via {@link List<SecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #securityGroups(List<SecurityGroup>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<SecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<SecurityGroup>)
         */
        Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups);

        /**
         * <p>
         * The subnet ID of the EC2 instance.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The VPC ID of the EC2 instance.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<PrivateIpAddressDetails> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String publicDnsName;

        private String publicIp;

        private List<SecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
            securityGroups(model.securityGroups);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
        }

        public final Collection<String> getIpv6Addresses() {
            if (ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
        }

        @Override
        @Transient
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        @Transient
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        @Transient
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressDetails.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressDetails.Builder> result = PrivateIpAddressesCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressDetails.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        @Transient
        public final Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressDetails... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses).map(c -> PrivateIpAddressDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        @Override
        @Transient
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        @Transient
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final List<SecurityGroup.Builder> getSecurityGroups() {
            List<SecurityGroup.Builder> result = SecurityGroupsCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copyFromBuilder(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
