/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Web Services resource associated with the activity that prompted GuardDuty to
 * generate a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<AccessKeyDetails> ACCESS_KEY_DETAILS_FIELD = SdkField
            .<AccessKeyDetails> builder(MarshallingType.SDK_POJO).memberName("AccessKeyDetails")
            .getter(getter(Resource::accessKeyDetails)).setter(setter(Builder::accessKeyDetails))
            .constructor(AccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyDetails").build()).build();

    private static final SdkField<List<S3BucketDetail>> S3_BUCKET_DETAILS_FIELD = SdkField
            .<List<S3BucketDetail>> builder(MarshallingType.LIST)
            .memberName("S3BucketDetails")
            .getter(getter(Resource::s3BucketDetails))
            .setter(setter(Builder::s3BucketDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3BucketDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3BucketDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField
            .<InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("InstanceDetails")
            .getter(getter(Resource::instanceDetails)).setter(setter(Builder::instanceDetails))
            .constructor(InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDetails").build()).build();

    private static final SdkField<EksClusterDetails> EKS_CLUSTER_DETAILS_FIELD = SdkField
            .<EksClusterDetails> builder(MarshallingType.SDK_POJO).memberName("EksClusterDetails")
            .getter(getter(Resource::eksClusterDetails)).setter(setter(Builder::eksClusterDetails))
            .constructor(EksClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterDetails").build()).build();

    private static final SdkField<KubernetesDetails> KUBERNETES_DETAILS_FIELD = SdkField
            .<KubernetesDetails> builder(MarshallingType.SDK_POJO).memberName("KubernetesDetails")
            .getter(getter(Resource::kubernetesDetails)).setter(setter(Builder::kubernetesDetails))
            .constructor(KubernetesDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesDetails").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(Resource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<EbsVolumeDetails> EBS_VOLUME_DETAILS_FIELD = SdkField
            .<EbsVolumeDetails> builder(MarshallingType.SDK_POJO).memberName("EbsVolumeDetails")
            .getter(getter(Resource::ebsVolumeDetails)).setter(setter(Builder::ebsVolumeDetails))
            .constructor(EbsVolumeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumeDetails").build()).build();

    private static final SdkField<EcsClusterDetails> ECS_CLUSTER_DETAILS_FIELD = SdkField
            .<EcsClusterDetails> builder(MarshallingType.SDK_POJO).memberName("EcsClusterDetails")
            .getter(getter(Resource::ecsClusterDetails)).setter(setter(Builder::ecsClusterDetails))
            .constructor(EcsClusterDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsClusterDetails").build()).build();

    private static final SdkField<Container> CONTAINER_DETAILS_FIELD = SdkField.<Container> builder(MarshallingType.SDK_POJO)
            .memberName("ContainerDetails").getter(getter(Resource::containerDetails)).setter(setter(Builder::containerDetails))
            .constructor(Container::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_DETAILS_FIELD,
            S3_BUCKET_DETAILS_FIELD, INSTANCE_DETAILS_FIELD, EKS_CLUSTER_DETAILS_FIELD, KUBERNETES_DETAILS_FIELD,
            RESOURCE_TYPE_FIELD, EBS_VOLUME_DETAILS_FIELD, ECS_CLUSTER_DETAILS_FIELD, CONTAINER_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccessKeyDetails accessKeyDetails;

    private final List<S3BucketDetail> s3BucketDetails;

    private final InstanceDetails instanceDetails;

    private final EksClusterDetails eksClusterDetails;

    private final KubernetesDetails kubernetesDetails;

    private final String resourceType;

    private final EbsVolumeDetails ebsVolumeDetails;

    private final EcsClusterDetails ecsClusterDetails;

    private final Container containerDetails;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.s3BucketDetails = builder.s3BucketDetails;
        this.instanceDetails = builder.instanceDetails;
        this.eksClusterDetails = builder.eksClusterDetails;
        this.kubernetesDetails = builder.kubernetesDetails;
        this.resourceType = builder.resourceType;
        this.ebsVolumeDetails = builder.ebsVolumeDetails;
        this.ecsClusterDetails = builder.ecsClusterDetails;
        this.containerDetails = builder.containerDetails;
    }

    /**
     * <p>
     * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted GuardDuty
     * to generate a finding.
     * </p>
     * 
     * @return The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
     *         GuardDuty to generate a finding.
     */
    public final AccessKeyDetails accessKeyDetails() {
        return accessKeyDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3BucketDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3BucketDetails() {
        return s3BucketDetails != null && !(s3BucketDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information on the S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3BucketDetails} method.
     * </p>
     * 
     * @return Contains information on the S3 bucket.
     */
    public final List<S3BucketDetail> s3BucketDetails() {
        return s3BucketDetails;
    }

    /**
     * <p>
     * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
     * finding.
     * </p>
     * 
     * @return The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
     *         finding.
     */
    public final InstanceDetails instanceDetails() {
        return instanceDetails;
    }

    /**
     * <p>
     * Details about the EKS cluster involved in a Kubernetes finding.
     * </p>
     * 
     * @return Details about the EKS cluster involved in a Kubernetes finding.
     */
    public final EksClusterDetails eksClusterDetails() {
        return eksClusterDetails;
    }

    /**
     * <p>
     * Details about the Kubernetes user and workload involved in a Kubernetes finding.
     * </p>
     * 
     * @return Details about the Kubernetes user and workload involved in a Kubernetes finding.
     */
    public final KubernetesDetails kubernetesDetails() {
        return kubernetesDetails;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource.
     * </p>
     * 
     * @return The type of Amazon Web Services resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Contains list of scanned and skipped EBS volumes with details.
     * </p>
     * 
     * @return Contains list of scanned and skipped EBS volumes with details.
     */
    public final EbsVolumeDetails ebsVolumeDetails() {
        return ebsVolumeDetails;
    }

    /**
     * <p>
     * Contains information about the details of the ECS Cluster.
     * </p>
     * 
     * @return Contains information about the details of the ECS Cluster.
     */
    public final EcsClusterDetails ecsClusterDetails() {
        return ecsClusterDetails;
    }

    /**
     * Returns the value of the ContainerDetails property for this object.
     * 
     * @return The value of the ContainerDetails property for this object.
     */
    public final Container containerDetails() {
        return containerDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3BucketDetails() ? s3BucketDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(eksClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(containerDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(accessKeyDetails(), other.accessKeyDetails()) && hasS3BucketDetails() == other.hasS3BucketDetails()
                && Objects.equals(s3BucketDetails(), other.s3BucketDetails())
                && Objects.equals(instanceDetails(), other.instanceDetails())
                && Objects.equals(eksClusterDetails(), other.eksClusterDetails())
                && Objects.equals(kubernetesDetails(), other.kubernetesDetails())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(ebsVolumeDetails(), other.ebsVolumeDetails())
                && Objects.equals(ecsClusterDetails(), other.ecsClusterDetails())
                && Objects.equals(containerDetails(), other.containerDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("AccessKeyDetails", accessKeyDetails())
                .add("S3BucketDetails", hasS3BucketDetails() ? s3BucketDetails() : null)
                .add("InstanceDetails", instanceDetails()).add("EksClusterDetails", eksClusterDetails())
                .add("KubernetesDetails", kubernetesDetails()).add("ResourceType", resourceType())
                .add("EbsVolumeDetails", ebsVolumeDetails()).add("EcsClusterDetails", ecsClusterDetails())
                .add("ContainerDetails", containerDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKeyDetails":
            return Optional.ofNullable(clazz.cast(accessKeyDetails()));
        case "S3BucketDetails":
            return Optional.ofNullable(clazz.cast(s3BucketDetails()));
        case "InstanceDetails":
            return Optional.ofNullable(clazz.cast(instanceDetails()));
        case "EksClusterDetails":
            return Optional.ofNullable(clazz.cast(eksClusterDetails()));
        case "KubernetesDetails":
            return Optional.ofNullable(clazz.cast(kubernetesDetails()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "EbsVolumeDetails":
            return Optional.ofNullable(clazz.cast(ebsVolumeDetails()));
        case "EcsClusterDetails":
            return Optional.ofNullable(clazz.cast(ecsClusterDetails()));
        case "ContainerDetails":
            return Optional.ofNullable(clazz.cast(containerDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * 
         * @param accessKeyDetails
         *        The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         *        GuardDuty to generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyDetails(AccessKeyDetails accessKeyDetails);

        /**
         * <p>
         * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessKeyDetails.Builder} avoiding the
         * need to create one manually via {@link AccessKeyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessKeyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #accessKeyDetails(AccessKeyDetails)}.
         * 
         * @param accessKeyDetails
         *        a consumer that will call methods on {@link AccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKeyDetails(AccessKeyDetails)
         */
        default Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return accessKeyDetails(AccessKeyDetails.builder().applyMutation(accessKeyDetails).build());
        }

        /**
         * <p>
         * Contains information on the S3 bucket.
         * </p>
         * 
         * @param s3BucketDetails
         *        Contains information on the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDetails(Collection<S3BucketDetail> s3BucketDetails);

        /**
         * <p>
         * Contains information on the S3 bucket.
         * </p>
         * 
         * @param s3BucketDetails
         *        Contains information on the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDetails(S3BucketDetail... s3BucketDetails);

        /**
         * <p>
         * Contains information on the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.S3BucketDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.S3BucketDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.S3BucketDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #s3BucketDetails(List<S3BucketDetail>)}.
         * 
         * @param s3BucketDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.S3BucketDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketDetails(java.util.Collection<S3BucketDetail>)
         */
        Builder s3BucketDetails(Consumer<S3BucketDetail.Builder>... s3BucketDetails);

        /**
         * <p>
         * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
         * finding.
         * </p>
         * 
         * @param instanceDetails
         *        The information about the EC2 instance associated with the activity that prompted GuardDuty to
         *        generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDetails(InstanceDetails instanceDetails);

        /**
         * <p>
         * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
         * finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceDetails.Builder} avoiding the
         * need to create one manually via {@link InstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceDetails(InstanceDetails)}.
         * 
         * @param instanceDetails
         *        a consumer that will call methods on {@link InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDetails(InstanceDetails)
         */
        default Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return instanceDetails(InstanceDetails.builder().applyMutation(instanceDetails).build());
        }

        /**
         * <p>
         * Details about the EKS cluster involved in a Kubernetes finding.
         * </p>
         * 
         * @param eksClusterDetails
         *        Details about the EKS cluster involved in a Kubernetes finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusterDetails(EksClusterDetails eksClusterDetails);

        /**
         * <p>
         * Details about the EKS cluster involved in a Kubernetes finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksClusterDetails.Builder} avoiding the
         * need to create one manually via {@link EksClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksClusterDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #eksClusterDetails(EksClusterDetails)}.
         * 
         * @param eksClusterDetails
         *        a consumer that will call methods on {@link EksClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksClusterDetails(EksClusterDetails)
         */
        default Builder eksClusterDetails(Consumer<EksClusterDetails.Builder> eksClusterDetails) {
            return eksClusterDetails(EksClusterDetails.builder().applyMutation(eksClusterDetails).build());
        }

        /**
         * <p>
         * Details about the Kubernetes user and workload involved in a Kubernetes finding.
         * </p>
         * 
         * @param kubernetesDetails
         *        Details about the Kubernetes user and workload involved in a Kubernetes finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesDetails(KubernetesDetails kubernetesDetails);

        /**
         * <p>
         * Details about the Kubernetes user and workload involved in a Kubernetes finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesDetails.Builder} avoiding the
         * need to create one manually via {@link KubernetesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #kubernetesDetails(KubernetesDetails)}.
         * 
         * @param kubernetesDetails
         *        a consumer that will call methods on {@link KubernetesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesDetails(KubernetesDetails)
         */
        default Builder kubernetesDetails(Consumer<KubernetesDetails.Builder> kubernetesDetails) {
            return kubernetesDetails(KubernetesDetails.builder().applyMutation(kubernetesDetails).build());
        }

        /**
         * <p>
         * The type of Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Contains list of scanned and skipped EBS volumes with details.
         * </p>
         * 
         * @param ebsVolumeDetails
         *        Contains list of scanned and skipped EBS volumes with details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumeDetails(EbsVolumeDetails ebsVolumeDetails);

        /**
         * <p>
         * Contains list of scanned and skipped EBS volumes with details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsVolumeDetails.Builder} avoiding the
         * need to create one manually via {@link EbsVolumeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsVolumeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ebsVolumeDetails(EbsVolumeDetails)}.
         * 
         * @param ebsVolumeDetails
         *        a consumer that will call methods on {@link EbsVolumeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsVolumeDetails(EbsVolumeDetails)
         */
        default Builder ebsVolumeDetails(Consumer<EbsVolumeDetails.Builder> ebsVolumeDetails) {
            return ebsVolumeDetails(EbsVolumeDetails.builder().applyMutation(ebsVolumeDetails).build());
        }

        /**
         * <p>
         * Contains information about the details of the ECS Cluster.
         * </p>
         * 
         * @param ecsClusterDetails
         *        Contains information about the details of the ECS Cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterDetails(EcsClusterDetails ecsClusterDetails);

        /**
         * <p>
         * Contains information about the details of the ECS Cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsClusterDetails.Builder} avoiding the
         * need to create one manually via {@link EcsClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsClusterDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsClusterDetails(EcsClusterDetails)}.
         * 
         * @param ecsClusterDetails
         *        a consumer that will call methods on {@link EcsClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsClusterDetails(EcsClusterDetails)
         */
        default Builder ecsClusterDetails(Consumer<EcsClusterDetails.Builder> ecsClusterDetails) {
            return ecsClusterDetails(EcsClusterDetails.builder().applyMutation(ecsClusterDetails).build());
        }

        /**
         * Sets the value of the ContainerDetails property for this object.
         *
         * @param containerDetails
         *        The new value for the ContainerDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDetails(Container containerDetails);

        /**
         * Sets the value of the ContainerDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Container.Builder} avoiding the need to
         * create one manually via {@link Container#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Container.Builder#build()} is called immediately and its result
         * is passed to {@link #containerDetails(Container)}.
         * 
         * @param containerDetails
         *        a consumer that will call methods on {@link Container.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerDetails(Container)
         */
        default Builder containerDetails(Consumer<Container.Builder> containerDetails) {
            return containerDetails(Container.builder().applyMutation(containerDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccessKeyDetails accessKeyDetails;

        private List<S3BucketDetail> s3BucketDetails = DefaultSdkAutoConstructList.getInstance();

        private InstanceDetails instanceDetails;

        private EksClusterDetails eksClusterDetails;

        private KubernetesDetails kubernetesDetails;

        private String resourceType;

        private EbsVolumeDetails ebsVolumeDetails;

        private EcsClusterDetails ecsClusterDetails;

        private Container containerDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            accessKeyDetails(model.accessKeyDetails);
            s3BucketDetails(model.s3BucketDetails);
            instanceDetails(model.instanceDetails);
            eksClusterDetails(model.eksClusterDetails);
            kubernetesDetails(model.kubernetesDetails);
            resourceType(model.resourceType);
            ebsVolumeDetails(model.ebsVolumeDetails);
            ecsClusterDetails(model.ecsClusterDetails);
            containerDetails(model.containerDetails);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return accessKeyDetails != null ? accessKeyDetails.toBuilder() : null;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final List<S3BucketDetail.Builder> getS3BucketDetails() {
            List<S3BucketDetail.Builder> result = S3BucketDetailsCopier.copyToBuilder(this.s3BucketDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3BucketDetails(Collection<S3BucketDetail.BuilderImpl> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copyFromBuilder(s3BucketDetails);
        }

        @Override
        public final Builder s3BucketDetails(Collection<S3BucketDetail> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copy(s3BucketDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(S3BucketDetail... s3BucketDetails) {
            s3BucketDetails(Arrays.asList(s3BucketDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(Consumer<S3BucketDetail.Builder>... s3BucketDetails) {
            s3BucketDetails(Stream.of(s3BucketDetails).map(c -> S3BucketDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return instanceDetails != null ? instanceDetails.toBuilder() : null;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final EksClusterDetails.Builder getEksClusterDetails() {
            return eksClusterDetails != null ? eksClusterDetails.toBuilder() : null;
        }

        public final void setEksClusterDetails(EksClusterDetails.BuilderImpl eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails != null ? eksClusterDetails.build() : null;
        }

        @Override
        public final Builder eksClusterDetails(EksClusterDetails eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails;
            return this;
        }

        public final KubernetesDetails.Builder getKubernetesDetails() {
            return kubernetesDetails != null ? kubernetesDetails.toBuilder() : null;
        }

        public final void setKubernetesDetails(KubernetesDetails.BuilderImpl kubernetesDetails) {
            this.kubernetesDetails = kubernetesDetails != null ? kubernetesDetails.build() : null;
        }

        @Override
        public final Builder kubernetesDetails(KubernetesDetails kubernetesDetails) {
            this.kubernetesDetails = kubernetesDetails;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final EbsVolumeDetails.Builder getEbsVolumeDetails() {
            return ebsVolumeDetails != null ? ebsVolumeDetails.toBuilder() : null;
        }

        public final void setEbsVolumeDetails(EbsVolumeDetails.BuilderImpl ebsVolumeDetails) {
            this.ebsVolumeDetails = ebsVolumeDetails != null ? ebsVolumeDetails.build() : null;
        }

        @Override
        public final Builder ebsVolumeDetails(EbsVolumeDetails ebsVolumeDetails) {
            this.ebsVolumeDetails = ebsVolumeDetails;
            return this;
        }

        public final EcsClusterDetails.Builder getEcsClusterDetails() {
            return ecsClusterDetails != null ? ecsClusterDetails.toBuilder() : null;
        }

        public final void setEcsClusterDetails(EcsClusterDetails.BuilderImpl ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails != null ? ecsClusterDetails.build() : null;
        }

        @Override
        public final Builder ecsClusterDetails(EcsClusterDetails ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails;
            return this;
        }

        public final Container.Builder getContainerDetails() {
            return containerDetails != null ? containerDetails.toBuilder() : null;
        }

        public final void setContainerDetails(Container.BuilderImpl containerDetails) {
            this.containerDetails = containerDetails != null ? containerDetails.build() : null;
        }

        @Override
        public final Builder containerDetails(Container containerDetails) {
            this.containerDetails = containerDetails;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
