/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ScanCriterionCopier {
    static Map<String, ScanCondition> copy(Map<String, ? extends ScanCondition> scanCriterionParam) {
        Map<String, ScanCondition> map;
        if (scanCriterionParam == null || scanCriterionParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScanCondition> modifiableMap = new LinkedHashMap<>();
            scanCriterionParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ScanCondition> copyFromBuilder(Map<String, ? extends ScanCondition.Builder> scanCriterionParam) {
        Map<String, ScanCondition> map;
        if (scanCriterionParam == null || scanCriterionParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScanCondition> modifiableMap = new LinkedHashMap<>();
            scanCriterionParam.forEach((key, value) -> {
                ScanCondition member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ScanCondition.Builder> copyToBuilder(Map<String, ? extends ScanCondition> scanCriterionParam) {
        Map<String, ScanCondition.Builder> map;
        if (scanCriterionParam == null || scanCriterionParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScanCondition.Builder> modifiableMap = new LinkedHashMap<>();
            scanCriterionParam.forEach((key, value) -> {
                ScanCondition.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ScanCondition> copyEnumToString(Map<ScanCriterionKey, ? extends ScanCondition> scanCriterionParam) {
        Map<String, ScanCondition> map;
        if (scanCriterionParam == null || scanCriterionParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScanCondition> modifiableMap = new LinkedHashMap<>();
            scanCriterionParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ScanCriterionKey, ScanCondition> copyStringToEnum(Map<String, ? extends ScanCondition> scanCriterionParam) {
        Map<ScanCriterionKey, ScanCondition> map;
        if (scanCriterionParam == null || scanCriterionParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ScanCriterionKey, ScanCondition> modifiableMap = new LinkedHashMap<>();
            scanCriterionParam.forEach((key, value) -> {
                ScanCriterionKey result = ScanCriterionKey.fromValue(key);
                if (result != ScanCriterionKey.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
