/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Container;
import software.amazon.awssdk.services.guardduty.model.ContainersCopier;
import software.amazon.awssdk.services.guardduty.model.Volume;
import software.amazon.awssdk.services.guardduty.model.VolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesWorkloadDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesWorkloadDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::name)).setter(KubernetesWorkloadDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::type)).setter(KubernetesWorkloadDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::uid)).setter(KubernetesWorkloadDetails.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::namespace)).setter(KubernetesWorkloadDetails.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<Boolean> HOST_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HostNetwork").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::hostNetwork)).setter(KubernetesWorkloadDetails.setter(Builder::hostNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostNetwork").build()}).build();
    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Containers").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::containers)).setter(KubernetesWorkloadDetails.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Volumes").getter(KubernetesWorkloadDetails.getter(KubernetesWorkloadDetails::volumes)).setter(KubernetesWorkloadDetails.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, UID_FIELD, NAMESPACE_FIELD, HOST_NETWORK_FIELD, CONTAINERS_FIELD, VOLUMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String uid;
    private final String namespace;
    private final Boolean hostNetwork;
    private final List<Container> containers;
    private final List<Volume> volumes;

    private KubernetesWorkloadDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.uid = builder.uid;
        this.namespace = builder.namespace;
        this.hostNetwork = builder.hostNetwork;
        this.containers = builder.containers;
        this.volumes = builder.volumes;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public final String uid() {
        return this.uid;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Boolean hostNetwork() {
        return this.hostNetwork;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<Container> containers() {
        return this.containers;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesWorkloadDetails)) {
            return false;
        }
        KubernetesWorkloadDetails other = (KubernetesWorkloadDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.uid(), other.uid()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.hostNetwork(), other.hostNetwork()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesWorkloadDetails").add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("Uid", (Object)this.uid()).add("Namespace", (Object)this.namespace()).add("HostNetwork", (Object)this.hostNetwork()).add("Containers", this.hasContainers() ? this.containers() : null).add("Volumes", this.hasVolumes() ? this.volumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "HostNetwork": {
                return Optional.ofNullable(clazz.cast(this.hostNetwork()));
            }
            case "Containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesWorkloadDetails, T> g) {
        return obj -> g.apply((KubernetesWorkloadDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String uid;
        private String namespace;
        private Boolean hostNetwork;
        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesWorkloadDetails model) {
            this.name(model.name);
            this.type(model.type);
            this.uid(model.uid);
            this.namespace(model.namespace);
            this.hostNetwork(model.hostNetwork);
            this.containers(model.containers);
            this.volumes(model.volumes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Boolean getHostNetwork() {
            return this.hostNetwork;
        }

        public final void setHostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
        }

        @Override
        public final Builder hostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainersCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (Container)((Container.Builder)Container.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public KubernetesWorkloadDetails build() {
            return new KubernetesWorkloadDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesWorkloadDetails> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder uid(String var1);

        public Builder namespace(String var1);

        public Builder hostNetwork(Boolean var1);

        public Builder containers(Collection<Container> var1);

        public Builder containers(Container ... var1);

        public Builder containers(Consumer<Container.Builder> ... var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);
    }
}

