/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConfigurationResponse extends GuardDutyResponse implements
        ToCopyableBuilder<DescribeOrganizationConfigurationResponse.Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(DescribeOrganizationConfigurationResponse::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<Boolean> MEMBER_ACCOUNT_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("MemberAccountLimitReached")
            .getter(getter(DescribeOrganizationConfigurationResponse::memberAccountLimitReached))
            .setter(setter(Builder::memberAccountLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountLimitReached").build())
            .build();

    private static final SdkField<OrganizationDataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField
            .<OrganizationDataSourceConfigurationsResult> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(DescribeOrganizationConfigurationResponse::dataSources)).setter(setter(Builder::dataSources))
            .constructor(OrganizationDataSourceConfigurationsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<List<OrganizationFeatureConfigurationResult>> FEATURES_FIELD = SdkField
            .<List<OrganizationFeatureConfigurationResult>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(DescribeOrganizationConfigurationResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationFeatureConfigurationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationFeatureConfigurationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOrganizationConfigurationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD,
            MEMBER_ACCOUNT_LIMIT_REACHED_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD, NEXT_TOKEN_FIELD));

    private final Boolean autoEnable;

    private final Boolean memberAccountLimitReached;

    private final OrganizationDataSourceConfigurationsResult dataSources;

    private final List<OrganizationFeatureConfigurationResult> features;

    private final String nextToken;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.memberAccountLimitReached = builder.memberAccountLimitReached;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
     * </p>
     * 
     * @return Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
     */
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Indicates whether the maximum number of allowed member accounts are already associated with the delegated
     * administrator account for your organization.
     * </p>
     * 
     * @return Indicates whether the maximum number of allowed member accounts are already associated with the delegated
     *         administrator account for your organization.
     */
    public final Boolean memberAccountLimitReached() {
        return memberAccountLimitReached;
    }

    /**
     * <p>
     * Describes which data sources are enabled automatically for member accounts.
     * </p>
     * 
     * @return Describes which data sources are enabled automatically for member accounts.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final OrganizationDataSourceConfigurationsResult dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features that are configured for this organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return A list of features that are configured for this organization.
     */
    public final List<OrganizationFeatureConfigurationResult> features() {
        return features;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountLimitReached());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse) obj;
        return Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(memberAccountLimitReached(), other.memberAccountLimitReached())
                && Objects.equals(dataSources(), other.dataSources()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationConfigurationResponse").add("AutoEnable", autoEnable())
                .add("MemberAccountLimitReached", memberAccountLimitReached()).add("DataSources", dataSources())
                .add("Features", hasFeatures() ? features() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "MemberAccountLimitReached":
            return Optional.ofNullable(clazz.cast(memberAccountLimitReached()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        /**
         * <p>
         * Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
         * </p>
         * 
         * @param autoEnable
         *        Indicates whether GuardDuty is automatically enabled for accounts added to the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Indicates whether the maximum number of allowed member accounts are already associated with the delegated
         * administrator account for your organization.
         * </p>
         * 
         * @param memberAccountLimitReached
         *        Indicates whether the maximum number of allowed member accounts are already associated with the
         *        delegated administrator account for your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountLimitReached(Boolean memberAccountLimitReached);

        /**
         * <p>
         * Describes which data sources are enabled automatically for member accounts.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources are enabled automatically for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(OrganizationDataSourceConfigurationsResult dataSources);

        /**
         * <p>
         * Describes which data sources are enabled automatically for member accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationDataSourceConfigurationsResult.Builder} avoiding the need to create one manually via
         * {@link OrganizationDataSourceConfigurationsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationDataSourceConfigurationsResult.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dataSources(OrganizationDataSourceConfigurationsResult)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link OrganizationDataSourceConfigurationsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(OrganizationDataSourceConfigurationsResult)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<OrganizationDataSourceConfigurationsResult.Builder> dataSources) {
            return dataSources(OrganizationDataSourceConfigurationsResult.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * A list of features that are configured for this organization.
         * </p>
         * 
         * @param features
         *        A list of features that are configured for this organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<OrganizationFeatureConfigurationResult> features);

        /**
         * <p>
         * A list of features that are configured for this organization.
         * </p>
         * 
         * @param features
         *        A list of features that are configured for this organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(OrganizationFeatureConfigurationResult... features);

        /**
         * <p>
         * A list of features that are configured for this organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfigurationResult.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfigurationResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #features(List<OrganizationFeatureConfigurationResult>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<OrganizationFeatureConfigurationResult>)
         */
        Builder features(Consumer<OrganizationFeatureConfigurationResult.Builder>... features);

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private Boolean autoEnable;

        private Boolean memberAccountLimitReached;

        private OrganizationDataSourceConfigurationsResult dataSources;

        private List<OrganizationFeatureConfigurationResult> features = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            autoEnable(model.autoEnable);
            memberAccountLimitReached(model.memberAccountLimitReached);
            dataSources(model.dataSources);
            features(model.features);
            nextToken(model.nextToken);
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final Boolean getMemberAccountLimitReached() {
            return memberAccountLimitReached;
        }

        public final void setMemberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
        }

        @Override
        public final Builder memberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
            return this;
        }

        @Deprecated
        public final OrganizationDataSourceConfigurationsResult.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(OrganizationDataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(OrganizationDataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<OrganizationFeatureConfigurationResult.Builder> getFeatures() {
            List<OrganizationFeatureConfigurationResult.Builder> result = OrganizationFeaturesConfigurationsResultsCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<OrganizationFeatureConfigurationResult.BuilderImpl> features) {
            this.features = OrganizationFeaturesConfigurationsResultsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<OrganizationFeatureConfigurationResult> features) {
            this.features = OrganizationFeaturesConfigurationsResultsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(OrganizationFeatureConfigurationResult... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<OrganizationFeatureConfigurationResult.Builder>... features) {
            features(Stream.of(features).map(c -> OrganizationFeatureConfigurationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
