/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOrganizationConfigurationRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateOrganizationConfigurationRequest.Builder, UpdateOrganizationConfigurationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateOrganizationConfigurationRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(UpdateOrganizationConfigurationRequest::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<OrganizationDataSourceConfigurations> DATA_SOURCES_FIELD = SdkField
            .<OrganizationDataSourceConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(UpdateOrganizationConfigurationRequest::dataSources)).setter(setter(Builder::dataSources))
            .constructor(OrganizationDataSourceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<List<OrganizationFeatureConfiguration>> FEATURES_FIELD = SdkField
            .<List<OrganizationFeatureConfiguration>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(UpdateOrganizationConfigurationRequest::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationFeatureConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationFeatureConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            AUTO_ENABLE_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD));

    private final String detectorId;

    private final Boolean autoEnable;

    private final OrganizationDataSourceConfigurations dataSources;

    private final List<OrganizationFeatureConfiguration> features;

    private UpdateOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.autoEnable = builder.autoEnable;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
    }

    /**
     * <p>
     * The ID of the detector to update the delegated administrator for.
     * </p>
     * 
     * @return The ID of the detector to update the delegated administrator for.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Indicates whether to automatically enable member accounts in the organization.
     * </p>
     * 
     * @return Indicates whether to automatically enable member accounts in the organization.
     */
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Describes which data sources will be updated.
     * </p>
     * 
     * @return Describes which data sources will be updated.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final OrganizationDataSourceConfigurations dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features that will be configured for the organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return A list of features that will be configured for the organization.
     */
    public final List<OrganizationFeatureConfiguration> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationConfigurationRequest)) {
            return false;
        }
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(dataSources(), other.dataSources()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOrganizationConfigurationRequest").add("DetectorId", detectorId())
                .add("AutoEnable", autoEnable()).add("DataSources", dataSources())
                .add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
        /**
         * <p>
         * The ID of the detector to update the delegated administrator for.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector to update the delegated administrator for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Indicates whether to automatically enable member accounts in the organization.
         * </p>
         * 
         * @param autoEnable
         *        Indicates whether to automatically enable member accounts in the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(OrganizationDataSourceConfigurations dataSources);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationDataSourceConfigurations.Builder} avoiding the need to create one manually via
         * {@link OrganizationDataSourceConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationDataSourceConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(OrganizationDataSourceConfigurations)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link OrganizationDataSourceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(OrganizationDataSourceConfigurations)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<OrganizationDataSourceConfigurations.Builder> dataSources) {
            return dataSources(OrganizationDataSourceConfigurations.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * A list of features that will be configured for the organization.
         * </p>
         * 
         * @param features
         *        A list of features that will be configured for the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<OrganizationFeatureConfiguration> features);

        /**
         * <p>
         * A list of features that will be configured for the organization.
         * </p>
         * 
         * @param features
         *        A list of features that will be configured for the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(OrganizationFeatureConfiguration... features);

        /**
         * <p>
         * A list of features that will be configured for the organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #features(List<OrganizationFeatureConfiguration>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<OrganizationFeatureConfiguration>)
         */
        Builder features(Consumer<OrganizationFeatureConfiguration.Builder>... features);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private Boolean autoEnable;

        private OrganizationDataSourceConfigurations dataSources;

        private List<OrganizationFeatureConfiguration> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationConfigurationRequest model) {
            super(model);
            detectorId(model.detectorId);
            autoEnable(model.autoEnable);
            dataSources(model.dataSources);
            features(model.features);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Deprecated
        public final OrganizationDataSourceConfigurations.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(OrganizationDataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(OrganizationDataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<OrganizationFeatureConfiguration.Builder> getFeatures() {
            List<OrganizationFeatureConfiguration.Builder> result = OrganizationFeaturesConfigurationsCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<OrganizationFeatureConfiguration.BuilderImpl> features) {
            this.features = OrganizationFeaturesConfigurationsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<OrganizationFeatureConfiguration> features) {
            this.features = OrganizationFeaturesConfigurationsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(OrganizationFeatureConfiguration... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<OrganizationFeatureConfiguration.Builder>... features) {
            features(Stream.of(features).map(c -> OrganizationFeatureConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationConfigurationRequest build() {
            return new UpdateOrganizationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
