/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current configuration of all Kubernetes data sources for the organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationKubernetesConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationKubernetesConfigurationResult.Builder, OrganizationKubernetesConfigurationResult> {
    private static final SdkField<OrganizationKubernetesAuditLogsConfigurationResult> AUDIT_LOGS_FIELD = SdkField
            .<OrganizationKubernetesAuditLogsConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("AuditLogs")
            .getter(getter(OrganizationKubernetesConfigurationResult::auditLogs)).setter(setter(Builder::auditLogs))
            .constructor(OrganizationKubernetesAuditLogsConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final OrganizationKubernetesAuditLogsConfigurationResult auditLogs;

    private OrganizationKubernetesConfigurationResult(BuilderImpl builder) {
        this.auditLogs = builder.auditLogs;
    }

    /**
     * <p>
     * The current configuration of Kubernetes audit logs as a data source for the organization.
     * </p>
     * 
     * @return The current configuration of Kubernetes audit logs as a data source for the organization.
     */
    public final OrganizationKubernetesAuditLogsConfigurationResult auditLogs() {
        return auditLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auditLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationKubernetesConfigurationResult)) {
            return false;
        }
        OrganizationKubernetesConfigurationResult other = (OrganizationKubernetesConfigurationResult) obj;
        return Objects.equals(auditLogs(), other.auditLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationKubernetesConfigurationResult").add("AuditLogs", auditLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuditLogs":
            return Optional.ofNullable(clazz.cast(auditLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationKubernetesConfigurationResult, T> g) {
        return obj -> g.apply((OrganizationKubernetesConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationKubernetesConfigurationResult> {
        /**
         * <p>
         * The current configuration of Kubernetes audit logs as a data source for the organization.
         * </p>
         * 
         * @param auditLogs
         *        The current configuration of Kubernetes audit logs as a data source for the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogs(OrganizationKubernetesAuditLogsConfigurationResult auditLogs);

        /**
         * <p>
         * The current configuration of Kubernetes audit logs as a data source for the organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationKubernetesAuditLogsConfigurationResult.Builder} avoiding the need to create one manually
         * via {@link OrganizationKubernetesAuditLogsConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link OrganizationKubernetesAuditLogsConfigurationResult.Builder#build()} is called immediately and its
         * result is passed to {@link #auditLogs(OrganizationKubernetesAuditLogsConfigurationResult)}.
         * 
         * @param auditLogs
         *        a consumer that will call methods on
         *        {@link OrganizationKubernetesAuditLogsConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditLogs(OrganizationKubernetesAuditLogsConfigurationResult)
         */
        default Builder auditLogs(Consumer<OrganizationKubernetesAuditLogsConfigurationResult.Builder> auditLogs) {
            return auditLogs(OrganizationKubernetesAuditLogsConfigurationResult.builder().applyMutation(auditLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrganizationKubernetesAuditLogsConfigurationResult auditLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationKubernetesConfigurationResult model) {
            auditLogs(model.auditLogs);
        }

        public final OrganizationKubernetesAuditLogsConfigurationResult.Builder getAuditLogs() {
            return auditLogs != null ? auditLogs.toBuilder() : null;
        }

        public final void setAuditLogs(OrganizationKubernetesAuditLogsConfigurationResult.BuilderImpl auditLogs) {
            this.auditLogs = auditLogs != null ? auditLogs.build() : null;
        }

        @Override
        public final Builder auditLogs(OrganizationKubernetesAuditLogsConfigurationResult auditLogs) {
            this.auditLogs = auditLogs;
            return this;
        }

        @Override
        public OrganizationKubernetesConfigurationResult build() {
            return new OrganizationKubernetesConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
