/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.BadRequestException;
import software.amazon.awssdk.services.guardduty.model.ConflictException;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.CreateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.CreateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.CreateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.CreateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.GetFilterRequest;
import software.amazon.awssdk.services.guardduty.model.GetFilterResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.guardduty.model.GetIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.GetMembersRequest;
import software.amazon.awssdk.services.guardduty.model.GetMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest;
import software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GuardDutyException;
import software.amazon.awssdk.services.guardduty.model.InternalServerErrorException;
import software.amazon.awssdk.services.guardduty.model.InviteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.InviteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListCoverageRequest;
import software.amazon.awssdk.services.guardduty.model.ListCoverageResponse;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanRequest;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanResponse;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.TagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.TagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.UntagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.UntagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable;
import software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable;
import software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable;

/**
 * Service client for accessing Amazon GuardDuty. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon GuardDuty is a continuous security monitoring service that analyzes and processes the following data sources:
 * VPC flow logs, Amazon Web Services CloudTrail management event logs, CloudTrail S3 data event logs, EKS audit logs,
 * DNS logs, and Amazon EBS volume data. It uses threat intelligence feeds, such as lists of malicious IPs and domains,
 * and machine learning to identify unexpected, potentially unauthorized, and malicious activity within your Amazon Web
 * Services environment. This can include issues like escalations of privileges, uses of exposed credentials, or
 * communication with malicious IPs, domains, or presence of malware on your Amazon EC2 instances and container
 * workloads. For example, GuardDuty can detect compromised EC2 instances and container workloads serving malware, or
 * mining bitcoin.
 * </p>
 * <p>
 * GuardDuty also monitors Amazon Web Services account access behavior for signs of compromise, such as unauthorized
 * infrastructure deployments like EC2 instances deployed in a Region that has never been used, or unusual API calls
 * like a password policy change to reduce password strength.
 * </p>
 * <p>
 * GuardDuty informs you about the status of your Amazon Web Services environment by producing security findings that
 * you can view in the GuardDuty console or through Amazon EventBridge. For more information, see the <i> <a
 * href="https://docs.aws.amazon.com/guardduty/latest/ug/what-is-guardduty.html">Amazon GuardDuty User Guide</a> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GuardDutyClient extends AwsClient {
    String SERVICE_NAME = "guardduty";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "guardduty";

    /**
     * <p>
     * Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent
     * the invitation.
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     * @return Result of the AcceptAdministratorInvitation operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAdministratorInvitationResponse acceptAdministratorInvitation(
            AcceptAdministratorInvitationRequest acceptAdministratorInvitationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent
     * the invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAdministratorInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptAdministratorInvitationRequest#builder()}
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptAdministratorInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptAdministratorInvitation operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAdministratorInvitationResponse acceptAdministratorInvitation(
            Consumer<AcceptAdministratorInvitationRequest.Builder> acceptAdministratorInvitationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.builder()
                .applyMutation(acceptAdministratorInvitationRequest).build());
    }

    /**
     * <p>
     * Accepts the invitation to be monitored by a GuardDuty administrator account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use AcceptAdministratorInvitation instead
     */
    @Deprecated
    default AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be monitored by a GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptInvitationRequest.Builder} to create a request.
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use AcceptAdministratorInvitation instead
     */
    @Deprecated
    default AcceptInvitationResponse acceptInvitation(Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Archives GuardDuty findings that are specified by the list of finding IDs.
     * </p>
     * <note>
     * <p>
     * Only the administrator account can archive findings. Member accounts don't have permission to archive findings
     * from their accounts.
     * </p>
     * </note>
     *
     * @param archiveFindingsRequest
     * @return Result of the ArchiveFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ArchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ArchiveFindingsResponse archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archives GuardDuty findings that are specified by the list of finding IDs.
     * </p>
     * <note>
     * <p>
     * Only the administrator account can archive findings. Member accounts don't have permission to archive findings
     * from their accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ArchiveFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link ArchiveFindingsRequest#builder()}
     * </p>
     *
     * @param archiveFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ArchiveFindingsRequest.Builder} to create a request.
     * @return Result of the ArchiveFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ArchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ArchiveFindingsResponse archiveFindings(Consumer<ArchiveFindingsRequest.Builder> archiveFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return archiveFindings(ArchiveFindingsRequest.builder().applyMutation(archiveFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To
     * start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only
     * one detector per account per Region. All data sources are enabled in a new detector by default.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param createDetectorRequest
     * @return Result of the CreateDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDetectorResponse createDetector(CreateDetectorRequest createDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To
     * start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only
     * one detector per account per Region. All data sources are enabled in a new detector by default.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDetectorRequest#builder()}
     * </p>
     *
     * @param createDetectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateDetectorRequest.Builder} to create a request.
     * @return Result of the CreateDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDetectorResponse createDetector(Consumer<CreateDetectorRequest.Builder> createDetectorRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createDetector(CreateDetectorRequest.builder().applyMutation(createDetectorRequest).build());
    }

    /**
     * <p>
     * Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web
     * Services account per Region is 100. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html">Quotas for GuardDuty</a>.
     * </p>
     *
     * @param createFilterRequest
     * @return Result of the CreateFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web
     * Services account per Region is 100. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html">Quotas for GuardDuty</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFilterRequest#builder()}
     * </p>
     *
     * @param createFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateFilterRequest.Builder} to create a request.
     * @return Result of the CreateFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(Consumer<CreateFilterRequest.Builder> createFilterRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createFilter(CreateFilterRequest.builder().applyMutation(createFilterRequest).build());
    }

    /**
     * <p>
     * Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP
     * addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications.
     * GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the
     * administrator account can use this operation.
     * </p>
     *
     * @param createIpSetRequest
     * @return Result of the CreateIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpSetResponse createIPSet(CreateIpSetRequest createIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP
     * addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications.
     * GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the
     * administrator account can use this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpSetRequest#builder()}
     * </p>
     *
     * @param createIpSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateIPSetRequest.Builder} to create a request.
     * @return Result of the CreateIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpSetResponse createIPSet(Consumer<CreateIpSetRequest.Builder> createIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createIPSet(CreateIpSetRequest.builder().applyMutation(createIpSetRequest).build());
    }

    /**
     * <p>
     * Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services
     * account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or
     * through an organization.
     * </p>
     * <p>
     * When using <code>Create Members</code> as an organizations delegated administrator this action will enable
     * GuardDuty in the added member accounts, with the exception of the organization delegated administrator account,
     * which must enable GuardDuty prior to being added as a member.
     * </p>
     * <p>
     * If you are adding accounts by invitation, use this action after GuardDuty has bee enabled in potential member
     * accounts and before using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a>.
     * </p>
     *
     * @param createMembersRequest
     * @return Result of the CreateMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services
     * account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or
     * through an organization.
     * </p>
     * <p>
     * When using <code>Create Members</code> as an organizations delegated administrator this action will enable
     * GuardDuty in the added member accounts, with the exception of the organization delegated administrator account,
     * which must enable GuardDuty prior to being added as a member.
     * </p>
     * <p>
     * If you are adding accounts by invitation, use this action after GuardDuty has bee enabled in potential member
     * accounts and before using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembersRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMembersRequest#builder()}
     * </p>
     *
     * @param createMembersRequest
     *        A {@link Consumer} that will call methods on {@link CreateMembersRequest.Builder} to create a request.
     * @return Result of the CreateMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMembersResponse createMembers(Consumer<CreateMembersRequest.Builder> createMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createMembers(CreateMembersRequest.builder().applyMutation(createMembersRequest).build());
    }

    /**
     * <p>
     * Creates a publishing destination to export findings to. The resource to export findings to must exist before you
     * use this operation.
     * </p>
     *
     * @param createPublishingDestinationRequest
     * @return Result of the CreatePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePublishingDestinationResponse createPublishingDestination(
            CreatePublishingDestinationRequest createPublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a publishing destination to export findings to. The resource to export findings to must exist before you
     * use this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param createPublishingDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreatePublishingDestinationRequest.Builder} to create
     *        a request.
     * @return Result of the CreatePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePublishingDestinationResponse createPublishingDestination(
            Consumer<CreatePublishingDestinationRequest.Builder> createPublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createPublishingDestination(CreatePublishingDestinationRequest.builder()
                .applyMutation(createPublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Generates sample findings of types specified by the list of finding types. If 'NULL' is specified for
     * <code>findingTypes</code>, the API generates sample findings of all supported finding types.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return Result of the CreateSampleFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSampleFindingsResponse createSampleFindings(CreateSampleFindingsRequest createSampleFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates sample findings of types specified by the list of finding types. If 'NULL' is specified for
     * <code>findingTypes</code>, the API generates sample findings of all supported finding types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSampleFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSampleFindingsRequest#builder()}
     * </p>
     *
     * @param createSampleFindingsRequest
     *        A {@link Consumer} that will call methods on {@link CreateSampleFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSampleFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSampleFindingsResponse createSampleFindings(
            Consumer<CreateSampleFindingsRequest.Builder> createSampleFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createSampleFindings(CreateSampleFindingsRequest.builder().applyMutation(createSampleFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates
     * findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
     * </p>
     *
     * @param createThreatIntelSetRequest
     * @return Result of the CreateThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateThreatIntelSetResponse createThreatIntelSet(CreateThreatIntelSetRequest createThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates
     * findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThreatIntelSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param createThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateThreatIntelSetResponse createThreatIntelSet(
            Consumer<CreateThreatIntelSetRequest.Builder> createThreatIntelSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return createThreatIntelSet(CreateThreatIntelSetRequest.builder().applyMutation(createThreatIntelSetRequest).build());
    }

    /**
     * <p>
     * Declines invitations sent to the current member account by Amazon Web Services accounts specified by their
     * account IDs.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines invitations sent to the current member account by Amazon Web Services accounts specified by their
     * account IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeclineInvitationsResponse declineInvitations(Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon GuardDuty detector that is specified by the detector ID.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return Result of the DeleteDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDetectorResponse deleteDetector(DeleteDetectorRequest deleteDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon GuardDuty detector that is specified by the detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDetectorRequest#builder()}
     * </p>
     *
     * @param deleteDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorRequest.Builder} to create a request.
     * @return Result of the DeleteDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDetectorResponse deleteDetector(Consumer<DeleteDetectorRequest.Builder> deleteDetectorRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deleteDetector(DeleteDetectorRequest.builder().applyMutation(deleteDetectorRequest).build());
    }

    /**
     * <p>
     * Deletes the filter specified by the filter name.
     * </p>
     *
     * @param deleteFilterRequest
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the filter specified by the filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFilterRequest#builder()}
     * </p>
     *
     * @param deleteFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFilterRequest.Builder} to create a request.
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(Consumer<DeleteFilterRequest.Builder> deleteFilterRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deleteFilter(DeleteFilterRequest.builder().applyMutation(deleteFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP lists in the console user
     * interface.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return Result of the DeleteIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpSetResponse deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP lists in the console user
     * interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpSetRequest#builder()}
     * </p>
     *
     * @param deleteIpSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIPSetRequest.Builder} to create a request.
     * @return Result of the DeleteIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpSetResponse deleteIPSet(Consumer<DeleteIpSetRequest.Builder> deleteIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deleteIPSet(DeleteIpSetRequest.builder().applyMutation(deleteIpSetRequest).build());
    }

    /**
     * <p>
     * Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account
     * IDs.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInvitationsRequest.Builder} to create a request.
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvitationsResponse deleteInvitations(Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty for a member account in your organization.
     * </p>
     *
     * @param deleteMembersRequest
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty for a member account in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMembersRequest#builder()}
     * </p>
     *
     * @param deleteMembersRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMembersRequest.Builder} to create a request.
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMembersResponse deleteMembers(Consumer<DeleteMembersRequest.Builder> deleteMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deleteMembers(DeleteMembersRequest.builder().applyMutation(deleteMembersRequest).build());
    }

    /**
     * <p>
     * Deletes the publishing definition with the specified <code>destinationId</code>.
     * </p>
     *
     * @param deletePublishingDestinationRequest
     * @return Result of the DeletePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeletePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePublishingDestinationResponse deletePublishingDestination(
            DeletePublishingDestinationRequest deletePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the publishing definition with the specified <code>destinationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param deletePublishingDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeletePublishingDestinationRequest.Builder} to create
     *        a request.
     * @return Result of the DeletePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeletePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePublishingDestinationResponse deletePublishingDestination(
            Consumer<DeletePublishingDestinationRequest.Builder> deletePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deletePublishingDestination(DeletePublishingDestinationRequest.builder()
                .applyMutation(deletePublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param deleteThreatIntelSetRequest
     * @return Result of the DeleteThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteThreatIntelSetResponse deleteThreatIntelSet(DeleteThreatIntelSetRequest deleteThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThreatIntelSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param deleteThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteThreatIntelSetResponse deleteThreatIntelSet(
            Consumer<DeleteThreatIntelSetRequest.Builder> deleteThreatIntelSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return deleteThreatIntelSet(DeleteThreatIntelSetRequest.builder().applyMutation(deleteThreatIntelSetRequest).build());
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param describeMalwareScansRequest
     * @return Result of the DescribeMalwareScans operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMalwareScansResponse describeMalwareScans(DescribeMalwareScansRequest describeMalwareScansRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMalwareScansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMalwareScansRequest#builder()}
     * </p>
     *
     * @param describeMalwareScansRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMalwareScansRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeMalwareScans operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMalwareScansResponse describeMalwareScans(
            Consumer<DescribeMalwareScansRequest.Builder> describeMalwareScansRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return describeMalwareScans(DescribeMalwareScansRequest.builder().applyMutation(describeMalwareScansRequest).build());
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable responses = client.describeMalwareScansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable responses = client
     *             .describeMalwareScansPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable responses = client.describeMalwareScansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMalwareScansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMalwareScansIterable describeMalwareScansPaginator(DescribeMalwareScansRequest describeMalwareScansRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable responses = client.describeMalwareScansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable responses = client
     *             .describeMalwareScansPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansIterable responses = client.describeMalwareScansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMalwareScansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMalwareScansRequest#builder()}
     * </p>
     *
     * @param describeMalwareScansRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMalwareScansRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMalwareScansIterable describeMalwareScansPaginator(
            Consumer<DescribeMalwareScansRequest.Builder> describeMalwareScansRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return describeMalwareScansPaginator(DescribeMalwareScansRequest.builder().applyMutation(describeMalwareScansRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable responses = client.describeOrganizationConfigurationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable responses = client
     *             .describeOrganizationConfigurationPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable responses = client.describeOrganizationConfigurationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationIterable describeOrganizationConfigurationPaginator(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable responses = client.describeOrganizationConfigurationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable responses = client
     *             .describeOrganizationConfigurationPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationIterable responses = client.describeOrganizationConfigurationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationIterable describeOrganizationConfigurationPaginator(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return describeOrganizationConfigurationPaginator(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about the publishing destination specified by the provided <code>destinationId</code>.
     * </p>
     *
     * @param describePublishingDestinationRequest
     * @return Result of the DescribePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePublishingDestinationResponse describePublishingDestination(
            DescribePublishingDestinationRequest describePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the publishing destination specified by the provided <code>destinationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param describePublishingDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DescribePublishingDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePublishingDestinationResponse describePublishingDestination(
            Consumer<DescribePublishingDestinationRequest.Builder> describePublishingDestinationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return describePublishingDestination(DescribePublishingDestinationRequest.builder()
                .applyMutation(describePublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Disables an Amazon Web Services account within the Organization as the GuardDuty delegated administrator.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return Result of the DisableOrganizationAdminAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables an Amazon Web Services account within the Organization as the GuardDuty delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisableOrganizationAdminAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(
            Consumer<DisableOrganizationAdminAccountRequest.Builder> disableOrganizationAdminAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder()
                .applyMutation(disableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty in a member account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return Result of the DisassociateFromAdministratorAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromAdministratorAccountResponse disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty in a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateFromAdministratorAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateFromAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromAdministratorAccountRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateFromAdministratorAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromAdministratorAccountResponse disassociateFromAdministratorAccount(
            Consumer<DisassociateFromAdministratorAccountRequest.Builder> disassociateFromAdministratorAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder()
                .applyMutation(disassociateFromAdministratorAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is deprecated, use DisassociateFromAdministratorAccount instead
     */
    @Deprecated
    default DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is deprecated, use DisassociateFromAdministratorAccount instead
     */
    @Deprecated
    default DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates GuardDuty member accounts (to the current administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disassociate a member account before removing them from your Amazon Web
     * Services organization.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateMembersResponse disassociateMembers(DisassociateMembersRequest disassociateMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates GuardDuty member accounts (to the current administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disassociate a member account before removing them from your Amazon Web
     * Services organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMembersRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMembersRequest#builder()}
     * </p>
     *
     * @param disassociateMembersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMembersRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateMembersResponse disassociateMembers(
            Consumer<DisassociateMembersRequest.Builder> disassociateMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return disassociateMembers(DisassociateMembersRequest.builder().applyMutation(disassociateMembersRequest).build());
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the GuardDuty delegated administrator.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return Result of the EnableOrganizationAdminAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the GuardDuty delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link EnableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the EnableOrganizationAdminAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(
            Consumer<EnableOrganizationAdminAccountRequest.Builder> enableOrganizationAdminAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder()
                .applyMutation(enableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     *
     * @param getAdministratorAccountRequest
     * @return Result of the GetAdministratorAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAdministratorAccountResponse getAdministratorAccount(GetAdministratorAccountRequest getAdministratorAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdministratorAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param getAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAdministratorAccountRequest.Builder} to create a
     *        request.
     * @return Result of the GetAdministratorAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAdministratorAccountResponse getAdministratorAccount(
            Consumer<GetAdministratorAccountRequest.Builder> getAdministratorAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getAdministratorAccount(GetAdministratorAccountRequest.builder().applyMutation(getAdministratorAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the
     * statistics for all the resources associated with the active member accounts in your organization who have enabled
     * EKS Runtime Monitoring and have the GuardDuty agent running on their EKS nodes.
     * </p>
     *
     * @param getCoverageStatisticsRequest
     * @return Result of the GetCoverageStatistics operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoverageStatisticsResponse getCoverageStatistics(GetCoverageStatisticsRequest getCoverageStatisticsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the
     * statistics for all the resources associated with the active member accounts in your organization who have enabled
     * EKS Runtime Monitoring and have the GuardDuty agent running on their EKS nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param getCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the GetCoverageStatistics operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoverageStatisticsResponse getCoverageStatistics(
            Consumer<GetCoverageStatisticsRequest.Builder> getCoverageStatisticsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getCoverageStatistics(GetCoverageStatisticsRequest.builder().applyMutation(getCoverageStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves an Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getDetectorRequest
     * @return Result of the GetDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorResponse getDetector(GetDetectorRequest getDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorRequest#builder()}
     * </p>
     *
     * @param getDetectorRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorRequest.Builder} to create a request.
     * @return Result of the GetDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorResponse getDetector(Consumer<GetDetectorRequest.Builder> getDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getDetector(GetDetectorRequest.builder().applyMutation(getDetectorRequest).build());
    }

    /**
     * <p>
     * Returns the details of the filter specified by the filter name.
     * </p>
     *
     * @param getFilterRequest
     * @return Result of the GetFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFilterResponse getFilter(GetFilterRequest getFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the filter specified by the filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFilterRequest.Builder} avoiding the need to
     * create one manually via {@link GetFilterRequest#builder()}
     * </p>
     *
     * @param getFilterRequest
     *        A {@link Consumer} that will call methods on {@link GetFilterRequest.Builder} to create a request.
     * @return Result of the GetFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFilterResponse getFilter(Consumer<GetFilterRequest.Builder> getFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getFilter(GetFilterRequest.builder().applyMutation(getFilterRequest).build());
    }

    /**
     * <p>
     * Describes Amazon GuardDuty findings specified by finding IDs.
     * </p>
     *
     * @param getFindingsRequest
     * @return Result of the GetFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes Amazon GuardDuty findings specified by finding IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return Result of the GetFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings statistics for the specified detector ID.
     * </p>
     *
     * @param getFindingsStatisticsRequest
     * @return Result of the GetFindingsStatistics operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFindingsStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsStatisticsResponse getFindingsStatistics(GetFindingsStatisticsRequest getFindingsStatisticsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings statistics for the specified detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetFindingsStatisticsRequest#builder()}
     * </p>
     *
     * @param getFindingsStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the GetFindingsStatistics operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFindingsStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsStatisticsResponse getFindingsStatistics(
            Consumer<GetFindingsStatisticsRequest.Builder> getFindingsStatisticsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getFindingsStatistics(GetFindingsStatisticsRequest.builder().applyMutation(getFindingsStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves the IPSet specified by the <code>ipSetId</code>.
     * </p>
     *
     * @param getIpSetRequest
     * @return Result of the GetIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIpSetResponse getIPSet(GetIpSetRequest getIpSetRequest) throws BadRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the IPSet specified by the <code>ipSetId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetIpSetRequest#builder()}
     * </p>
     *
     * @param getIpSetRequest
     *        A {@link Consumer} that will call methods on {@link GetIPSetRequest.Builder} to create a request.
     * @return Result of the GetIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIpSetResponse getIPSet(Consumer<GetIpSetRequest.Builder> getIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getIPSet(GetIpSetRequest.builder().applyMutation(getIpSetRequest).build());
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     *
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetInvitationsCount
     * @see #getInvitationsCount(GetInvitationsCountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount() throws BadRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, GuardDutyException {
        return getInvitationsCount(GetInvitationsCountRequest.builder().build());
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <p>
     * Returns the details of the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getMalwareScanSettingsRequest
     * @return Result of the GetMalwareScanSettings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMalwareScanSettingsResponse getMalwareScanSettings(GetMalwareScanSettingsRequest getMalwareScanSettingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMalwareScanSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetMalwareScanSettingsRequest#builder()}
     * </p>
     *
     * @param getMalwareScanSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetMalwareScanSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetMalwareScanSettings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMalwareScanSettingsResponse getMalwareScanSettings(
            Consumer<GetMalwareScanSettingsRequest.Builder> getMalwareScanSettingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getMalwareScanSettings(GetMalwareScanSettingsRequest.builder().applyMutation(getMalwareScanSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use GetAdministratorAccount instead
     */
    @Deprecated
    default GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetMasterAccountRequest.Builder} to create a request.
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use GetAdministratorAccount instead
     */
    @Deprecated
    default GetMasterAccountResponse getMasterAccount(Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * Describes which data sources are enabled for the member account's detector.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getMemberDetectorsRequest
     * @return Result of the GetMemberDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMemberDetectorsResponse getMemberDetectors(GetMemberDetectorsRequest getMemberDetectorsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes which data sources are enabled for the member account's detector.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetMemberDetectorsRequest#builder()}
     * </p>
     *
     * @param getMemberDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetMemberDetectorsRequest.Builder} to create a
     *        request.
     * @return Result of the GetMemberDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMemberDetectorsResponse getMemberDetectors(Consumer<GetMemberDetectorsRequest.Builder> getMemberDetectorsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getMemberDetectors(GetMemberDetectorsRequest.builder().applyMutation(getMemberDetectorsRequest).build());
    }

    /**
     * <p>
     * Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account
     * IDs.
     * </p>
     *
     * @param getMembersRequest
     * @return Result of the GetMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembersRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembersRequest#builder()}
     * </p>
     *
     * @param getMembersRequest
     *        A {@link Consumer} that will call methods on {@link GetMembersRequest.Builder} to create a request.
     * @return Result of the GetMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembersResponse getMembers(Consumer<GetMembersRequest.Builder> getMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getMembers(GetMembersRequest.builder().applyMutation(getMembersRequest).build());
    }

    /**
     * <p>
     * Provides the number of days left for each data source used in the free trial period.
     * </p>
     *
     * @param getRemainingFreeTrialDaysRequest
     * @return Result of the GetRemainingFreeTrialDays operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetRemainingFreeTrialDays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetRemainingFreeTrialDays"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRemainingFreeTrialDaysResponse getRemainingFreeTrialDays(
            GetRemainingFreeTrialDaysRequest getRemainingFreeTrialDaysRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the number of days left for each data source used in the free trial period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRemainingFreeTrialDaysRequest.Builder} avoiding
     * the need to create one manually via {@link GetRemainingFreeTrialDaysRequest#builder()}
     * </p>
     *
     * @param getRemainingFreeTrialDaysRequest
     *        A {@link Consumer} that will call methods on {@link GetRemainingFreeTrialDaysRequest.Builder} to create a
     *        request.
     * @return Result of the GetRemainingFreeTrialDays operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetRemainingFreeTrialDays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetRemainingFreeTrialDays"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRemainingFreeTrialDaysResponse getRemainingFreeTrialDays(
            Consumer<GetRemainingFreeTrialDaysRequest.Builder> getRemainingFreeTrialDaysRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getRemainingFreeTrialDays(GetRemainingFreeTrialDaysRequest.builder()
                .applyMutation(getRemainingFreeTrialDaysRequest).build());
    }

    /**
     * <p>
     * Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param getThreatIntelSetRequest
     * @return Result of the GetThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    default GetThreatIntelSetResponse getThreatIntelSet(GetThreatIntelSetRequest getThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThreatIntelSetRequest.Builder} avoiding the need
     * to create one manually via {@link GetThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param getThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on {@link GetThreatIntelSetRequest.Builder} to create a request.
     * @return Result of the GetThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    default GetThreatIntelSetResponse getThreatIntelSet(Consumer<GetThreatIntelSetRequest.Builder> getThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getThreatIntelSet(GetThreatIntelSetRequest.builder().applyMutation(getThreatIntelSetRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return Result of the GetUsageStatistics operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUsageStatisticsResponse getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetUsageStatisticsRequest#builder()}
     * </p>
     *
     * @param getUsageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the GetUsageStatistics operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUsageStatisticsResponse getUsageStatistics(Consumer<GetUsageStatisticsRequest.Builder> getUsageStatisticsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getUsageStatistics(GetUsageStatisticsRequest.builder().applyMutation(getUsageStatisticsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable responses = client.getUsageStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable responses = client
     *             .getUsageStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable responses = client.getUsageStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUsageStatisticsIterable getUsageStatisticsPaginator(GetUsageStatisticsRequest getUsageStatisticsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable responses = client.getUsageStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable responses = client
     *             .getUsageStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsIterable responses = client.getUsageStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetUsageStatisticsRequest#builder()}
     * </p>
     *
     * @param getUsageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUsageStatisticsIterable getUsageStatisticsPaginator(
            Consumer<GetUsageStatisticsRequest.Builder> getUsageStatisticsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return getUsageStatisticsPaginator(GetUsageStatisticsRequest.builder().applyMutation(getUsageStatisticsRequest).build());
    }

    /**
     * <p>
     * Invites other Amazon Web Services accounts (created as members of the current Amazon Web Services account by
     * CreateMembers) to enable GuardDuty, and allow the current Amazon Web Services account to view and manage these
     * accounts' findings on their behalf as the GuardDuty administrator account.
     * </p>
     *
     * @param inviteMembersRequest
     * @return Result of the InviteMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default InviteMembersResponse inviteMembers(InviteMembersRequest inviteMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invites other Amazon Web Services accounts (created as members of the current Amazon Web Services account by
     * CreateMembers) to enable GuardDuty, and allow the current Amazon Web Services account to view and manage these
     * accounts' findings on their behalf as the GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteMembersRequest#builder()}
     * </p>
     *
     * @param inviteMembersRequest
     *        A {@link Consumer} that will call methods on {@link InviteMembersRequest.Builder} to create a request.
     * @return Result of the InviteMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default InviteMembersResponse inviteMembers(Consumer<InviteMembersRequest.Builder> inviteMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return inviteMembers(InviteMembersRequest.builder().applyMutation(inviteMembersRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have EKS Runtime Monitoring enabled and GuardDuty agent running on their EKS nodes.
     * </p>
     *
     * @param listCoverageRequest
     * @return Result of the ListCoverage operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageResponse listCoverage(ListCoverageRequest listCoverageRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have EKS Runtime Monitoring enabled and GuardDuty agent running on their EKS nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on {@link ListCoverageRequest.Builder} to create a request.
     * @return Result of the ListCoverage operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageResponse listCoverage(Consumer<ListCoverageRequest.Builder> listCoverageRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listCoverage(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have EKS Runtime Monitoring enabled and GuardDuty agent running on their EKS nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)} operation.</b>
     * </p>
     *
     * @param listCoverageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageIterable listCoveragePaginator(ListCoverageRequest listCoverageRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have EKS Runtime Monitoring enabled and GuardDuty agent running on their EKS nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoverageIterable responses = client.listCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on {@link ListCoverageRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoverageIterable listCoveragePaginator(Consumer<ListCoverageRequest.Builder> listCoverageRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listCoveragePaginator(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     *
     * @return Result of the ListDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see #listDetectors(ListDetectorsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsResponse listDetectors() throws BadRequestException, InternalServerErrorException, AwsServiceException,
            SdkClientException, GuardDutyException {
        return listDetectors(ListDetectorsRequest.builder().build());
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     *
     * @param listDetectorsRequest
     * @return Result of the ListDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsResponse listDetectors(ListDetectorsRequest listDetectorsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorsRequest.Builder} to create a request.
     * @return Result of the ListDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsResponse listDetectors(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listDetectors(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see #listDetectorsPaginator(ListDetectorsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsIterable listDetectorsPaginator() throws BadRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, GuardDutyException {
        return listDetectorsPaginator(ListDetectorsRequest.builder().build());
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     *
     * @param listDetectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsIterable listDetectorsPaginator(ListDetectorsRequest listDetectorsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsIterable listDetectorsPaginator(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listDetectorsPaginator(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     *
     * @param listFiltersRequest
     * @return Result of the ListFilters operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFiltersRequest.Builder} to create a request.
     * @return Result of the ListFilters operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(Consumer<ListFiltersRequest.Builder> listFiltersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listFilters(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFiltersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(Consumer<ListFiltersRequest.Builder> listFiltersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listFiltersPaginator(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings for the specified detector ID.
     * </p>
     *
     * @param listFindingsRequest
     * @return Result of the ListFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings for the specified detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return Result of the ListFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings for the specified detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings for the specified detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     *
     * @param listIpSetsRequest
     * @return Result of the ListIPSets operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIpSetsResponse listIPSets(ListIpSetsRequest listIpSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListIPSetsRequest.Builder} to create a request.
     * @return Result of the ListIPSets operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIpSetsResponse listIPSets(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listIPSets(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)} operation.</b>
     * </p>
     *
     * @param listIpSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIPSetsIterable listIPSetsPaginator(ListIpSetsRequest listIpSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListIPSetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIPSetsIterable listIPSetsPaginator(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listIPSetsPaginator(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     *
     * @return Result of the ListInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see #listInvitations(ListInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsResponse listInvitations() throws BadRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, GuardDutyException {
        return listInvitations(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return Result of the ListInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return Result of the ListInvitations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsResponse listInvitations(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see #listInvitationsPaginator(ListInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator() throws BadRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, GuardDutyException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists the accounts configured as GuardDuty delegated administrators.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return Result of the ListOrganizationAdminAccounts operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the accounts configured as GuardDuty delegated administrators.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return Result of the ListOrganizationAdminAccounts operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the accounts configured as GuardDuty delegated administrators.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable responses = client
     *             .listOrganizationAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the accounts configured as GuardDuty delegated administrators.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable responses = client
     *             .listOrganizationAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return Result of the ListPublishingDestinations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishingDestinationsResponse listPublishingDestinations(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublishingDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPublishingDestinationsRequest#builder()}
     * </p>
     *
     * @param listPublishingDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPublishingDestinationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPublishingDestinations operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishingDestinationsResponse listPublishingDestinations(
            Consumer<ListPublishingDestinationsRequest.Builder> listPublishingDestinationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listPublishingDestinations(ListPublishingDestinationsRequest.builder()
                .applyMutation(listPublishingDestinationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client.listPublishingDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client
     *             .listPublishingDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client.listPublishingDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishingDestinationsIterable listPublishingDestinationsPaginator(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client.listPublishingDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client
     *             .listPublishingDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client.listPublishingDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublishingDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPublishingDestinationsRequest#builder()}
     * </p>
     *
     * @param listPublishingDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListPublishingDestinationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishingDestinationsIterable listPublishingDestinationsPaginator(
            Consumer<ListPublishingDestinationsRequest.Builder> listPublishingDestinationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listPublishingDestinationsPaginator(ListPublishingDestinationsRequest.builder()
                .applyMutation(listPublishingDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, and threat
     * intel sets, with a limit of 50 tags per resource. When invoked, this operation returns all assigned tags for a
     * given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, and threat
     * intel sets, with a limit of 50 tags per resource. When invoked, this operation returns all assigned tags for a
     * given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return Result of the ListThreatIntelSets operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThreatIntelSetsResponse listThreatIntelSets(ListThreatIntelSetsRequest listThreatIntelSetsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThreatIntelSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListThreatIntelSetsRequest#builder()}
     * </p>
     *
     * @param listThreatIntelSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListThreatIntelSetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListThreatIntelSets operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThreatIntelSetsResponse listThreatIntelSets(
            Consumer<ListThreatIntelSetsRequest.Builder> listThreatIntelSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listThreatIntelSets(ListThreatIntelSetsRequest.builder().applyMutation(listThreatIntelSetsRequest).build());
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client.listThreatIntelSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client
     *             .listThreatIntelSetsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client.listThreatIntelSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThreatIntelSetsIterable listThreatIntelSetsPaginator(ListThreatIntelSetsRequest listThreatIntelSetsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client.listThreatIntelSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client
     *             .listThreatIntelSetsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client.listThreatIntelSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThreatIntelSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListThreatIntelSetsRequest#builder()}
     * </p>
     *
     * @param listThreatIntelSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListThreatIntelSetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThreatIntelSetsIterable listThreatIntelSetsPaginator(
            Consumer<ListThreatIntelSetsRequest.Builder> listThreatIntelSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return listThreatIntelSetsPaginator(ListThreatIntelSetsRequest.builder().applyMutation(listThreatIntelSetsRequest)
                .build());
    }

    /**
     * <p>
     * Initiates the malware scan. Invoking this API will automatically create the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html">Service-linked
     * role </a> in the corresponding account.
     * </p>
     *
     * @param startMalwareScanRequest
     * @return Result of the StartMalwareScan operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws ConflictException
     *         A request conflict exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StartMalwareScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScan" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMalwareScanResponse startMalwareScan(StartMalwareScanRequest startMalwareScanRequest)
            throws BadRequestException, ConflictException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the malware scan. Invoking this API will automatically create the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html">Service-linked
     * role </a> in the corresponding account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMalwareScanRequest.Builder} avoiding the need
     * to create one manually via {@link StartMalwareScanRequest#builder()}
     * </p>
     *
     * @param startMalwareScanRequest
     *        A {@link Consumer} that will call methods on {@link StartMalwareScanRequest.Builder} to create a request.
     * @return Result of the StartMalwareScan operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws ConflictException
     *         A request conflict exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StartMalwareScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScan" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMalwareScanResponse startMalwareScan(Consumer<StartMalwareScanRequest.Builder> startMalwareScanRequest)
            throws BadRequestException, ConflictException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GuardDutyException {
        return startMalwareScan(StartMalwareScanRequest.builder().applyMutation(startMalwareScanRequest).build());
    }

    /**
     * <p>
     * Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of
     * accounts that you stopped monitoring with the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_StopMonitoringMembers.html"
     * >StopMonitoringMembers</a> operation.
     * </p>
     *
     * @param startMonitoringMembersRequest
     * @return Result of the StartMonitoringMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StartMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMonitoringMembersResponse startMonitoringMembers(StartMonitoringMembersRequest startMonitoringMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of
     * accounts that you stopped monitoring with the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_StopMonitoringMembers.html"
     * >StopMonitoringMembers</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMonitoringMembersRequest.Builder} avoiding the
     * need to create one manually via {@link StartMonitoringMembersRequest#builder()}
     * </p>
     *
     * @param startMonitoringMembersRequest
     *        A {@link Consumer} that will call methods on {@link StartMonitoringMembersRequest.Builder} to create a
     *        request.
     * @return Result of the StartMonitoringMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StartMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMonitoringMembersResponse startMonitoringMembers(
            Consumer<StartMonitoringMembersRequest.Builder> startMonitoringMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return startMonitoringMembers(StartMonitoringMembersRequest.builder().applyMutation(startMonitoringMembersRequest)
                .build());
    }

    /**
     * <p>
     * Stops GuardDuty monitoring for the specified member accounts. Use the <code>StartMonitoringMembers</code>
     * operation to restart monitoring for those accounts.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to stop monitoring the member accounts in your organization.
     * </p>
     *
     * @param stopMonitoringMembersRequest
     * @return Result of the StopMonitoringMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StopMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default StopMonitoringMembersResponse stopMonitoringMembers(StopMonitoringMembersRequest stopMonitoringMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops GuardDuty monitoring for the specified member accounts. Use the <code>StartMonitoringMembers</code>
     * operation to restart monitoring for those accounts.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to stop monitoring the member accounts in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopMonitoringMembersRequest.Builder} avoiding the
     * need to create one manually via {@link StopMonitoringMembersRequest#builder()}
     * </p>
     *
     * @param stopMonitoringMembersRequest
     *        A {@link Consumer} that will call methods on {@link StopMonitoringMembersRequest.Builder} to create a
     *        request.
     * @return Result of the StopMonitoringMembers operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StopMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default StopMonitoringMembersResponse stopMonitoringMembers(
            Consumer<StopMonitoringMembersRequest.Builder> stopMonitoringMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return stopMonitoringMembers(StopMonitoringMembersRequest.builder().applyMutation(stopMonitoringMembersRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Unarchives GuardDuty findings specified by the <code>findingIds</code>.
     * </p>
     *
     * @param unarchiveFindingsRequest
     * @return Result of the UnarchiveFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UnarchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default UnarchiveFindingsResponse unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unarchives GuardDuty findings specified by the <code>findingIds</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnarchiveFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link UnarchiveFindingsRequest#builder()}
     * </p>
     *
     * @param unarchiveFindingsRequest
     *        A {@link Consumer} that will call methods on {@link UnarchiveFindingsRequest.Builder} to create a request.
     * @return Result of the UnarchiveFindings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UnarchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default UnarchiveFindingsResponse unarchiveFindings(Consumer<UnarchiveFindingsRequest.Builder> unarchiveFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return unarchiveFindings(UnarchiveFindingsRequest.builder().applyMutation(unarchiveFindingsRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateDetectorRequest
     * @return Result of the UpdateDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDetectorResponse updateDetector(UpdateDetectorRequest updateDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDetectorRequest#builder()}
     * </p>
     *
     * @param updateDetectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorRequest.Builder} to create a request.
     * @return Result of the UpdateDetector operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDetectorResponse updateDetector(Consumer<UpdateDetectorRequest.Builder> updateDetectorRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateDetector(UpdateDetectorRequest.builder().applyMutation(updateDetectorRequest).build());
    }

    /**
     * <p>
     * Updates the filter specified by the filter name.
     * </p>
     *
     * @param updateFilterRequest
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFilterResponse updateFilter(UpdateFilterRequest updateFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the filter specified by the filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFilterRequest#builder()}
     * </p>
     *
     * @param updateFilterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFilterRequest.Builder} to create a request.
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFilterResponse updateFilter(Consumer<UpdateFilterRequest.Builder> updateFilterRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateFilter(UpdateFilterRequest.builder().applyMutation(updateFilterRequest).build());
    }

    /**
     * <p>
     * Marks the specified GuardDuty findings as useful or not useful.
     * </p>
     *
     * @param updateFindingsFeedbackRequest
     * @return Result of the UpdateFindingsFeedback operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateFindingsFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFindingsFeedbackResponse updateFindingsFeedback(UpdateFindingsFeedbackRequest updateFindingsFeedbackRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Marks the specified GuardDuty findings as useful or not useful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsFeedbackRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFindingsFeedbackRequest#builder()}
     * </p>
     *
     * @param updateFindingsFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFindingsFeedbackRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFindingsFeedback operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateFindingsFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFindingsFeedbackResponse updateFindingsFeedback(
            Consumer<UpdateFindingsFeedbackRequest.Builder> updateFindingsFeedbackRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateFindingsFeedback(UpdateFindingsFeedbackRequest.builder().applyMutation(updateFindingsFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Updates the IPSet specified by the IPSet ID.
     * </p>
     *
     * @param updateIpSetRequest
     * @return Result of the UpdateIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIpSetResponse updateIPSet(UpdateIpSetRequest updateIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the IPSet specified by the IPSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIpSetRequest#builder()}
     * </p>
     *
     * @param updateIpSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIPSetRequest.Builder} to create a request.
     * @return Result of the UpdateIPSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateIpSetResponse updateIPSet(Consumer<UpdateIpSetRequest.Builder> updateIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateIPSet(UpdateIpSetRequest.builder().applyMutation(updateIpSetRequest).build());
    }

    /**
     * <p>
     * Updates the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateMalwareScanSettingsRequest
     * @return Result of the UpdateMalwareScanSettings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMalwareScanSettingsResponse updateMalwareScanSettings(
            UpdateMalwareScanSettingsRequest updateMalwareScanSettingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMalwareScanSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMalwareScanSettingsRequest#builder()}
     * </p>
     *
     * @param updateMalwareScanSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMalwareScanSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMalwareScanSettings operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMalwareScanSettingsResponse updateMalwareScanSettings(
            Consumer<UpdateMalwareScanSettingsRequest.Builder> updateMalwareScanSettingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateMalwareScanSettings(UpdateMalwareScanSettingsRequest.builder()
                .applyMutation(updateMalwareScanSettingsRequest).build());
    }

    /**
     * <p>
     * Contains information on member accounts to be updated.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateMemberDetectorsRequest
     * @return Result of the UpdateMemberDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMemberDetectorsResponse updateMemberDetectors(UpdateMemberDetectorsRequest updateMemberDetectorsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Contains information on member accounts to be updated.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemberDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMemberDetectorsRequest#builder()}
     * </p>
     *
     * @param updateMemberDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMemberDetectorsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMemberDetectors operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMemberDetectorsResponse updateMemberDetectors(
            Consumer<UpdateMemberDetectorsRequest.Builder> updateMemberDetectorsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateMemberDetectors(UpdateMemberDetectorsRequest.builder().applyMutation(updateMemberDetectorsRequest).build());
    }

    /**
     * <p>
     * Configures the delegated administrator account with the provided values. You must provide the value for either
     * <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the delegated administrator account with the provided values. You must provide the value for either
     * <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates information about the publishing destination specified by the <code>destinationId</code>.
     * </p>
     *
     * @param updatePublishingDestinationRequest
     * @return Result of the UpdatePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePublishingDestinationResponse updatePublishingDestination(
            UpdatePublishingDestinationRequest updatePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the publishing destination specified by the <code>destinationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param updatePublishingDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePublishingDestinationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdatePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePublishingDestinationResponse updatePublishingDestination(
            Consumer<UpdatePublishingDestinationRequest.Builder> updatePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updatePublishingDestination(UpdatePublishingDestinationRequest.builder()
                .applyMutation(updatePublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param updateThreatIntelSetRequest
     * @return Result of the UpdateThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateThreatIntelSetResponse updateThreatIntelSet(UpdateThreatIntelSetRequest updateThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThreatIntelSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param updateThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         A bad request exception object.
     * @throws InternalServerErrorException
     *         An internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateThreatIntelSetResponse updateThreatIntelSet(
            Consumer<UpdateThreatIntelSetRequest.Builder> updateThreatIntelSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return updateThreatIntelSet(UpdateThreatIntelSetRequest.builder().applyMutation(updateThreatIntelSetRequest).build());
    }

    /**
     * Create a {@link GuardDutyClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GuardDutyClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GuardDutyClient}.
     */
    static GuardDutyClientBuilder builder() {
        return new DefaultGuardDutyClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default GuardDutyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
