/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAdministratorAccountResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetAdministratorAccountResponse.Builder, GetAdministratorAccountResponse> {
    private static final SdkField<Administrator> ADMINISTRATOR_FIELD = SdkField.<Administrator> builder(MarshallingType.SDK_POJO)
            .memberName("Administrator").getter(getter(GetAdministratorAccountResponse::administrator))
            .setter(setter(Builder::administrator)).constructor(Administrator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administrator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMINISTRATOR_FIELD));

    private final Administrator administrator;

    private GetAdministratorAccountResponse(BuilderImpl builder) {
        super(builder);
        this.administrator = builder.administrator;
    }

    /**
     * <p>
     * The administrator account details.
     * </p>
     * 
     * @return The administrator account details.
     */
    public final Administrator administrator() {
        return administrator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(administrator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdministratorAccountResponse)) {
            return false;
        }
        GetAdministratorAccountResponse other = (GetAdministratorAccountResponse) obj;
        return Objects.equals(administrator(), other.administrator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAdministratorAccountResponse").add("Administrator", administrator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Administrator":
            return Optional.ofNullable(clazz.cast(administrator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAdministratorAccountResponse, T> g) {
        return obj -> g.apply((GetAdministratorAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAdministratorAccountResponse> {
        /**
         * <p>
         * The administrator account details.
         * </p>
         * 
         * @param administrator
         *        The administrator account details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrator(Administrator administrator);

        /**
         * <p>
         * The administrator account details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Administrator.Builder} avoiding the need
         * to create one manually via {@link Administrator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Administrator.Builder#build()} is called immediately and its
         * result is passed to {@link #administrator(Administrator)}.
         * 
         * @param administrator
         *        a consumer that will call methods on {@link Administrator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #administrator(Administrator)
         */
        default Builder administrator(Consumer<Administrator.Builder> administrator) {
            return administrator(Administrator.builder().applyMutation(administrator).build());
        }
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private Administrator administrator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdministratorAccountResponse model) {
            super(model);
            administrator(model.administrator);
        }

        public final Administrator.Builder getAdministrator() {
            return administrator != null ? administrator.toBuilder() : null;
        }

        public final void setAdministrator(Administrator.BuilderImpl administrator) {
            this.administrator = administrator != null ? administrator.build() : null;
        }

        @Override
        public final Builder administrator(Administrator administrator) {
            this.administrator = administrator;
            return this;
        }

        @Override
        public GetAdministratorAccountResponse build() {
            return new GetAdministratorAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
