/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AnomalyProfilesCopier {
    static Map<String, Map<String, List<AnomalyObject>>> copy(
            Map<String, ? extends Map<String, ? extends Collection<? extends AnomalyObject>>> anomalyProfilesParam) {
        Map<String, Map<String, List<AnomalyObject>>> map;
        if (anomalyProfilesParam == null || anomalyProfilesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, List<AnomalyObject>>> modifiableMap = new LinkedHashMap<>();
            anomalyProfilesParam.forEach((key, value) -> {
                Map<String, List<AnomalyObject>> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, List<AnomalyObject>> modifiableMap1 = new LinkedHashMap<>();
                    value.forEach((key1, value1) -> {
                        List<AnomalyObject> list;
                        if (value1 == null || value1 instanceof SdkAutoConstructList) {
                            list = DefaultSdkAutoConstructList.getInstance();
                        } else {
                            List<AnomalyObject> modifiableList = new ArrayList<>();
                            value1.forEach(entry -> {
                                modifiableList.add(entry);
                            });
                            list = Collections.unmodifiableList(modifiableList);
                        }
                        modifiableMap1.put(key1, list);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, List<AnomalyObject>>> copyFromBuilder(
            Map<String, ? extends Map<String, ? extends Collection<? extends AnomalyObject.Builder>>> anomalyProfilesParam) {
        Map<String, Map<String, List<AnomalyObject>>> map;
        if (anomalyProfilesParam == null || anomalyProfilesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, List<AnomalyObject>>> modifiableMap = new LinkedHashMap<>();
            anomalyProfilesParam.forEach((key, value) -> {
                Map<String, List<AnomalyObject>> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, List<AnomalyObject>> modifiableMap1 = new LinkedHashMap<>();
                    value.forEach((key1, value1) -> {
                        List<AnomalyObject> list;
                        if (value1 == null || value1 instanceof SdkAutoConstructList) {
                            list = DefaultSdkAutoConstructList.getInstance();
                        } else {
                            List<AnomalyObject> modifiableList = new ArrayList<>();
                            value1.forEach(entry -> {
                                AnomalyObject member = entry == null ? null : entry.build();
                                modifiableList.add(member);
                            });
                            list = Collections.unmodifiableList(modifiableList);
                        }
                        modifiableMap1.put(key1, list);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, List<AnomalyObject.Builder>>> copyToBuilder(
            Map<String, ? extends Map<String, ? extends Collection<? extends AnomalyObject>>> anomalyProfilesParam) {
        Map<String, Map<String, List<AnomalyObject.Builder>>> map;
        if (anomalyProfilesParam == null || anomalyProfilesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, List<AnomalyObject.Builder>>> modifiableMap = new LinkedHashMap<>();
            anomalyProfilesParam.forEach((key, value) -> {
                Map<String, List<AnomalyObject.Builder>> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, List<AnomalyObject.Builder>> modifiableMap1 = new LinkedHashMap<>();
                    value.forEach((key1, value1) -> {
                        List<AnomalyObject.Builder> list;
                        if (value1 == null || value1 instanceof SdkAutoConstructList) {
                            list = DefaultSdkAutoConstructList.getInstance();
                        } else {
                            List<AnomalyObject.Builder> modifiableList = new ArrayList<>();
                            value1.forEach(entry -> {
                                AnomalyObject.Builder member = entry == null ? null : entry.toBuilder();
                                modifiableList.add(member);
                            });
                            list = Collections.unmodifiableList(modifiableList);
                        }
                        modifiableMap1.put(key1, list);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
