/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageStatisticsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetUsageStatisticsResponse.Builder, GetUsageStatisticsResponse> {
    private static final SdkField<UsageStatistics> USAGE_STATISTICS_FIELD = SdkField
            .<UsageStatistics> builder(MarshallingType.SDK_POJO).memberName("UsageStatistics")
            .getter(getter(GetUsageStatisticsResponse::usageStatistics)).setter(setter(Builder::usageStatistics))
            .constructor(UsageStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageStatistics").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetUsageStatisticsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_STATISTICS_FIELD,
            NEXT_TOKEN_FIELD));

    private final UsageStatistics usageStatistics;

    private final String nextToken;

    private GetUsageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.usageStatistics = builder.usageStatistics;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The usage statistics object. If a UsageStatisticType was provided, the objects representing other types will be
     * null.
     * </p>
     * 
     * @return The usage statistics object. If a UsageStatisticType was provided, the objects representing other types
     *         will be null.
     */
    public final UsageStatistics usageStatistics() {
        return usageStatistics;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsResponse)) {
            return false;
        }
        GetUsageStatisticsResponse other = (GetUsageStatisticsResponse) obj;
        return Objects.equals(usageStatistics(), other.usageStatistics()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageStatisticsResponse").add("UsageStatistics", usageStatistics())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageStatistics":
            return Optional.ofNullable(clazz.cast(usageStatistics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsResponse, T> g) {
        return obj -> g.apply((GetUsageStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageStatisticsResponse> {
        /**
         * <p>
         * The usage statistics object. If a UsageStatisticType was provided, the objects representing other types will
         * be null.
         * </p>
         * 
         * @param usageStatistics
         *        The usage statistics object. If a UsageStatisticType was provided, the objects representing other
         *        types will be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageStatistics(UsageStatistics usageStatistics);

        /**
         * <p>
         * The usage statistics object. If a UsageStatisticType was provided, the objects representing other types will
         * be null.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageStatistics.Builder} avoiding the
         * need to create one manually via {@link UsageStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #usageStatistics(UsageStatistics)}.
         * 
         * @param usageStatistics
         *        a consumer that will call methods on {@link UsageStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageStatistics(UsageStatistics)
         */
        default Builder usageStatistics(Consumer<UsageStatistics.Builder> usageStatistics) {
            return usageStatistics(UsageStatistics.builder().applyMutation(usageStatistics).build());
        }

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private UsageStatistics usageStatistics;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsResponse model) {
            super(model);
            usageStatistics(model.usageStatistics);
            nextToken(model.nextToken);
        }

        public final UsageStatistics.Builder getUsageStatistics() {
            return usageStatistics != null ? usageStatistics.toBuilder() : null;
        }

        public final void setUsageStatistics(UsageStatistics.BuilderImpl usageStatistics) {
            this.usageStatistics = usageStatistics != null ? usageStatistics.build() : null;
        }

        @Override
        public final Builder usageStatistics(UsageStatistics usageStatistics) {
            this.usageStatistics = usageStatistics;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetUsageStatisticsResponse build() {
            return new GetUsageStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
