/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Kubernetes role name and role type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesRoleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesRoleDetails.Builder, KubernetesRoleDetails> {
    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Kind")
            .getter(getter(KubernetesRoleDetails::kind)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(KubernetesRoleDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> UID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uid")
            .getter(getter(KubernetesRoleDetails::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KIND_FIELD, NAME_FIELD,
            UID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kind;

    private final String name;

    private final String uid;

    private KubernetesRoleDetails(BuilderImpl builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.uid = builder.uid;
    }

    /**
     * <p>
     * The kind of role. For this API, the value of <code>kind</code> will be <code>Role</code>.
     * </p>
     * 
     * @return The kind of role. For this API, the value of <code>kind</code> will be <code>Role</code>.
     */
    public final String kind() {
        return kind;
    }

    /**
     * <p>
     * The name of the Kubernetes role.
     * </p>
     * 
     * @return The name of the Kubernetes role.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the Kubernetes role name.
     * </p>
     * 
     * @return The unique identifier of the Kubernetes role name.
     */
    public final String uid() {
        return uid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kind());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesRoleDetails)) {
            return false;
        }
        KubernetesRoleDetails other = (KubernetesRoleDetails) obj;
        return Objects.equals(kind(), other.kind()) && Objects.equals(name(), other.name()) && Objects.equals(uid(), other.uid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesRoleDetails").add("Kind", kind()).add("Name", name()).add("Uid", uid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Kind":
            return Optional.ofNullable(clazz.cast(kind()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesRoleDetails, T> g) {
        return obj -> g.apply((KubernetesRoleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesRoleDetails> {
        /**
         * <p>
         * The kind of role. For this API, the value of <code>kind</code> will be <code>Role</code>.
         * </p>
         * 
         * @param kind
         *        The kind of role. For this API, the value of <code>kind</code> will be <code>Role</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kind(String kind);

        /**
         * <p>
         * The name of the Kubernetes role.
         * </p>
         * 
         * @param name
         *        The name of the Kubernetes role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the Kubernetes role name.
         * </p>
         * 
         * @param uid
         *        The unique identifier of the Kubernetes role name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(String uid);
    }

    static final class BuilderImpl implements Builder {
        private String kind;

        private String name;

        private String uid;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesRoleDetails model) {
            kind(model.kind);
            name(model.name);
            uid(model.uid);
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUid() {
            return uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public KubernetesRoleDetails build() {
            return new KubernetesRoleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
