/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the observed process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessDetails implements SdkPojo, Serializable, ToCopyableBuilder<ProcessDetails.Builder, ProcessDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProcessDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutablePath").getter(getter(ProcessDetails::executablePath)).setter(setter(Builder::executablePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executablePath").build()).build();

    private static final SdkField<String> EXECUTABLE_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutableSha256").getter(getter(ProcessDetails::executableSha256))
            .setter(setter(Builder::executableSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executableSha256").build()).build();

    private static final SdkField<Integer> NAMESPACE_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NamespacePid").getter(getter(ProcessDetails::namespacePid)).setter(setter(Builder::namespacePid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespacePid").build()).build();

    private static final SdkField<String> PWD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Pwd")
            .getter(getter(ProcessDetails::pwd)).setter(setter(Builder::pwd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pwd").build()).build();

    private static final SdkField<Integer> PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pid")
            .getter(getter(ProcessDetails::pid)).setter(setter(Builder::pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ProcessDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uuid")
            .getter(getter(ProcessDetails::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()).build();

    private static final SdkField<String> PARENT_UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentUuid").getter(getter(ProcessDetails::parentUuid)).setter(setter(Builder::parentUuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentUuid").build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(ProcessDetails::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<Integer> USER_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UserId").getter(getter(ProcessDetails::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Integer> EUID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Euid")
            .getter(getter(ProcessDetails::euid)).setter(setter(Builder::euid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("euid").build()).build();

    private static final SdkField<List<LineageObject>> LINEAGE_FIELD = SdkField
            .<List<LineageObject>> builder(MarshallingType.LIST)
            .memberName("Lineage")
            .getter(getter(ProcessDetails::lineage))
            .setter(setter(Builder::lineage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineageObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineageObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EXECUTABLE_PATH_FIELD, EXECUTABLE_SHA256_FIELD, NAMESPACE_PID_FIELD, PWD_FIELD, PID_FIELD, START_TIME_FIELD,
            UUID_FIELD, PARENT_UUID_FIELD, USER_FIELD, USER_ID_FIELD, EUID_FIELD, LINEAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String executablePath;

    private final String executableSha256;

    private final Integer namespacePid;

    private final String pwd;

    private final Integer pid;

    private final Instant startTime;

    private final String uuid;

    private final String parentUuid;

    private final String user;

    private final Integer userId;

    private final Integer euid;

    private final List<LineageObject> lineage;

    private ProcessDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.executablePath = builder.executablePath;
        this.executableSha256 = builder.executableSha256;
        this.namespacePid = builder.namespacePid;
        this.pwd = builder.pwd;
        this.pid = builder.pid;
        this.startTime = builder.startTime;
        this.uuid = builder.uuid;
        this.parentUuid = builder.parentUuid;
        this.user = builder.user;
        this.userId = builder.userId;
        this.euid = builder.euid;
        this.lineage = builder.lineage;
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * 
     * @return The name of the process.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The absolute path of the process executable file.
     * </p>
     * 
     * @return The absolute path of the process executable file.
     */
    public final String executablePath() {
        return executablePath;
    }

    /**
     * <p>
     * The <code>SHA256</code> hash of the process executable.
     * </p>
     * 
     * @return The <code>SHA256</code> hash of the process executable.
     */
    public final String executableSha256() {
        return executableSha256;
    }

    /**
     * <p>
     * The ID of the child process.
     * </p>
     * 
     * @return The ID of the child process.
     */
    public final Integer namespacePid() {
        return namespacePid;
    }

    /**
     * <p>
     * The present working directory of the process.
     * </p>
     * 
     * @return The present working directory of the process.
     */
    public final String pwd() {
        return pwd;
    }

    /**
     * <p>
     * The ID of the process.
     * </p>
     * 
     * @return The ID of the process.
     */
    public final Integer pid() {
        return pid;
    }

    /**
     * <p>
     * The time when the process started. This is in UTC format.
     * </p>
     * 
     * @return The time when the process started. This is in UTC format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The unique ID assigned to the process by GuardDuty.
     * </p>
     * 
     * @return The unique ID assigned to the process by GuardDuty.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
     * </p>
     * 
     * @return The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
     */
    public final String parentUuid() {
        return parentUuid;
    }

    /**
     * <p>
     * The user that executed the process.
     * </p>
     * 
     * @return The user that executed the process.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * The unique ID of the user that executed the process.
     * </p>
     * 
     * @return The unique ID of the user that executed the process.
     */
    public final Integer userId() {
        return userId;
    }

    /**
     * <p>
     * The effective user ID of the user that executed the process.
     * </p>
     * 
     * @return The effective user ID of the user that executed the process.
     */
    public final Integer euid() {
        return euid;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lineage property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLineage() {
        return lineage != null && !(lineage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the process's lineage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineage} method.
     * </p>
     * 
     * @return Information about the process's lineage.
     */
    public final List<LineageObject> lineage() {
        return lineage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(executableSha256());
        hashCode = 31 * hashCode + Objects.hashCode(namespacePid());
        hashCode = 31 * hashCode + Objects.hashCode(pwd());
        hashCode = 31 * hashCode + Objects.hashCode(pid());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(parentUuid());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(euid());
        hashCode = 31 * hashCode + Objects.hashCode(hasLineage() ? lineage() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessDetails)) {
            return false;
        }
        ProcessDetails other = (ProcessDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(executablePath(), other.executablePath())
                && Objects.equals(executableSha256(), other.executableSha256())
                && Objects.equals(namespacePid(), other.namespacePid()) && Objects.equals(pwd(), other.pwd())
                && Objects.equals(pid(), other.pid()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(uuid(), other.uuid()) && Objects.equals(parentUuid(), other.parentUuid())
                && Objects.equals(user(), other.user()) && Objects.equals(userId(), other.userId())
                && Objects.equals(euid(), other.euid()) && hasLineage() == other.hasLineage()
                && Objects.equals(lineage(), other.lineage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessDetails").add("Name", name()).add("ExecutablePath", executablePath())
                .add("ExecutableSha256", executableSha256()).add("NamespacePid", namespacePid()).add("Pwd", pwd())
                .add("Pid", pid()).add("StartTime", startTime()).add("Uuid", uuid()).add("ParentUuid", parentUuid())
                .add("User", user()).add("UserId", userId()).add("Euid", euid()).add("Lineage", hasLineage() ? lineage() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ExecutablePath":
            return Optional.ofNullable(clazz.cast(executablePath()));
        case "ExecutableSha256":
            return Optional.ofNullable(clazz.cast(executableSha256()));
        case "NamespacePid":
            return Optional.ofNullable(clazz.cast(namespacePid()));
        case "Pwd":
            return Optional.ofNullable(clazz.cast(pwd()));
        case "Pid":
            return Optional.ofNullable(clazz.cast(pid()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Uuid":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "ParentUuid":
            return Optional.ofNullable(clazz.cast(parentUuid()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Euid":
            return Optional.ofNullable(clazz.cast(euid()));
        case "Lineage":
            return Optional.ofNullable(clazz.cast(lineage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessDetails, T> g) {
        return obj -> g.apply((ProcessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessDetails> {
        /**
         * <p>
         * The name of the process.
         * </p>
         * 
         * @param name
         *        The name of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The absolute path of the process executable file.
         * </p>
         * 
         * @param executablePath
         *        The absolute path of the process executable file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executablePath(String executablePath);

        /**
         * <p>
         * The <code>SHA256</code> hash of the process executable.
         * </p>
         * 
         * @param executableSha256
         *        The <code>SHA256</code> hash of the process executable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableSha256(String executableSha256);

        /**
         * <p>
         * The ID of the child process.
         * </p>
         * 
         * @param namespacePid
         *        The ID of the child process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespacePid(Integer namespacePid);

        /**
         * <p>
         * The present working directory of the process.
         * </p>
         * 
         * @param pwd
         *        The present working directory of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pwd(String pwd);

        /**
         * <p>
         * The ID of the process.
         * </p>
         * 
         * @param pid
         *        The ID of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pid(Integer pid);

        /**
         * <p>
         * The time when the process started. This is in UTC format.
         * </p>
         * 
         * @param startTime
         *        The time when the process started. This is in UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The unique ID assigned to the process by GuardDuty.
         * </p>
         * 
         * @param uuid
         *        The unique ID assigned to the process by GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
         * </p>
         * 
         * @param parentUuid
         *        The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentUuid(String parentUuid);

        /**
         * <p>
         * The user that executed the process.
         * </p>
         * 
         * @param user
         *        The user that executed the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The unique ID of the user that executed the process.
         * </p>
         * 
         * @param userId
         *        The unique ID of the user that executed the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(Integer userId);

        /**
         * <p>
         * The effective user ID of the user that executed the process.
         * </p>
         * 
         * @param euid
         *        The effective user ID of the user that executed the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder euid(Integer euid);

        /**
         * <p>
         * Information about the process's lineage.
         * </p>
         * 
         * @param lineage
         *        Information about the process's lineage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineage(Collection<LineageObject> lineage);

        /**
         * <p>
         * Information about the process's lineage.
         * </p>
         * 
         * @param lineage
         *        Information about the process's lineage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineage(LineageObject... lineage);

        /**
         * <p>
         * Information about the process's lineage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.LineageObject.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.LineageObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.LineageObject.Builder#build()} is called immediately
         * and its result is passed to {@link #lineage(List<LineageObject>)}.
         * 
         * @param lineage
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.LineageObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineage(java.util.Collection<LineageObject>)
         */
        Builder lineage(Consumer<LineageObject.Builder>... lineage);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String executablePath;

        private String executableSha256;

        private Integer namespacePid;

        private String pwd;

        private Integer pid;

        private Instant startTime;

        private String uuid;

        private String parentUuid;

        private String user;

        private Integer userId;

        private Integer euid;

        private List<LineageObject> lineage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessDetails model) {
            name(model.name);
            executablePath(model.executablePath);
            executableSha256(model.executableSha256);
            namespacePid(model.namespacePid);
            pwd(model.pwd);
            pid(model.pid);
            startTime(model.startTime);
            uuid(model.uuid);
            parentUuid(model.parentUuid);
            user(model.user);
            userId(model.userId);
            euid(model.euid);
            lineage(model.lineage);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExecutablePath() {
            return executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final String getExecutableSha256() {
            return executableSha256;
        }

        public final void setExecutableSha256(String executableSha256) {
            this.executableSha256 = executableSha256;
        }

        @Override
        public final Builder executableSha256(String executableSha256) {
            this.executableSha256 = executableSha256;
            return this;
        }

        public final Integer getNamespacePid() {
            return namespacePid;
        }

        public final void setNamespacePid(Integer namespacePid) {
            this.namespacePid = namespacePid;
        }

        @Override
        public final Builder namespacePid(Integer namespacePid) {
            this.namespacePid = namespacePid;
            return this;
        }

        public final String getPwd() {
            return pwd;
        }

        public final void setPwd(String pwd) {
            this.pwd = pwd;
        }

        @Override
        public final Builder pwd(String pwd) {
            this.pwd = pwd;
            return this;
        }

        public final Integer getPid() {
            return pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getParentUuid() {
            return parentUuid;
        }

        public final void setParentUuid(String parentUuid) {
            this.parentUuid = parentUuid;
        }

        @Override
        public final Builder parentUuid(String parentUuid) {
            this.parentUuid = parentUuid;
            return this;
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final Integer getUserId() {
            return userId;
        }

        public final void setUserId(Integer userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public final Integer getEuid() {
            return euid;
        }

        public final void setEuid(Integer euid) {
            this.euid = euid;
        }

        @Override
        public final Builder euid(Integer euid) {
            this.euid = euid;
            return this;
        }

        public final List<LineageObject.Builder> getLineage() {
            List<LineageObject.Builder> result = LineageCopier.copyToBuilder(this.lineage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineage(Collection<LineageObject.BuilderImpl> lineage) {
            this.lineage = LineageCopier.copyFromBuilder(lineage);
        }

        @Override
        public final Builder lineage(Collection<LineageObject> lineage) {
            this.lineage = LineageCopier.copy(lineage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineage(LineageObject... lineage) {
            lineage(Arrays.asList(lineage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineage(Consumer<LineageObject.Builder>... lineage) {
            lineage(Stream.of(lineage).map(c -> LineageObject.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProcessDetails build() {
            return new ProcessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
