/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Total number of scanned files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScannedItemCount implements SdkPojo, Serializable,
        ToCopyableBuilder<ScannedItemCount.Builder, ScannedItemCount> {
    private static final SdkField<Integer> TOTAL_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalGb").getter(getter(ScannedItemCount::totalGb)).setter(setter(Builder::totalGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalGb").build()).build();

    private static final SdkField<Integer> FILES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Files")
            .getter(getter(ScannedItemCount::files)).setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build()).build();

    private static final SdkField<Integer> VOLUMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Volumes").getter(getter(ScannedItemCount::volumes)).setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_GB_FIELD, FILES_FIELD,
            VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalGb;

    private final Integer files;

    private final Integer volumes;

    private ScannedItemCount(BuilderImpl builder) {
        this.totalGb = builder.totalGb;
        this.files = builder.files;
        this.volumes = builder.volumes;
    }

    /**
     * <p>
     * Total GB of files scanned for malware.
     * </p>
     * 
     * @return Total GB of files scanned for malware.
     */
    public final Integer totalGb() {
        return totalGb;
    }

    /**
     * <p>
     * Number of files scanned.
     * </p>
     * 
     * @return Number of files scanned.
     */
    public final Integer files() {
        return files;
    }

    /**
     * <p>
     * Total number of scanned volumes.
     * </p>
     * 
     * @return Total number of scanned volumes.
     */
    public final Integer volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalGb());
        hashCode = 31 * hashCode + Objects.hashCode(files());
        hashCode = 31 * hashCode + Objects.hashCode(volumes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScannedItemCount)) {
            return false;
        }
        ScannedItemCount other = (ScannedItemCount) obj;
        return Objects.equals(totalGb(), other.totalGb()) && Objects.equals(files(), other.files())
                && Objects.equals(volumes(), other.volumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScannedItemCount").add("TotalGb", totalGb()).add("Files", files()).add("Volumes", volumes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalGb":
            return Optional.ofNullable(clazz.cast(totalGb()));
        case "Files":
            return Optional.ofNullable(clazz.cast(files()));
        case "Volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScannedItemCount, T> g) {
        return obj -> g.apply((ScannedItemCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScannedItemCount> {
        /**
         * <p>
         * Total GB of files scanned for malware.
         * </p>
         * 
         * @param totalGb
         *        Total GB of files scanned for malware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalGb(Integer totalGb);

        /**
         * <p>
         * Number of files scanned.
         * </p>
         * 
         * @param files
         *        Number of files scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Integer files);

        /**
         * <p>
         * Total number of scanned volumes.
         * </p>
         * 
         * @param volumes
         *        Total number of scanned volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Integer volumes);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalGb;

        private Integer files;

        private Integer volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(ScannedItemCount model) {
            totalGb(model.totalGb);
            files(model.files);
            volumes(model.volumes);
        }

        public final Integer getTotalGb() {
            return totalGb;
        }

        public final void setTotalGb(Integer totalGb) {
            this.totalGb = totalGb;
        }

        @Override
        public final Builder totalGb(Integer totalGb) {
            this.totalGb = totalGb;
            return this;
        }

        public final Integer getFiles() {
            return files;
        }

        public final void setFiles(Integer files) {
            this.files = files;
        }

        @Override
        public final Builder files(Integer files) {
            this.files = files;
            return this;
        }

        public final Integer getVolumes() {
            return volumes;
        }

        public final void setVolumes(Integer volumes) {
            this.volumes = volumes;
        }

        @Override
        public final Builder volumes(Integer volumes) {
            this.volumes = volumes;
            return this;
        }

        @Override
        public ScannedItemCount build() {
            return new ScannedItemCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
