/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;

public class ListIPSetsIterable
implements SdkIterable<ListIpSetsResponse> {
    private final GuardDutyClient client;
    private final ListIpSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIPSetsIterable(GuardDutyClient client, ListIpSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIpSetsResponseFetcher();
    }

    public Iterator<ListIpSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ipSetIds() {
        Function<ListIpSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipSetIds() != null) {
                return response.ipSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIpSetsResponseFetcher
    implements SyncPageFetcher<ListIpSetsResponse> {
        private ListIpSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListIpSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIpSetsResponse nextPage(ListIpSetsResponse previousPage) {
            if (previousPage == null) {
                return ListIPSetsIterable.this.client.listIPSets(ListIPSetsIterable.this.firstRequest);
            }
            return ListIPSetsIterable.this.client.listIPSets((ListIpSetsRequest)((Object)ListIPSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

