/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of accounts that have enabled a specific feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationFeatureStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationFeatureStatistics.Builder, OrganizationFeatureStatistics> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OrganizationFeatureStatistics::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> ENABLED_ACCOUNTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EnabledAccountsCount").getter(getter(OrganizationFeatureStatistics::enabledAccountsCount))
            .setter(setter(Builder::enabledAccountsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledAccountsCount").build())
            .build();

    private static final SdkField<List<OrganizationFeatureStatisticsAdditionalConfiguration>> ADDITIONAL_CONFIGURATION_FIELD = SdkField
            .<List<OrganizationFeatureStatisticsAdditionalConfiguration>> builder(MarshallingType.LIST)
            .memberName("AdditionalConfiguration")
            .getter(getter(OrganizationFeatureStatistics::additionalConfiguration))
            .setter(setter(Builder::additionalConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationFeatureStatisticsAdditionalConfiguration> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(OrganizationFeatureStatisticsAdditionalConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ENABLED_ACCOUNTS_COUNT_FIELD, ADDITIONAL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer enabledAccountsCount;

    private final List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration;

    private OrganizationFeatureStatistics(BuilderImpl builder) {
        this.name = builder.name;
        this.enabledAccountsCount = builder.enabledAccountsCount;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    /**
     * <p>
     * Name of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the feature.
     * @see OrgFeature
     */
    public final OrgFeature name() {
        return OrgFeature.fromValue(name);
    }

    /**
     * <p>
     * Name of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the feature.
     * @see OrgFeature
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Total number of accounts that have enabled a specific feature.
     * </p>
     * 
     * @return Total number of accounts that have enabled a specific feature.
     */
    public final Integer enabledAccountsCount() {
        return enabledAccountsCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalConfiguration() {
        return additionalConfiguration != null && !(additionalConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the additional configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConfiguration} method.
     * </p>
     * 
     * @return Name of the additional configuration.
     */
    public final List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration() {
        return additionalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConfiguration() ? additionalConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureStatistics)) {
            return false;
        }
        OrganizationFeatureStatistics other = (OrganizationFeatureStatistics) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(enabledAccountsCount(), other.enabledAccountsCount())
                && hasAdditionalConfiguration() == other.hasAdditionalConfiguration()
                && Objects.equals(additionalConfiguration(), other.additionalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationFeatureStatistics").add("Name", nameAsString())
                .add("EnabledAccountsCount", enabledAccountsCount())
                .add("AdditionalConfiguration", hasAdditionalConfiguration() ? additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "EnabledAccountsCount":
            return Optional.ofNullable(clazz.cast(enabledAccountsCount()));
        case "AdditionalConfiguration":
            return Optional.ofNullable(clazz.cast(additionalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationFeatureStatistics, T> g) {
        return obj -> g.apply((OrganizationFeatureStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationFeatureStatistics> {
        /**
         * <p>
         * Name of the feature.
         * </p>
         * 
         * @param name
         *        Name of the feature.
         * @see OrgFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeature
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the feature.
         * </p>
         * 
         * @param name
         *        Name of the feature.
         * @see OrgFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeature
         */
        Builder name(OrgFeature name);

        /**
         * <p>
         * Total number of accounts that have enabled a specific feature.
         * </p>
         * 
         * @param enabledAccountsCount
         *        Total number of accounts that have enabled a specific feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAccountsCount(Integer enabledAccountsCount);

        /**
         * <p>
         * Name of the additional configuration.
         * </p>
         * 
         * @param additionalConfiguration
         *        Name of the additional configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(Collection<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration);

        /**
         * <p>
         * Name of the additional configuration.
         * </p>
         * 
         * @param additionalConfiguration
         *        Name of the additional configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(OrganizationFeatureStatisticsAdditionalConfiguration... additionalConfiguration);

        /**
         * <p>
         * Name of the additional configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalConfiguration(List<OrganizationFeatureStatisticsAdditionalConfiguration>)}.
         * 
         * @param additionalConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsAdditionalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalConfiguration(java.util.Collection<OrganizationFeatureStatisticsAdditionalConfiguration>)
         */
        Builder additionalConfiguration(
                Consumer<OrganizationFeatureStatisticsAdditionalConfiguration.Builder>... additionalConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer enabledAccountsCount;

        private List<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationFeatureStatistics model) {
            name(model.name);
            enabledAccountsCount(model.enabledAccountsCount);
            additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Integer getEnabledAccountsCount() {
            return enabledAccountsCount;
        }

        public final void setEnabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
        }

        @Override
        public final Builder enabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
            return this;
        }

        public final List<OrganizationFeatureStatisticsAdditionalConfiguration.Builder> getAdditionalConfiguration() {
            List<OrganizationFeatureStatisticsAdditionalConfiguration.Builder> result = OrganizationFeatureStatisticsAdditionalConfigurationsCopier
                    .copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(
                Collection<OrganizationFeatureStatisticsAdditionalConfiguration.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = OrganizationFeatureStatisticsAdditionalConfigurationsCopier
                    .copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(
                Collection<OrganizationFeatureStatisticsAdditionalConfiguration> additionalConfiguration) {
            this.additionalConfiguration = OrganizationFeatureStatisticsAdditionalConfigurationsCopier
                    .copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(
                OrganizationFeatureStatisticsAdditionalConfiguration... additionalConfiguration) {
            additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(
                Consumer<OrganizationFeatureStatisticsAdditionalConfiguration.Builder>... additionalConfiguration) {
            additionalConfiguration(Stream.of(additionalConfiguration)
                    .map(c -> OrganizationFeatureStatisticsAdditionalConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OrganizationFeatureStatistics build() {
            return new OrganizationFeatureStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
