/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.CreateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.CreateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.CreateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.CreateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.GetFilterRequest;
import software.amazon.awssdk.services.guardduty.model.GetFilterResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.guardduty.model.GetIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.GetMembersRequest;
import software.amazon.awssdk.services.guardduty.model.GetMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetOrganizationStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetOrganizationStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest;
import software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.InviteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.InviteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListCoverageRequest;
import software.amazon.awssdk.services.guardduty.model.ListCoverageResponse;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanRequest;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanResponse;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.TagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.TagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.UntagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.UntagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansPublisher;
import software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationPublisher;
import software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListCoveragePublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListFiltersPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListIPSetsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsPublisher;
import software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsPublisher;

/**
 * Service client for accessing Amazon GuardDuty asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon GuardDuty is a continuous security monitoring service that analyzes and processes the following foundational
 * data sources - VPC flow logs, Amazon Web Services CloudTrail management event logs, CloudTrail S3 data event logs,
 * EKS audit logs, DNS logs, Amazon EBS volume data, runtime activity belonging to container workloads, such as Amazon
 * EKS, Amazon ECS (including Amazon Web Services Fargate), and Amazon EC2 instances. It uses threat intelligence feeds,
 * such as lists of malicious IPs and domains, and machine learning to identify unexpected, potentially unauthorized,
 * and malicious activity within your Amazon Web Services environment. This can include issues like escalations of
 * privileges, uses of exposed credentials, or communication with malicious IPs, domains, or presence of malware on your
 * Amazon EC2 instances and container workloads. For example, GuardDuty can detect compromised EC2 instances and
 * container workloads serving malware, or mining bitcoin.
 * </p>
 * <p>
 * GuardDuty also monitors Amazon Web Services account access behavior for signs of compromise, such as unauthorized
 * infrastructure deployments like EC2 instances deployed in a Region that has never been used, or unusual API calls
 * like a password policy change to reduce password strength.
 * </p>
 * <p>
 * GuardDuty informs you about the status of your Amazon Web Services environment by producing security findings that
 * you can view in the GuardDuty console or through Amazon EventBridge. For more information, see the <i> <a
 * href="https://docs.aws.amazon.com/guardduty/latest/ug/what-is-guardduty.html">Amazon GuardDuty User Guide</a> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GuardDutyAsyncClient extends AwsClient {
    String SERVICE_NAME = "guardduty";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "guardduty";

    /**
     * <p>
     * Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent
     * the invitation.
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     * @return A Java Future containing the result of the AcceptAdministratorInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptAdministratorInvitationResponse> acceptAdministratorInvitation(
            AcceptAdministratorInvitationRequest acceptAdministratorInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent
     * the invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAdministratorInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptAdministratorInvitationRequest#builder()}
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptAdministratorInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptAdministratorInvitationResponse> acceptAdministratorInvitation(
            Consumer<AcceptAdministratorInvitationRequest.Builder> acceptAdministratorInvitationRequest) {
        return acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.builder()
                .applyMutation(acceptAdministratorInvitationRequest).build());
    }

    /**
     * <p>
     * Accepts the invitation to be monitored by a GuardDuty administrator account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use AcceptAdministratorInvitation instead
     */
    @Deprecated
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be monitored by a GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use AcceptAdministratorInvitation instead
     */
    @Deprecated
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(
            Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest) {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Archives GuardDuty findings that are specified by the list of finding IDs.
     * </p>
     * <note>
     * <p>
     * Only the administrator account can archive findings. Member accounts don't have permission to archive findings
     * from their accounts.
     * </p>
     * </note>
     *
     * @param archiveFindingsRequest
     * @return A Java Future containing the result of the ArchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ArchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ArchiveFindingsResponse> archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archives GuardDuty findings that are specified by the list of finding IDs.
     * </p>
     * <note>
     * <p>
     * Only the administrator account can archive findings. Member accounts don't have permission to archive findings
     * from their accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ArchiveFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link ArchiveFindingsRequest#builder()}
     * </p>
     *
     * @param archiveFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ArchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ArchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ArchiveFindingsResponse> archiveFindings(
            Consumer<ArchiveFindingsRequest.Builder> archiveFindingsRequest) {
        return archiveFindings(ArchiveFindingsRequest.builder().applyMutation(archiveFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To
     * start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only
     * one detector per account per Region. All data sources are enabled in a new detector by default.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param createDetectorRequest
     * @return A Java Future containing the result of the CreateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDetectorResponse> createDetector(CreateDetectorRequest createDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To
     * start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only
     * one detector per account per Region. All data sources are enabled in a new detector by default.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDetectorRequest#builder()}
     * </p>
     *
     * @param createDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDetectorResponse> createDetector(Consumer<CreateDetectorRequest.Builder> createDetectorRequest) {
        return createDetector(CreateDetectorRequest.builder().applyMutation(createDetectorRequest).build());
    }

    /**
     * <p>
     * Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web
     * Services account per Region is 100. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html">Quotas for GuardDuty</a>.
     * </p>
     *
     * @param createFilterRequest
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFilterResponse> createFilter(CreateFilterRequest createFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web
     * Services account per Region is 100. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html">Quotas for GuardDuty</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFilterRequest#builder()}
     * </p>
     *
     * @param createFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreateFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFilterResponse> createFilter(Consumer<CreateFilterRequest.Builder> createFilterRequest) {
        return createFilter(CreateFilterRequest.builder().applyMutation(createFilterRequest).build());
    }

    /**
     * <p>
     * Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP
     * addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications.
     * GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the
     * administrator account can use this operation.
     * </p>
     *
     * @param createIpSetRequest
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpSetResponse> createIPSet(CreateIpSetRequest createIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP
     * addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications.
     * GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the
     * administrator account can use this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpSetRequest#builder()}
     * </p>
     *
     * @param createIpSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpSetResponse> createIPSet(Consumer<CreateIpSetRequest.Builder> createIpSetRequest) {
        return createIPSet(CreateIpSetRequest.builder().applyMutation(createIpSetRequest).build());
    }

    /**
     * <p>
     * Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services
     * account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or
     * through an organization.
     * </p>
     * <p>
     * As a delegated administrator, using <code>CreateMembers</code> will enable GuardDuty in the added member
     * accounts, with the exception of the organization delegated administrator account. A delegated administrator must
     * enable GuardDuty prior to being added as a member.
     * </p>
     * <p>
     * When you use CreateMembers as an Organizations delegated administrator, GuardDuty applies your organization's
     * auto-enable settings to the member accounts in this request, irrespective of the accounts being new or existing
     * members. For more information about the existing auto-enable settings for your organization, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DescribeOrganizationConfiguration.html"
     * >DescribeOrganizationConfiguration</a>.
     * </p>
     * <p>
     * If you are adding accounts by invitation, before using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a>, use
     * <code>CreateMembers</code> after GuardDuty has been enabled in potential member accounts.
     * </p>
     * <p>
     * If you disassociate a member from a GuardDuty delegated administrator, the member account details obtained from
     * this API, including the associated email addresses, will be retained. This is done so that the delegated
     * administrator can invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     *
     * @param createMembersRequest
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMembersResponse> createMembers(CreateMembersRequest createMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services
     * account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or
     * through an organization.
     * </p>
     * <p>
     * As a delegated administrator, using <code>CreateMembers</code> will enable GuardDuty in the added member
     * accounts, with the exception of the organization delegated administrator account. A delegated administrator must
     * enable GuardDuty prior to being added as a member.
     * </p>
     * <p>
     * When you use CreateMembers as an Organizations delegated administrator, GuardDuty applies your organization's
     * auto-enable settings to the member accounts in this request, irrespective of the accounts being new or existing
     * members. For more information about the existing auto-enable settings for your organization, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DescribeOrganizationConfiguration.html"
     * >DescribeOrganizationConfiguration</a>.
     * </p>
     * <p>
     * If you are adding accounts by invitation, before using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a>, use
     * <code>CreateMembers</code> after GuardDuty has been enabled in potential member accounts.
     * </p>
     * <p>
     * If you disassociate a member from a GuardDuty delegated administrator, the member account details obtained from
     * this API, including the associated email addresses, will be retained. This is done so that the delegated
     * administrator can invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembersRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMembersRequest#builder()}
     * </p>
     *
     * @param createMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreateMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMembersResponse> createMembers(Consumer<CreateMembersRequest.Builder> createMembersRequest) {
        return createMembers(CreateMembersRequest.builder().applyMutation(createMembersRequest).build());
    }

    /**
     * <p>
     * Creates a publishing destination to export findings to. The resource to export findings to must exist before you
     * use this operation.
     * </p>
     *
     * @param createPublishingDestinationRequest
     * @return A Java Future containing the result of the CreatePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePublishingDestinationResponse> createPublishingDestination(
            CreatePublishingDestinationRequest createPublishingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a publishing destination to export findings to. The resource to export findings to must exist before you
     * use this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param createPublishingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreatePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePublishingDestinationResponse> createPublishingDestination(
            Consumer<CreatePublishingDestinationRequest.Builder> createPublishingDestinationRequest) {
        return createPublishingDestination(CreatePublishingDestinationRequest.builder()
                .applyMutation(createPublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Generates sample findings of types specified by the list of finding types. If 'NULL' is specified for
     * <code>findingTypes</code>, the API generates sample findings of all supported finding types.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            CreateSampleFindingsRequest createSampleFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates sample findings of types specified by the list of finding types. If 'NULL' is specified for
     * <code>findingTypes</code>, the API generates sample findings of all supported finding types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSampleFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSampleFindingsRequest#builder()}
     * </p>
     *
     * @param createSampleFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            Consumer<CreateSampleFindingsRequest.Builder> createSampleFindingsRequest) {
        return createSampleFindings(CreateSampleFindingsRequest.builder().applyMutation(createSampleFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates
     * findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
     * </p>
     *
     * @param createThreatIntelSetRequest
     * @return A Java Future containing the result of the CreateThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateThreatIntelSetResponse> createThreatIntelSet(
            CreateThreatIntelSetRequest createThreatIntelSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates
     * findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThreatIntelSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param createThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateThreatIntelSetResponse> createThreatIntelSet(
            Consumer<CreateThreatIntelSetRequest.Builder> createThreatIntelSetRequest) {
        return createThreatIntelSet(CreateThreatIntelSetRequest.builder().applyMutation(createThreatIntelSetRequest).build());
    }

    /**
     * <p>
     * Declines invitations sent to the current member account by Amazon Web Services accounts specified by their
     * account IDs.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines invitations sent to the current member account by Amazon Web Services accounts specified by their
     * account IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(
            Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest) {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon GuardDuty detector that is specified by the detector ID.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return A Java Future containing the result of the DeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDetectorResponse> deleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon GuardDuty detector that is specified by the detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDetectorRequest#builder()}
     * </p>
     *
     * @param deleteDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDetectorResponse> deleteDetector(Consumer<DeleteDetectorRequest.Builder> deleteDetectorRequest) {
        return deleteDetector(DeleteDetectorRequest.builder().applyMutation(deleteDetectorRequest).build());
    }

    /**
     * <p>
     * Deletes the filter specified by the filter name.
     * </p>
     *
     * @param deleteFilterRequest
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFilterResponse> deleteFilter(DeleteFilterRequest deleteFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the filter specified by the filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFilterRequest#builder()}
     * </p>
     *
     * @param deleteFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFilterResponse> deleteFilter(Consumer<DeleteFilterRequest.Builder> deleteFilterRequest) {
        return deleteFilter(DeleteFilterRequest.builder().applyMutation(deleteFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP lists in the console user
     * interface.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpSetResponse> deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP lists in the console user
     * interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpSetRequest#builder()}
     * </p>
     *
     * @param deleteIpSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpSetResponse> deleteIPSet(Consumer<DeleteIpSetRequest.Builder> deleteIpSetRequest) {
        return deleteIPSet(DeleteIpSetRequest.builder().applyMutation(deleteIpSetRequest).build());
    }

    /**
     * <p>
     * Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account
     * IDs.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(
            Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest) {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty for a member account in your organization.
     * </p>
     *
     * @param deleteMembersRequest
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMembersResponse> deleteMembers(DeleteMembersRequest deleteMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty for a member account in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMembersRequest#builder()}
     * </p>
     *
     * @param deleteMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMembersResponse> deleteMembers(Consumer<DeleteMembersRequest.Builder> deleteMembersRequest) {
        return deleteMembers(DeleteMembersRequest.builder().applyMutation(deleteMembersRequest).build());
    }

    /**
     * <p>
     * Deletes the publishing definition with the specified <code>destinationId</code>.
     * </p>
     *
     * @param deletePublishingDestinationRequest
     * @return A Java Future containing the result of the DeletePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeletePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePublishingDestinationResponse> deletePublishingDestination(
            DeletePublishingDestinationRequest deletePublishingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the publishing definition with the specified <code>destinationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param deletePublishingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeletePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePublishingDestinationResponse> deletePublishingDestination(
            Consumer<DeletePublishingDestinationRequest.Builder> deletePublishingDestinationRequest) {
        return deletePublishingDestination(DeletePublishingDestinationRequest.builder()
                .applyMutation(deletePublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param deleteThreatIntelSetRequest
     * @return A Java Future containing the result of the DeleteThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteThreatIntelSetResponse> deleteThreatIntelSet(
            DeleteThreatIntelSetRequest deleteThreatIntelSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThreatIntelSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param deleteThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteThreatIntelSetResponse> deleteThreatIntelSet(
            Consumer<DeleteThreatIntelSetRequest.Builder> deleteThreatIntelSetRequest) {
        return deleteThreatIntelSet(DeleteThreatIntelSetRequest.builder().applyMutation(deleteThreatIntelSetRequest).build());
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param describeMalwareScansRequest
     * @return A Java Future containing the result of the DescribeMalwareScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMalwareScansResponse> describeMalwareScans(
            DescribeMalwareScansRequest describeMalwareScansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMalwareScansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMalwareScansRequest#builder()}
     * </p>
     *
     * @param describeMalwareScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeMalwareScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMalwareScansResponse> describeMalwareScans(
            Consumer<DescribeMalwareScansRequest.Builder> describeMalwareScansRequest) {
        return describeMalwareScans(DescribeMalwareScansRequest.builder().applyMutation(describeMalwareScansRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansPublisher publisher = client.describeMalwareScansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansPublisher publisher = client.describeMalwareScansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMalwareScansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMalwareScansPublisher describeMalwareScansPaginator(DescribeMalwareScansRequest describeMalwareScansRequest) {
        return new DescribeMalwareScansPublisher(this, describeMalwareScansRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansPublisher publisher = client.describeMalwareScansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeMalwareScansPublisher publisher = client.describeMalwareScansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMalwareScans(software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMalwareScansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMalwareScansRequest#builder()}
     * </p>
     *
     * @param describeMalwareScansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMalwareScansPublisher describeMalwareScansPaginator(
            Consumer<DescribeMalwareScansRequest.Builder> describeMalwareScansRequest) {
        return describeMalwareScansPaginator(DescribeMalwareScansRequest.builder().applyMutation(describeMalwareScansRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest) {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationPublisher publisher = client.describeOrganizationConfigurationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationPublisher publisher = client.describeOrganizationConfigurationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationPublisher describeOrganizationConfigurationPaginator(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        return new DescribeOrganizationConfigurationPublisher(this, describeOrganizationConfigurationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationPublisher publisher = client.describeOrganizationConfigurationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.DescribeOrganizationConfigurationPublisher publisher = client.describeOrganizationConfigurationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfiguration(software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationPublisher describeOrganizationConfigurationPaginator(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest) {
        return describeOrganizationConfigurationPaginator(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about the publishing destination specified by the provided <code>destinationId</code>.
     * </p>
     *
     * @param describePublishingDestinationRequest
     * @return A Java Future containing the result of the DescribePublishingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePublishingDestinationResponse> describePublishingDestination(
            DescribePublishingDestinationRequest describePublishingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the publishing destination specified by the provided <code>destinationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param describePublishingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePublishingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePublishingDestinationResponse> describePublishingDestination(
            Consumer<DescribePublishingDestinationRequest.Builder> describePublishingDestinationRequest) {
        return describePublishingDestination(DescribePublishingDestinationRequest.builder()
                .applyMutation(describePublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Removes the existing GuardDuty delegated administrator of the organization. Only the organization's management
     * account can run this API operation.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the existing GuardDuty delegated administrator of the organization. Only the organization's management
     * account can run this API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            Consumer<DisableOrganizationAdminAccountRequest.Builder> disableOrganizationAdminAccountRequest) {
        return disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder()
                .applyMutation(disableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty in a member account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty in a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateFromAdministratorAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateFromAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            Consumer<DisassociateFromAdministratorAccountRequest.Builder> disassociateFromAdministratorAccountRequest) {
        return disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder()
                .applyMutation(disassociateFromAdministratorAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is deprecated, use DisassociateFromAdministratorAccount instead
     */
    @Deprecated
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is deprecated, use DisassociateFromAdministratorAccount instead
     */
    @Deprecated
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest) {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates GuardDuty member accounts (from the current administrator account) specified by the account IDs.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disassociate a member account before removing them from your
     * organization.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            DisassociateMembersRequest disassociateMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates GuardDuty member accounts (from the current administrator account) specified by the account IDs.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disassociate a member account before removing them from your
     * organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMembersRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMembersRequest#builder()}
     * </p>
     *
     * @param disassociateMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            Consumer<DisassociateMembersRequest.Builder> disassociateMembersRequest) {
        return disassociateMembers(DisassociateMembersRequest.builder().applyMutation(disassociateMembersRequest).build());
    }

    /**
     * <p>
     * Designates an Amazon Web Services account within the organization as your GuardDuty delegated administrator. Only
     * the organization's management account can run this API operation.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates an Amazon Web Services account within the organization as your GuardDuty delegated administrator. Only
     * the organization's management account can run this API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            Consumer<EnableOrganizationAdminAccountRequest.Builder> enableOrganizationAdminAccountRequest) {
        return enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder()
                .applyMutation(enableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Provides the details of the GuardDuty administrator account associated with the current GuardDuty member account.
     * </p>
     * <note>
     * <p>
     * If the organization's management account or a delegated administrator runs this API, it will return success (
     * <code>HTTP 200</code>) but no content.
     * </p>
     * </note>
     *
     * @param getAdministratorAccountRequest
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            GetAdministratorAccountRequest getAdministratorAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details of the GuardDuty administrator account associated with the current GuardDuty member account.
     * </p>
     * <note>
     * <p>
     * If the organization's management account or a delegated administrator runs this API, it will return success (
     * <code>HTTP 200</code>) but no content.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdministratorAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param getAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            Consumer<GetAdministratorAccountRequest.Builder> getAdministratorAccountRequest) {
        return getAdministratorAccount(GetAdministratorAccountRequest.builder().applyMutation(getAdministratorAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the
     * statistics for all the resources associated with the active member accounts in your organization who have enabled
     * Runtime Monitoring and have the GuardDuty security agent running on their resources.
     * </p>
     *
     * @param getCoverageStatisticsRequest
     * @return A Java Future containing the result of the GetCoverageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoverageStatisticsResponse> getCoverageStatistics(
            GetCoverageStatisticsRequest getCoverageStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the
     * statistics for all the resources associated with the active member accounts in your organization who have enabled
     * Runtime Monitoring and have the GuardDuty security agent running on their resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoverageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCoverageStatisticsRequest#builder()}
     * </p>
     *
     * @param getCoverageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCoverageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoverageStatisticsResponse> getCoverageStatistics(
            Consumer<GetCoverageStatisticsRequest.Builder> getCoverageStatisticsRequest) {
        return getCoverageStatistics(GetCoverageStatisticsRequest.builder().applyMutation(getCoverageStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves an Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getDetectorRequest
     * @return A Java Future containing the result of the GetDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDetectorResponse> getDetector(GetDetectorRequest getDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorRequest#builder()}
     * </p>
     *
     * @param getDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDetectorResponse> getDetector(Consumer<GetDetectorRequest.Builder> getDetectorRequest) {
        return getDetector(GetDetectorRequest.builder().applyMutation(getDetectorRequest).build());
    }

    /**
     * <p>
     * Returns the details of the filter specified by the filter name.
     * </p>
     *
     * @param getFilterRequest
     * @return A Java Future containing the result of the GetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFilterResponse> getFilter(GetFilterRequest getFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the filter specified by the filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFilterRequest.Builder} avoiding the need to
     * create one manually via {@link GetFilterRequest#builder()}
     * </p>
     *
     * @param getFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFilterResponse> getFilter(Consumer<GetFilterRequest.Builder> getFilterRequest) {
        return getFilter(GetFilterRequest.builder().applyMutation(getFilterRequest).build());
    }

    /**
     * <p>
     * Describes Amazon GuardDuty findings specified by finding IDs.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes Amazon GuardDuty findings specified by finding IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings statistics for the specified detector ID.
     * </p>
     * <p>
     * There might be regional differences because some flags might not be available in all the Regions where GuardDuty
     * is currently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getFindingsStatisticsRequest
     * @return A Java Future containing the result of the GetFindingsStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFindingsStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFindingsStatisticsResponse> getFindingsStatistics(
            GetFindingsStatisticsRequest getFindingsStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings statistics for the specified detector ID.
     * </p>
     * <p>
     * There might be regional differences because some flags might not be available in all the Regions where GuardDuty
     * is currently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetFindingsStatisticsRequest#builder()}
     * </p>
     *
     * @param getFindingsStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFindingsStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFindingsStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFindingsStatisticsResponse> getFindingsStatistics(
            Consumer<GetFindingsStatisticsRequest.Builder> getFindingsStatisticsRequest) {
        return getFindingsStatistics(GetFindingsStatisticsRequest.builder().applyMutation(getFindingsStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves the IPSet specified by the <code>ipSetId</code>.
     * </p>
     *
     * @param getIpSetRequest
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIpSetResponse> getIPSet(GetIpSetRequest getIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the IPSet specified by the <code>ipSetId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetIpSetRequest#builder()}
     * </p>
     *
     * @param getIpSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetIpSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIpSetResponse> getIPSet(Consumer<GetIpSetRequest.Builder> getIpSetRequest) {
        return getIPSet(GetIpSetRequest.builder().applyMutation(getIpSetRequest).build());
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     *
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount() {
        return getInvitationsCount(GetInvitationsCountRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getMalwareScanSettingsRequest
     * @return A Java Future containing the result of the GetMalwareScanSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMalwareScanSettingsResponse> getMalwareScanSettings(
            GetMalwareScanSettingsRequest getMalwareScanSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMalwareScanSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetMalwareScanSettingsRequest#builder()}
     * </p>
     *
     * @param getMalwareScanSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMalwareScanSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMalwareScanSettingsResponse> getMalwareScanSettings(
            Consumer<GetMalwareScanSettingsRequest.Builder> getMalwareScanSettingsRequest) {
        return getMalwareScanSettings(GetMalwareScanSettingsRequest.builder().applyMutation(getMalwareScanSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use GetAdministratorAccount instead
     */
    @Deprecated
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This operation is deprecated, use GetAdministratorAccount instead
     */
    @Deprecated
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(
            Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest) {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * Describes which data sources are enabled for the member account's detector.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getMemberDetectorsRequest
     * @return A Java Future containing the result of the GetMemberDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMemberDetectorsResponse> getMemberDetectors(GetMemberDetectorsRequest getMemberDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes which data sources are enabled for the member account's detector.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetMemberDetectorsRequest#builder()}
     * </p>
     *
     * @param getMemberDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMemberDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMemberDetectorsResponse> getMemberDetectors(
            Consumer<GetMemberDetectorsRequest.Builder> getMemberDetectorsRequest) {
        return getMemberDetectors(GetMemberDetectorsRequest.builder().applyMutation(getMemberDetectorsRequest).build());
    }

    /**
     * <p>
     * Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account
     * IDs.
     * </p>
     *
     * @param getMembersRequest
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembersResponse> getMembers(GetMembersRequest getMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembersRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembersRequest#builder()}
     * </p>
     *
     * @param getMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembersResponse> getMembers(Consumer<GetMembersRequest.Builder> getMembersRequest) {
        return getMembers(GetMembersRequest.builder().applyMutation(getMembersRequest).build());
    }

    /**
     * <p>
     * Retrieves how many active member accounts in your Amazon Web Services organization have each feature enabled
     * within GuardDuty. Only a delegated GuardDuty administrator of an organization can run this API.
     * </p>
     * <p>
     * When you create a new Amazon Web Services organization, it might take up to 24 hours to generate the statistics
     * for the entire organization.
     * </p>
     *
     * @param getOrganizationStatisticsRequest
     * @return A Java Future containing the result of the GetOrganizationStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetOrganizationStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetOrganizationStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationStatisticsResponse> getOrganizationStatistics(
            GetOrganizationStatisticsRequest getOrganizationStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves how many active member accounts in your Amazon Web Services organization have each feature enabled
     * within GuardDuty. Only a delegated GuardDuty administrator of an organization can run this API.
     * </p>
     * <p>
     * When you create a new Amazon Web Services organization, it might take up to 24 hours to generate the statistics
     * for the entire organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link GetOrganizationStatisticsRequest#builder()}
     * </p>
     *
     * @param getOrganizationStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetOrganizationStatisticsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetOrganizationStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetOrganizationStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetOrganizationStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationStatisticsResponse> getOrganizationStatistics(
            Consumer<GetOrganizationStatisticsRequest.Builder> getOrganizationStatisticsRequest) {
        return getOrganizationStatistics(GetOrganizationStatisticsRequest.builder()
                .applyMutation(getOrganizationStatisticsRequest).build());
    }

    /**
     * <p>
     * Provides the number of days left for each data source used in the free trial period.
     * </p>
     *
     * @param getRemainingFreeTrialDaysRequest
     * @return A Java Future containing the result of the GetRemainingFreeTrialDays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetRemainingFreeTrialDays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetRemainingFreeTrialDays"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRemainingFreeTrialDaysResponse> getRemainingFreeTrialDays(
            GetRemainingFreeTrialDaysRequest getRemainingFreeTrialDaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the number of days left for each data source used in the free trial period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRemainingFreeTrialDaysRequest.Builder} avoiding
     * the need to create one manually via {@link GetRemainingFreeTrialDaysRequest#builder()}
     * </p>
     *
     * @param getRemainingFreeTrialDaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRemainingFreeTrialDays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetRemainingFreeTrialDays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetRemainingFreeTrialDays"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRemainingFreeTrialDaysResponse> getRemainingFreeTrialDays(
            Consumer<GetRemainingFreeTrialDaysRequest.Builder> getRemainingFreeTrialDaysRequest) {
        return getRemainingFreeTrialDays(GetRemainingFreeTrialDaysRequest.builder()
                .applyMutation(getRemainingFreeTrialDaysRequest).build());
    }

    /**
     * <p>
     * Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param getThreatIntelSetRequest
     * @return A Java Future containing the result of the GetThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetThreatIntelSetResponse> getThreatIntelSet(GetThreatIntelSetRequest getThreatIntelSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThreatIntelSetRequest.Builder} avoiding the need
     * to create one manually via {@link GetThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param getThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetThreatIntelSetResponse> getThreatIntelSet(
            Consumer<GetThreatIntelSetRequest.Builder> getThreatIntelSetRequest) {
        return getThreatIntelSet(GetThreatIntelSetRequest.builder().applyMutation(getThreatIntelSetRequest).build());
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetUsageStatisticsRequest#builder()}
     * </p>
     *
     * @param getUsageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(
            Consumer<GetUsageStatisticsRequest.Builder> getUsageStatisticsRequest) {
        return getUsageStatistics(GetUsageStatisticsRequest.builder().applyMutation(getUsageStatisticsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUsageStatisticsPublisher getUsageStatisticsPaginator(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        return new GetUsageStatisticsPublisher(this, getUsageStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetUsageStatisticsRequest#builder()}
     * </p>
     *
     * @param getUsageStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUsageStatisticsPublisher getUsageStatisticsPaginator(
            Consumer<GetUsageStatisticsRequest.Builder> getUsageStatisticsRequest) {
        return getUsageStatisticsPaginator(GetUsageStatisticsRequest.builder().applyMutation(getUsageStatisticsRequest).build());
    }

    /**
     * <p>
     * Invites Amazon Web Services accounts to become members of an organization administered by the Amazon Web Services
     * account that invokes this API. If you are using Amazon Web Services Organizations to manage your GuardDuty
     * environment, this step is not needed. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html">Managing accounts with
     * organizations</a>.
     * </p>
     * <p>
     * To invite Amazon Web Services accounts, the first step is to ensure that GuardDuty has been enabled in the
     * potential member accounts. You can now invoke this API to add accounts by invitation. The invited accounts can
     * either accept or decline the invitation from their GuardDuty accounts. Each invited Amazon Web Services account
     * can choose to accept the invitation from only one Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_invitations.html">Managing GuardDuty accounts by
     * invitation</a>.
     * </p>
     * <p>
     * After the invite has been accepted and you choose to disassociate a member account (by using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DisassociateMembers.html"
     * >DisassociateMembers</a>) from your account, the details of the member account obtained by invoking <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a>,
     * including the associated email addresses, will be retained. This is done so that you can invoke InviteMembers
     * without the need to invoke <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> again.
     * To remove the details associated with a member account, you must also invoke <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a>.
     * </p>
     *
     * @param inviteMembersRequest
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteMembersResponse> inviteMembers(InviteMembersRequest inviteMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invites Amazon Web Services accounts to become members of an organization administered by the Amazon Web Services
     * account that invokes this API. If you are using Amazon Web Services Organizations to manage your GuardDuty
     * environment, this step is not needed. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html">Managing accounts with
     * organizations</a>.
     * </p>
     * <p>
     * To invite Amazon Web Services accounts, the first step is to ensure that GuardDuty has been enabled in the
     * potential member accounts. You can now invoke this API to add accounts by invitation. The invited accounts can
     * either accept or decline the invitation from their GuardDuty accounts. Each invited Amazon Web Services account
     * can choose to accept the invitation from only one Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_invitations.html">Managing GuardDuty accounts by
     * invitation</a>.
     * </p>
     * <p>
     * After the invite has been accepted and you choose to disassociate a member account (by using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DisassociateMembers.html"
     * >DisassociateMembers</a>) from your account, the details of the member account obtained by invoking <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a>,
     * including the associated email addresses, will be retained. This is done so that you can invoke InviteMembers
     * without the need to invoke <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> again.
     * To remove the details associated with a member account, you must also invoke <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteMembersRequest#builder()}
     * </p>
     *
     * @param inviteMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.InviteMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteMembersResponse> inviteMembers(Consumer<InviteMembersRequest.Builder> inviteMembersRequest) {
        return inviteMembers(InviteMembersRequest.builder().applyMutation(inviteMembersRequest).build());
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have Runtime Monitoring enabled and GuardDuty agent running on their resources.
     * </p>
     *
     * @param listCoverageRequest
     * @return A Java Future containing the result of the ListCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCoverageResponse> listCoverage(ListCoverageRequest listCoverageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have Runtime Monitoring enabled and GuardDuty agent running on their resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListCoverageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCoverageResponse> listCoverage(Consumer<ListCoverageRequest.Builder> listCoverageRequest) {
        return listCoverage(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListCoverageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListCoverageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)} operation.</b>
     * </p>
     *
     * @param listCoverageRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoveragePublisher listCoveragePaginator(ListCoverageRequest listCoverageRequest) {
        return new ListCoveragePublisher(this, listCoverageRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListCoveragePublisher publisher = client.listCoveragePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListCoverageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListCoverageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoverage(software.amazon.awssdk.services.guardduty.model.ListCoverageRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoverageRequest.Builder} avoiding the need to
     * create one manually via {@link ListCoverageRequest#builder()}
     * </p>
     *
     * @param listCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListCoverageRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCoveragePublisher listCoveragePaginator(Consumer<ListCoverageRequest.Builder> listCoverageRequest) {
        return listCoveragePaginator(ListCoverageRequest.builder().applyMutation(listCoverageRequest).build());
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     *
     * @param listDetectorsRequest
     * @return A Java Future containing the result of the ListDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDetectorsResponse> listDetectors(ListDetectorsRequest listDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDetectorsResponse> listDetectors(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest) {
        return listDetectors(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     *
     * @return A Java Future containing the result of the ListDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDetectorsResponse> listDetectors() {
        return listDetectors(ListDetectorsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher publisher = client.listDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher publisher = client.listDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsPublisher listDetectorsPaginator() {
        return listDetectorsPaginator(ListDetectorsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher publisher = client.listDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher publisher = client.listDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     *
     * @param listDetectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsPublisher listDetectorsPaginator(ListDetectorsRequest listDetectorsRequest) {
        return new ListDetectorsPublisher(this, listDetectorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher publisher = client.listDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsPublisher publisher = client.listDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDetectorsPublisher listDetectorsPaginator(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest) {
        return listDetectorsPaginator(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     *
     * @param listFiltersRequest
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFiltersResponse> listFilters(ListFiltersRequest listFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListFiltersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFiltersResponse> listFilters(Consumer<ListFiltersRequest.Builder> listFiltersRequest) {
        return listFilters(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersPublisher listFiltersPaginator(ListFiltersRequest listFiltersRequest) {
        return new ListFiltersPublisher(this, listFiltersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersPublisher publisher = client.listFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListFiltersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersPublisher listFiltersPaginator(Consumer<ListFiltersRequest.Builder> listFiltersRequest) {
        return listFiltersPaginator(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists GuardDuty findings for the specified detector ID.
     * </p>
     * <p>
     * There might be regional differences because some flags might not be available in all the Regions where GuardDuty
     * is currently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists GuardDuty findings for the specified detector ID.
     * </p>
     * <p>
     * There might be regional differences because some flags might not be available in all the Regions where GuardDuty
     * is currently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        return new ListFindingsPublisher(this, listFindingsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListFindingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     *
     * @param listIpSetsRequest
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpSetsResponse> listIPSets(ListIpSetsRequest listIpSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpSetsResponse> listIPSets(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest) {
        return listIPSets(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsPublisher publisher = client.listIPSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsPublisher publisher = client.listIPSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)} operation.</b>
     * </p>
     *
     * @param listIpSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIPSetsPublisher listIPSetsPaginator(ListIpSetsRequest listIpSetsRequest) {
        return new ListIPSetsPublisher(this, listIpSetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsPublisher publisher = client.listIPSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsPublisher publisher = client.listIPSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIPSetsPublisher listIPSetsPaginator(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest) {
        return listIPSetsPaginator(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(
            Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations() {
        return listInvitations(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator() {
        return listInvitationsPaginator(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) {
        return new ListInvitationsPublisher(this, listInvitationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        return new ListMembersPublisher(this, listMembersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists the accounts designated as GuardDuty delegated administrators. Only the organization's management account
     * can run this API operation.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the accounts designated as GuardDuty delegated administrators. Only the organization's management account
     * can run this API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest) {
        return listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        return new ListOrganizationAdminAccountsPublisher(this, listOrganizationAdminAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest) {
        return listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return A Java Future containing the result of the ListPublishingDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPublishingDestinationsResponse> listPublishingDestinations(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublishingDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPublishingDestinationsRequest#builder()}
     * </p>
     *
     * @param listPublishingDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPublishingDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPublishingDestinationsResponse> listPublishingDestinations(
            Consumer<ListPublishingDestinationsRequest.Builder> listPublishingDestinationsRequest) {
        return listPublishingDestinations(ListPublishingDestinationsRequest.builder()
                .applyMutation(listPublishingDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsPublisher publisher = client.listPublishingDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsPublisher publisher = client.listPublishingDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishingDestinationsPublisher listPublishingDestinationsPaginator(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) {
        return new ListPublishingDestinationsPublisher(this, listPublishingDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsPublisher publisher = client.listPublishingDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsPublisher publisher = client.listPublishingDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublishingDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPublishingDestinationsRequest#builder()}
     * </p>
     *
     * @param listPublishingDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPublishingDestinationsPublisher listPublishingDestinationsPaginator(
            Consumer<ListPublishingDestinationsRequest.Builder> listPublishingDestinationsRequest) {
        return listPublishingDestinationsPaginator(ListPublishingDestinationsRequest.builder()
                .applyMutation(listPublishingDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, threat intel
     * sets, and publishing destination, with a limit of 50 tags per resource. When invoked, this operation returns all
     * assigned tags for a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, threat intel
     * sets, and publishing destination, with a limit of 50 tags per resource. When invoked, this operation returns all
     * assigned tags for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return A Java Future containing the result of the ListThreatIntelSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListThreatIntelSetsResponse> listThreatIntelSets(
            ListThreatIntelSetsRequest listThreatIntelSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThreatIntelSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListThreatIntelSetsRequest#builder()}
     * </p>
     *
     * @param listThreatIntelSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListThreatIntelSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListThreatIntelSetsResponse> listThreatIntelSets(
            Consumer<ListThreatIntelSetsRequest.Builder> listThreatIntelSetsRequest) {
        return listThreatIntelSets(ListThreatIntelSetsRequest.builder().applyMutation(listThreatIntelSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsPublisher publisher = client.listThreatIntelSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsPublisher publisher = client.listThreatIntelSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThreatIntelSetsPublisher listThreatIntelSetsPaginator(ListThreatIntelSetsRequest listThreatIntelSetsRequest) {
        return new ListThreatIntelSetsPublisher(this, listThreatIntelSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsPublisher publisher = client.listThreatIntelSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsPublisher publisher = client.listThreatIntelSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThreatIntelSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListThreatIntelSetsRequest#builder()}
     * </p>
     *
     * @param listThreatIntelSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThreatIntelSetsPublisher listThreatIntelSetsPaginator(
            Consumer<ListThreatIntelSetsRequest.Builder> listThreatIntelSetsRequest) {
        return listThreatIntelSetsPaginator(ListThreatIntelSetsRequest.builder().applyMutation(listThreatIntelSetsRequest)
                .build());
    }

    /**
     * <p>
     * Initiates the malware scan. Invoking this API will automatically create the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html">Service-linked
     * role </a> in the corresponding account.
     * </p>
     *
     * @param startMalwareScanRequest
     * @return A Java Future containing the result of the StartMalwareScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>ConflictException A request conflict exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StartMalwareScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartMalwareScanResponse> startMalwareScan(StartMalwareScanRequest startMalwareScanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the malware scan. Invoking this API will automatically create the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html">Service-linked
     * role </a> in the corresponding account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMalwareScanRequest.Builder} avoiding the need
     * to create one manually via {@link StartMalwareScanRequest#builder()}
     * </p>
     *
     * @param startMalwareScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.StartMalwareScanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartMalwareScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>ConflictException A request conflict exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StartMalwareScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartMalwareScanResponse> startMalwareScan(
            Consumer<StartMalwareScanRequest.Builder> startMalwareScanRequest) {
        return startMalwareScan(StartMalwareScanRequest.builder().applyMutation(startMalwareScanRequest).build());
    }

    /**
     * <p>
     * Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of
     * accounts that you stopped monitoring with the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_StopMonitoringMembers.html"
     * >StopMonitoringMembers</a> operation.
     * </p>
     *
     * @param startMonitoringMembersRequest
     * @return A Java Future containing the result of the StartMonitoringMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StartMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMonitoringMembersResponse> startMonitoringMembers(
            StartMonitoringMembersRequest startMonitoringMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of
     * accounts that you stopped monitoring with the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_StopMonitoringMembers.html"
     * >StopMonitoringMembers</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMonitoringMembersRequest.Builder} avoiding the
     * need to create one manually via {@link StartMonitoringMembersRequest#builder()}
     * </p>
     *
     * @param startMonitoringMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartMonitoringMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StartMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMonitoringMembersResponse> startMonitoringMembers(
            Consumer<StartMonitoringMembersRequest.Builder> startMonitoringMembersRequest) {
        return startMonitoringMembers(StartMonitoringMembersRequest.builder().applyMutation(startMonitoringMembersRequest)
                .build());
    }

    /**
     * <p>
     * Stops GuardDuty monitoring for the specified member accounts. Use the <code>StartMonitoringMembers</code>
     * operation to restart monitoring for those accounts.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to stop monitoring the member accounts in your organization.
     * </p>
     *
     * @param stopMonitoringMembersRequest
     * @return A Java Future containing the result of the StopMonitoringMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StopMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopMonitoringMembersResponse> stopMonitoringMembers(
            StopMonitoringMembersRequest stopMonitoringMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops GuardDuty monitoring for the specified member accounts. Use the <code>StartMonitoringMembers</code>
     * operation to restart monitoring for those accounts.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to stop monitoring the member accounts in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopMonitoringMembersRequest.Builder} avoiding the
     * need to create one manually via {@link StopMonitoringMembersRequest#builder()}
     * </p>
     *
     * @param stopMonitoringMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopMonitoringMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StopMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopMonitoringMembersResponse> stopMonitoringMembers(
            Consumer<StopMonitoringMembersRequest.Builder> stopMonitoringMembersRequest) {
        return stopMonitoringMembers(StopMonitoringMembersRequest.builder().applyMutation(stopMonitoringMembersRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Unarchives GuardDuty findings specified by the <code>findingIds</code>.
     * </p>
     *
     * @param unarchiveFindingsRequest
     * @return A Java Future containing the result of the UnarchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UnarchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UnarchiveFindingsResponse> unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unarchives GuardDuty findings specified by the <code>findingIds</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnarchiveFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link UnarchiveFindingsRequest#builder()}
     * </p>
     *
     * @param unarchiveFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UnarchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UnarchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UnarchiveFindingsResponse> unarchiveFindings(
            Consumer<UnarchiveFindingsRequest.Builder> unarchiveFindingsRequest) {
        return unarchiveFindings(UnarchiveFindingsRequest.builder().applyMutation(unarchiveFindingsRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateDetectorRequest
     * @return A Java Future containing the result of the UpdateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDetectorResponse> updateDetector(UpdateDetectorRequest updateDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDetectorRequest#builder()}
     * </p>
     *
     * @param updateDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDetectorResponse> updateDetector(Consumer<UpdateDetectorRequest.Builder> updateDetectorRequest) {
        return updateDetector(UpdateDetectorRequest.builder().applyMutation(updateDetectorRequest).build());
    }

    /**
     * <p>
     * Updates the filter specified by the filter name.
     * </p>
     *
     * @param updateFilterRequest
     * @return A Java Future containing the result of the UpdateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFilterResponse> updateFilter(UpdateFilterRequest updateFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the filter specified by the filter name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFilterRequest#builder()}
     * </p>
     *
     * @param updateFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFilterResponse> updateFilter(Consumer<UpdateFilterRequest.Builder> updateFilterRequest) {
        return updateFilter(UpdateFilterRequest.builder().applyMutation(updateFilterRequest).build());
    }

    /**
     * <p>
     * Marks the specified GuardDuty findings as useful or not useful.
     * </p>
     *
     * @param updateFindingsFeedbackRequest
     * @return A Java Future containing the result of the UpdateFindingsFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateFindingsFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsFeedbackResponse> updateFindingsFeedback(
            UpdateFindingsFeedbackRequest updateFindingsFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Marks the specified GuardDuty findings as useful or not useful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsFeedbackRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFindingsFeedbackRequest#builder()}
     * </p>
     *
     * @param updateFindingsFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFindingsFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateFindingsFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsFeedbackResponse> updateFindingsFeedback(
            Consumer<UpdateFindingsFeedbackRequest.Builder> updateFindingsFeedbackRequest) {
        return updateFindingsFeedback(UpdateFindingsFeedbackRequest.builder().applyMutation(updateFindingsFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Updates the IPSet specified by the IPSet ID.
     * </p>
     *
     * @param updateIpSetRequest
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIpSetResponse> updateIPSet(UpdateIpSetRequest updateIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the IPSet specified by the IPSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIpSetRequest#builder()}
     * </p>
     *
     * @param updateIpSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIpSetResponse> updateIPSet(Consumer<UpdateIpSetRequest.Builder> updateIpSetRequest) {
        return updateIPSet(UpdateIpSetRequest.builder().applyMutation(updateIpSetRequest).build());
    }

    /**
     * <p>
     * Updates the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateMalwareScanSettingsRequest
     * @return A Java Future containing the result of the UpdateMalwareScanSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMalwareScanSettingsResponse> updateMalwareScanSettings(
            UpdateMalwareScanSettingsRequest updateMalwareScanSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMalwareScanSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMalwareScanSettingsRequest#builder()}
     * </p>
     *
     * @param updateMalwareScanSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateMalwareScanSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMalwareScanSettingsResponse> updateMalwareScanSettings(
            Consumer<UpdateMalwareScanSettingsRequest.Builder> updateMalwareScanSettingsRequest) {
        return updateMalwareScanSettings(UpdateMalwareScanSettingsRequest.builder()
                .applyMutation(updateMalwareScanSettingsRequest).build());
    }

    /**
     * <p>
     * Contains information on member accounts to be updated.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateMemberDetectorsRequest
     * @return A Java Future containing the result of the UpdateMemberDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMemberDetectorsResponse> updateMemberDetectors(
            UpdateMemberDetectorsRequest updateMemberDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Contains information on member accounts to be updated.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemberDetectorsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMemberDetectorsRequest#builder()}
     * </p>
     *
     * @param updateMemberDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMemberDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMemberDetectorsResponse> updateMemberDetectors(
            Consumer<UpdateMemberDetectorsRequest.Builder> updateMemberDetectorsRequest) {
        return updateMemberDetectors(UpdateMemberDetectorsRequest.builder().applyMutation(updateMemberDetectorsRequest).build());
    }

    /**
     * <p>
     * Configures the delegated administrator account with the provided values. You must provide a value for either
     * <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>, but not both.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the delegated administrator account with the provided values. You must provide a value for either
     * <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>, but not both.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest) {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates information about the publishing destination specified by the <code>destinationId</code>.
     * </p>
     *
     * @param updatePublishingDestinationRequest
     * @return A Java Future containing the result of the UpdatePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePublishingDestinationResponse> updatePublishingDestination(
            UpdatePublishingDestinationRequest updatePublishingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the publishing destination specified by the <code>destinationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePublishingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePublishingDestinationRequest#builder()}
     * </p>
     *
     * @param updatePublishingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdatePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePublishingDestinationResponse> updatePublishingDestination(
            Consumer<UpdatePublishingDestinationRequest.Builder> updatePublishingDestinationRequest) {
        return updatePublishingDestination(UpdatePublishingDestinationRequest.builder()
                .applyMutation(updatePublishingDestinationRequest).build());
    }

    /**
     * <p>
     * Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param updateThreatIntelSetRequest
     * @return A Java Future containing the result of the UpdateThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateThreatIntelSetResponse> updateThreatIntelSet(
            UpdateThreatIntelSetRequest updateThreatIntelSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThreatIntelSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateThreatIntelSetRequest#builder()}
     * </p>
     *
     * @param updateThreatIntelSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateThreatIntelSetResponse> updateThreatIntelSet(
            Consumer<UpdateThreatIntelSetRequest.Builder> updateThreatIntelSetRequest) {
        return updateThreatIntelSet(UpdateThreatIntelSetRequest.builder().applyMutation(updateThreatIntelSetRequest).build());
    }

    @Override
    default GuardDutyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GuardDutyAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GuardDutyAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GuardDutyAsyncClient}.
     */
    static GuardDutyAsyncClientBuilder builder() {
        return new DefaultGuardDutyAsyncClientBuilder();
    }
}
