/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse;

public class GetUsageStatisticsIterable
implements SdkIterable<GetUsageStatisticsResponse> {
    private final GuardDutyClient client;
    private final GetUsageStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUsageStatisticsIterable(GuardDutyClient client, GetUsageStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetUsageStatisticsResponseFetcher();
    }

    public Iterator<GetUsageStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetUsageStatisticsResponseFetcher
    implements SyncPageFetcher<GetUsageStatisticsResponse> {
        private GetUsageStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(GetUsageStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetUsageStatisticsResponse nextPage(GetUsageStatisticsResponse previousPage) {
            if (previousPage == null) {
                return GetUsageStatisticsIterable.this.client.getUsageStatistics(GetUsageStatisticsIterable.this.firstRequest);
            }
            return GetUsageStatisticsIterable.this.client.getUsageStatistics((GetUsageStatisticsRequest)((Object)GetUsageStatisticsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

