/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.guardduty.internal.GuardDutyServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.AccessDeniedException;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.BadRequestException;
import software.amazon.awssdk.services.guardduty.model.ConflictException;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.CreateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.CreateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.CreateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.CreateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetCoverageStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.GetFilterRequest;
import software.amazon.awssdk.services.guardduty.model.GetFilterResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.guardduty.model.GetIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.GetMembersRequest;
import software.amazon.awssdk.services.guardduty.model.GetMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetOrganizationStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetOrganizationStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest;
import software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GuardDutyException;
import software.amazon.awssdk.services.guardduty.model.InternalServerErrorException;
import software.amazon.awssdk.services.guardduty.model.InviteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.InviteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListCoverageRequest;
import software.amazon.awssdk.services.guardduty.model.ListCoverageResponse;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanRequest;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanResponse;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.TagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.TagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.UntagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.UntagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.transform.AcceptAdministratorInvitationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ArchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreatePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeletePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DescribeMalwareScansRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DescribePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromAdministratorAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.EnableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetAdministratorAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetCoverageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMalwareScanSettingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMemberDetectorsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetOrganizationStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetRemainingFreeTrialDaysRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetUsageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.InviteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListCoverageRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListDetectorsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListOrganizationAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListPublishingDestinationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListThreatIntelSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMalwareScanRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StopMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UnarchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFindingsFeedbackRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateMalwareScanSettingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateMemberDetectorsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdatePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link GuardDutyAsyncClient}.
 *
 * @see GuardDutyAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGuardDutyAsyncClient implements GuardDutyAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGuardDutyAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGuardDutyAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent
     * the invitation.
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     * @return A Java Future containing the result of the AcceptAdministratorInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptAdministratorInvitationResponse> acceptAdministratorInvitation(
            AcceptAdministratorInvitationRequest acceptAdministratorInvitationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptAdministratorInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptAdministratorInvitationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptAdministratorInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptAdministratorInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptAdministratorInvitationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptAdministratorInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptAdministratorInvitationRequest, AcceptAdministratorInvitationResponse>()
                            .withOperationName("AcceptAdministratorInvitation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptAdministratorInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptAdministratorInvitationRequest));
            CompletableFuture<AcceptAdministratorInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts the invitation to be monitored by a GuardDuty administrator account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptInvitationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptInvitationRequest, AcceptInvitationResponse>()
                            .withOperationName("AcceptInvitation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptInvitationRequest));
            CompletableFuture<AcceptInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Archives GuardDuty findings that are specified by the list of finding IDs.
     * </p>
     * <note>
     * <p>
     * Only the administrator account can archive findings. Member accounts don't have permission to archive findings
     * from their accounts.
     * </p>
     * </note>
     *
     * @param archiveFindingsRequest
     * @return A Java Future containing the result of the ArchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ArchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ArchiveFindingsResponse> archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(archiveFindingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, archiveFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ArchiveFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ArchiveFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ArchiveFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ArchiveFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ArchiveFindingsRequest, ArchiveFindingsResponse>()
                            .withOperationName("ArchiveFindings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ArchiveFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(archiveFindingsRequest));
            CompletableFuture<ArchiveFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a single GuardDuty detector. A detector is a resource that represents the GuardDuty service. To start
     * using GuardDuty, you must create a detector in each Region where you enable the service. You can have only one
     * detector per account per Region. All data sources are enabled in a new detector by default.
     * </p>
     * <ul>
     * <li>
     * <p>
     * When you don't specify any <code>features</code>, with an exception to <code>RUNTIME_MONITORING</code>, all the
     * optional features are enabled by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you specify some of the <code>features</code>, any feature that is not specified in the API call gets
     * enabled by default, with an exception to <code>RUNTIME_MONITORING</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (
     * <code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime
     * Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param createDetectorRequest
     * @return A Java Future containing the result of the CreateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDetectorResponse> createDetector(CreateDetectorRequest createDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDetectorRequest, CreateDetectorResponse>()
                            .withOperationName("CreateDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDetectorRequest));
            CompletableFuture<CreateDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web
     * Services account per Region is 100. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html">Quotas for GuardDuty</a>.
     * </p>
     *
     * @param createFilterRequest
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFilterResponse> createFilter(CreateFilterRequest createFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFilterRequest, CreateFilterResponse>()
                            .withOperationName("CreateFilter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFilterRequest));
            CompletableFuture<CreateFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP
     * addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications.
     * GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the
     * administrator account can use this operation.
     * </p>
     *
     * @param createIpSetRequest
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIpSetResponse> createIPSet(CreateIpSetRequest createIpSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateIpSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIpSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIpSetRequest, CreateIpSetResponse>()
                            .withOperationName("CreateIPSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIpSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIpSetRequest));
            CompletableFuture<CreateIpSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services
     * account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or
     * through an organization.
     * </p>
     * <p>
     * As a delegated administrator, using <code>CreateMembers</code> will enable GuardDuty in the added member
     * accounts, with the exception of the organization delegated administrator account. A delegated administrator must
     * enable GuardDuty prior to being added as a member.
     * </p>
     * <p>
     * When you use CreateMembers as an Organizations delegated administrator, GuardDuty applies your organization's
     * auto-enable settings to the member accounts in this request, irrespective of the accounts being new or existing
     * members. For more information about the existing auto-enable settings for your organization, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DescribeOrganizationConfiguration.html"
     * >DescribeOrganizationConfiguration</a>.
     * </p>
     * <p>
     * If you disassociate a member account that was added by invitation, the member account details obtained from this
     * API, including the associated email addresses, will be retained. This is done so that the delegated administrator
     * can invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * When the member accounts added through Organizations are later disassociated, you (administrator) can't invite
     * them by calling the InviteMembers API. You can create an association with these member accounts again only by
     * calling the CreateMembers API.
     * </p>
     *
     * @param createMembersRequest
     * @return A Java Future containing the result of the CreateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMembersResponse> createMembers(CreateMembersRequest createMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMembersRequest, CreateMembersResponse>()
                            .withOperationName("CreateMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMembersRequest));
            CompletableFuture<CreateMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a publishing destination to export findings to. The resource to export findings to must exist before you
     * use this operation.
     * </p>
     *
     * @param createPublishingDestinationRequest
     * @return A Java Future containing the result of the CreatePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePublishingDestinationResponse> createPublishingDestination(
            CreatePublishingDestinationRequest createPublishingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPublishingDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublishingDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublishingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePublishingDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePublishingDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePublishingDestinationRequest, CreatePublishingDestinationResponse>()
                            .withOperationName("CreatePublishingDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePublishingDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPublishingDestinationRequest));
            CompletableFuture<CreatePublishingDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates sample findings of types specified by the list of finding types. If 'NULL' is specified for
     * <code>findingTypes</code>, the API generates sample findings of all supported finding types.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            CreateSampleFindingsRequest createSampleFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSampleFindingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSampleFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSampleFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSampleFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSampleFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSampleFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSampleFindingsRequest, CreateSampleFindingsResponse>()
                            .withOperationName("CreateSampleFindings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSampleFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSampleFindingsRequest));
            CompletableFuture<CreateSampleFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates
     * findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
     * </p>
     *
     * @param createThreatIntelSetRequest
     * @return A Java Future containing the result of the CreateThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.CreateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateThreatIntelSetResponse> createThreatIntelSet(
            CreateThreatIntelSetRequest createThreatIntelSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThreatIntelSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThreatIntelSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThreatIntelSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateThreatIntelSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThreatIntelSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThreatIntelSetRequest, CreateThreatIntelSetResponse>()
                            .withOperationName("CreateThreatIntelSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateThreatIntelSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createThreatIntelSetRequest));
            CompletableFuture<CreateThreatIntelSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Declines invitations sent to the current member account by Amazon Web Services accounts specified by their
     * account IDs.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(declineInvitationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, declineInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeclineInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeclineInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeclineInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeclineInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeclineInvitationsRequest, DeclineInvitationsResponse>()
                            .withOperationName("DeclineInvitations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeclineInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(declineInvitationsRequest));
            CompletableFuture<DeclineInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon GuardDuty detector that is specified by the detector ID.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return A Java Future containing the result of the DeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDetectorResponse> deleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDetectorRequest, DeleteDetectorResponse>()
                            .withOperationName("DeleteDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDetectorRequest));
            CompletableFuture<DeleteDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the filter specified by the filter name.
     * </p>
     *
     * @param deleteFilterRequest
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFilterResponse> deleteFilter(DeleteFilterRequest deleteFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFilterRequest, DeleteFilterResponse>()
                            .withOperationName("DeleteFilter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFilterRequest));
            CompletableFuture<DeleteFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP lists in the console user
     * interface.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIpSetResponse> deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteIpSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIpSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIpSetRequest, DeleteIpSetResponse>()
                            .withOperationName("DeleteIPSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIpSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIpSetRequest));
            CompletableFuture<DeleteIpSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account
     * IDs.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInvitationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInvitationsRequest, DeleteInvitationsResponse>()
                            .withOperationName("DeleteInvitations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInvitationsRequest));
            CompletableFuture<DeleteInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty for a member account in your organization.
     * </p>
     *
     * @param deleteMembersRequest
     * @return A Java Future containing the result of the DeleteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMembersResponse> deleteMembers(DeleteMembersRequest deleteMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMembersRequest, DeleteMembersResponse>()
                            .withOperationName("DeleteMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMembersRequest));
            CompletableFuture<DeleteMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the publishing definition with the specified <code>destinationId</code>.
     * </p>
     *
     * @param deletePublishingDestinationRequest
     * @return A Java Future containing the result of the DeletePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeletePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePublishingDestinationResponse> deletePublishingDestination(
            DeletePublishingDestinationRequest deletePublishingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePublishingDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePublishingDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublishingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePublishingDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePublishingDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePublishingDestinationRequest, DeletePublishingDestinationResponse>()
                            .withOperationName("DeletePublishingDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePublishingDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePublishingDestinationRequest));
            CompletableFuture<DeletePublishingDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param deleteThreatIntelSetRequest
     * @return A Java Future containing the result of the DeleteThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DeleteThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteThreatIntelSetResponse> deleteThreatIntelSet(
            DeleteThreatIntelSetRequest deleteThreatIntelSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThreatIntelSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThreatIntelSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThreatIntelSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteThreatIntelSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThreatIntelSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThreatIntelSetRequest, DeleteThreatIntelSetResponse>()
                            .withOperationName("DeleteThreatIntelSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteThreatIntelSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteThreatIntelSetRequest));
            CompletableFuture<DeleteThreatIntelSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An
     * administrator can view the malware scans for all the member accounts.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param describeMalwareScansRequest
     * @return A Java Future containing the result of the DescribeMalwareScans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeMalwareScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeMalwareScans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMalwareScansResponse> describeMalwareScans(
            DescribeMalwareScansRequest describeMalwareScansRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMalwareScansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMalwareScansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMalwareScans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMalwareScansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMalwareScansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMalwareScansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMalwareScansRequest, DescribeMalwareScansResponse>()
                            .withOperationName("DescribeMalwareScans").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMalwareScansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMalwareScansRequest));
            CompletableFuture<DescribeMalwareScansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the account selected as the delegated administrator for GuardDuty.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse>()
                            .withOperationName("DescribeOrganizationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationConfigurationRequest));
            CompletableFuture<DescribeOrganizationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the publishing destination specified by the provided <code>destinationId</code>.
     * </p>
     *
     * @param describePublishingDestinationRequest
     * @return A Java Future containing the result of the DescribePublishingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DescribePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePublishingDestinationResponse> describePublishingDestination(
            DescribePublishingDestinationRequest describePublishingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePublishingDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePublishingDestinationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePublishingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePublishingDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePublishingDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePublishingDestinationRequest, DescribePublishingDestinationResponse>()
                            .withOperationName("DescribePublishingDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePublishingDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePublishingDestinationRequest));
            CompletableFuture<DescribePublishingDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the existing GuardDuty delegated administrator of the organization. Only the organization's management
     * account can run this API operation.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableOrganizationAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResponse>()
                            .withOperationName("DisableOrganizationAdminAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableOrganizationAdminAccountRequest));
            CompletableFuture<DisableOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disable GuardDuty in a member account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateFromAdministratorAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateFromAdministratorAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFromAdministratorAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFromAdministratorAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateFromAdministratorAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFromAdministratorAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFromAdministratorAccountRequest, DisassociateFromAdministratorAccountResponse>()
                            .withOperationName("DisassociateFromAdministratorAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateFromAdministratorAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateFromAdministratorAccountRequest));
            CompletableFuture<DisassociateFromAdministratorAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its administrator account.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateFromMasterAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateFromMasterAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFromMasterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFromMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateFromMasterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFromMasterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse>()
                            .withOperationName("DisassociateFromMasterAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateFromMasterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateFromMasterAccountRequest));
            CompletableFuture<DisassociateFromMasterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates GuardDuty member accounts (from the current administrator account) specified by the account IDs.
     * </p>
     * <p>
     * When you disassociate an invited member from a GuardDuty delegated administrator, the member account details
     * obtained from the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> API,
     * including the associated email addresses, are retained. This is done so that the delegated administrator can
     * invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to disassociate a member account before removing them from your
     * organization.
     * </p>
     * <p>
     * If you disassociate a member account that was added by invitation, the member account details obtained from this
     * API, including the associated email addresses, will be retained. This is done so that the delegated administrator
     * can invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * When the member accounts added through Organizations are later disassociated, you (administrator) can't invite
     * them by calling the InviteMembers API. You can create an association with these member accounts again only by
     * calling the CreateMembers API.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return A Java Future containing the result of the DisassociateMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMembersResponse> disassociateMembers(
            DisassociateMembersRequest disassociateMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMembersRequest, DisassociateMembersResponse>()
                            .withOperationName("DisassociateMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateMembersRequest));
            CompletableFuture<DisassociateMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Designates an Amazon Web Services account within the organization as your GuardDuty delegated administrator. Only
     * the organization's management account can run this API operation.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableOrganizationAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResponse>()
                            .withOperationName("EnableOrganizationAdminAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableOrganizationAdminAccountRequest));
            CompletableFuture<EnableOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the details of the GuardDuty administrator account associated with the current GuardDuty member account.
     * </p>
     * <note>
     * <p>
     * If the organization's management account or a delegated administrator runs this API, it will return success (
     * <code>HTTP 200</code>) but no content.
     * </p>
     * </note>
     *
     * @param getAdministratorAccountRequest
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            GetAdministratorAccountRequest getAdministratorAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAdministratorAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAdministratorAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAdministratorAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAdministratorAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAdministratorAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAdministratorAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAdministratorAccountRequest, GetAdministratorAccountResponse>()
                            .withOperationName("GetAdministratorAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAdministratorAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAdministratorAccountRequest));
            CompletableFuture<GetAdministratorAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the
     * statistics for all the resources associated with the active member accounts in your organization who have enabled
     * Runtime Monitoring and have the GuardDuty security agent running on their resources.
     * </p>
     *
     * @param getCoverageStatisticsRequest
     * @return A Java Future containing the result of the GetCoverageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCoverageStatisticsResponse> getCoverageStatistics(
            GetCoverageStatisticsRequest getCoverageStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCoverageStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCoverageStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCoverageStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCoverageStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCoverageStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCoverageStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCoverageStatisticsRequest, GetCoverageStatisticsResponse>()
                            .withOperationName("GetCoverageStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCoverageStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCoverageStatisticsRequest));
            CompletableFuture<GetCoverageStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an Amazon GuardDuty detector specified by the detectorId.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getDetectorRequest
     * @return A Java Future containing the result of the GetDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDetectorResponse> getDetector(GetDetectorRequest getDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDetectorRequest, GetDetectorResponse>()
                            .withOperationName("GetDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDetectorRequest));
            CompletableFuture<GetDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of the filter specified by the filter name.
     * </p>
     *
     * @param getFilterRequest
     * @return A Java Future containing the result of the GetFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFilterResponse> getFilter(GetFilterRequest getFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFilterRequest, GetFilterResponse>().withOperationName("GetFilter")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFilterRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFilterRequest));
            CompletableFuture<GetFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes Amazon GuardDuty findings specified by finding IDs.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsRequest, GetFindingsResponse>()
                            .withOperationName("GetFindings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFindingsRequest));
            CompletableFuture<GetFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings statistics for the specified detector ID.
     * </p>
     * <p>
     * There might be regional differences because some flags might not be available in all the Regions where GuardDuty
     * is currently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getFindingsStatisticsRequest
     * @return A Java Future containing the result of the GetFindingsStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetFindingsStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsStatisticsResponse> getFindingsStatistics(
            GetFindingsStatisticsRequest getFindingsStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFindingsStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFindingsStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindingsStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFindingsStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsStatisticsRequest, GetFindingsStatisticsResponse>()
                            .withOperationName("GetFindingsStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFindingsStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFindingsStatisticsRequest));
            CompletableFuture<GetFindingsStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the IPSet specified by the <code>ipSetId</code>.
     * </p>
     *
     * @param getIpSetRequest
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetIpSetResponse> getIPSet(GetIpSetRequest getIpSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetIpSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIpSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIpSetRequest, GetIpSetResponse>().withOperationName("GetIPSet")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIpSetRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getIpSetRequest));
            CompletableFuture<GetIpSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInvitationsCountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInvitationsCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInvitationsCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInvitationsCountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInvitationsCountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInvitationsCountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInvitationsCountRequest, GetInvitationsCountResponse>()
                            .withOperationName("GetInvitationsCount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInvitationsCountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInvitationsCountRequest));
            CompletableFuture<GetInvitationsCountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getMalwareScanSettingsRequest
     * @return A Java Future containing the result of the GetMalwareScanSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMalwareScanSettingsResponse> getMalwareScanSettings(
            GetMalwareScanSettingsRequest getMalwareScanSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMalwareScanSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMalwareScanSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMalwareScanSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMalwareScanSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMalwareScanSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMalwareScanSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMalwareScanSettingsRequest, GetMalwareScanSettingsResponse>()
                            .withOperationName("GetMalwareScanSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMalwareScanSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMalwareScanSettingsRequest));
            CompletableFuture<GetMalwareScanSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the details for the GuardDuty administrator account associated with the current GuardDuty member
     * account.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMasterAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMasterAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMasterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMasterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMasterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMasterAccountRequest, GetMasterAccountResponse>()
                            .withOperationName("GetMasterAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMasterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMasterAccountRequest));
            CompletableFuture<GetMasterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes which data sources are enabled for the member account's detector.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param getMemberDetectorsRequest
     * @return A Java Future containing the result of the GetMemberDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMemberDetectorsResponse> getMemberDetectors(GetMemberDetectorsRequest getMemberDetectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMemberDetectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMemberDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMemberDetectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMemberDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMemberDetectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMemberDetectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMemberDetectorsRequest, GetMemberDetectorsResponse>()
                            .withOperationName("GetMemberDetectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMemberDetectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMemberDetectorsRequest));
            CompletableFuture<GetMemberDetectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account
     * IDs.
     * </p>
     *
     * @param getMembersRequest
     * @return A Java Future containing the result of the GetMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMembersResponse> getMembers(GetMembersRequest getMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMembersRequest, GetMembersResponse>().withOperationName("GetMembers")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMembersRequest));
            CompletableFuture<GetMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves how many active member accounts have each feature enabled within GuardDuty. Only a delegated GuardDuty
     * administrator of an organization can run this API.
     * </p>
     * <p>
     * When you create a new organization, it might take up to 24 hours to generate the statistics for the entire
     * organization.
     * </p>
     *
     * @param getOrganizationStatisticsRequest
     * @return A Java Future containing the result of the GetOrganizationStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetOrganizationStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetOrganizationStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOrganizationStatisticsResponse> getOrganizationStatistics(
            GetOrganizationStatisticsRequest getOrganizationStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOrganizationStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOrganizationStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOrganizationStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOrganizationStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOrganizationStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationStatisticsRequest, GetOrganizationStatisticsResponse>()
                            .withOperationName("GetOrganizationStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOrganizationStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOrganizationStatisticsRequest));
            CompletableFuture<GetOrganizationStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the number of days left for each data source used in the free trial period.
     * </p>
     *
     * @param getRemainingFreeTrialDaysRequest
     * @return A Java Future containing the result of the GetRemainingFreeTrialDays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetRemainingFreeTrialDays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetRemainingFreeTrialDays"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRemainingFreeTrialDaysResponse> getRemainingFreeTrialDays(
            GetRemainingFreeTrialDaysRequest getRemainingFreeTrialDaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRemainingFreeTrialDaysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRemainingFreeTrialDaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRemainingFreeTrialDays");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRemainingFreeTrialDaysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRemainingFreeTrialDaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRemainingFreeTrialDaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRemainingFreeTrialDaysRequest, GetRemainingFreeTrialDaysResponse>()
                            .withOperationName("GetRemainingFreeTrialDays").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRemainingFreeTrialDaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRemainingFreeTrialDaysRequest));
            CompletableFuture<GetRemainingFreeTrialDaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param getThreatIntelSetRequest
     * @return A Java Future containing the result of the GetThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetThreatIntelSetResponse> getThreatIntelSet(GetThreatIntelSetRequest getThreatIntelSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getThreatIntelSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getThreatIntelSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetThreatIntelSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetThreatIntelSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetThreatIntelSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetThreatIntelSetRequest, GetThreatIntelSetResponse>()
                            .withOperationName("GetThreatIntelSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetThreatIntelSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getThreatIntelSetRequest));
            CompletableFuture<GetThreatIntelSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled
     * detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ
     * from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How
     * Usage Costs are Calculated</a>.
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsageStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsageStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsageStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageStatisticsRequest, GetUsageStatisticsResponse>()
                            .withOperationName("GetUsageStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsageStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsageStatisticsRequest));
            CompletableFuture<GetUsageStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Invites Amazon Web Services accounts to become members of an organization administered by the Amazon Web Services
     * account that invokes this API. If you are using Amazon Web Services Organizations to manage your GuardDuty
     * environment, this step is not needed. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html">Managing accounts with
     * organizations</a>.
     * </p>
     * <p>
     * To invite Amazon Web Services accounts, the first step is to ensure that GuardDuty has been enabled in the
     * potential member accounts. You can now invoke this API to add accounts by invitation. The invited accounts can
     * either accept or decline the invitation from their GuardDuty accounts. Each invited Amazon Web Services account
     * can choose to accept the invitation from only one Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_invitations.html">Managing GuardDuty accounts by
     * invitation</a>.
     * </p>
     * <p>
     * After the invite has been accepted and you choose to disassociate a member account (by using <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DisassociateMembers.html"
     * >DisassociateMembers</a>) from your account, the details of the member account obtained by invoking <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a>,
     * including the associated email addresses, will be retained. This is done so that you can invoke InviteMembers
     * without the need to invoke <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html">CreateMembers</a> again.
     * To remove the details associated with a member account, you must also invoke <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a>.
     * </p>
     * <p>
     * If you disassociate a member account that was added by invitation, the member account details obtained from this
     * API, including the associated email addresses, will be retained. This is done so that the delegated administrator
     * can invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">InviteMembers</a> API
     * without the need to invoke the CreateMembers API again. To remove the details associated with a member account,
     * the delegated administrator must invoke the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DeleteMembers.html">DeleteMembers</a> API.
     * </p>
     * <p>
     * When the member accounts added through Organizations are later disassociated, you (administrator) can't invite
     * them by calling the InviteMembers API. You can create an association with these member accounts again only by
     * calling the CreateMembers API.
     * </p>
     *
     * @param inviteMembersRequest
     * @return A Java Future containing the result of the InviteMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<InviteMembersResponse> inviteMembers(InviteMembersRequest inviteMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(inviteMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, inviteMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InviteMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<InviteMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    InviteMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<InviteMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<InviteMembersRequest, InviteMembersResponse>()
                            .withOperationName("InviteMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new InviteMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(inviteMembersRequest));
            CompletableFuture<InviteMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all
     * resources associated with the active member accounts in your organization.
     * </p>
     * <p>
     * Make sure the accounts have Runtime Monitoring enabled and GuardDuty agent running on their resources.
     * </p>
     *
     * @param listCoverageRequest
     * @return A Java Future containing the result of the ListCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoverageResponse> listCoverage(ListCoverageRequest listCoverageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCoverageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCoverageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCoverage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoverageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCoverageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCoverageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCoverageRequest, ListCoverageResponse>()
                            .withOperationName("ListCoverage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCoverageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCoverageRequest));
            CompletableFuture<ListCoverageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     *
     * @param listDetectorsRequest
     * @return A Java Future containing the result of the ListDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDetectorsResponse> listDetectors(ListDetectorsRequest listDetectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDetectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDetectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDetectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDetectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDetectorsRequest, ListDetectorsResponse>()
                            .withOperationName("ListDetectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDetectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDetectorsRequest));
            CompletableFuture<ListDetectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     *
     * @param listFiltersRequest
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFiltersResponse> listFilters(ListFiltersRequest listFiltersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFiltersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFiltersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFilters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFiltersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFiltersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFiltersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFiltersRequest, ListFiltersResponse>()
                            .withOperationName("ListFilters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFiltersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFiltersRequest));
            CompletableFuture<ListFiltersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists GuardDuty findings for the specified detector ID.
     * </p>
     * <p>
     * There might be regional differences because some flags might not be available in all the Regions where GuardDuty
     * is currently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingsRequest, ListFindingsResponse>()
                            .withOperationName("ListFindings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFindingsRequest));
            CompletableFuture<ListFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated administrator account.
     * </p>
     *
     * @param listIpSetsRequest
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIpSetsResponse> listIPSets(ListIpSetsRequest listIpSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIpSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIpSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIPSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIpSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIpSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIpSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIpSetsRequest, ListIpSetsResponse>().withOperationName("ListIPSets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIpSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIpSetsRequest));
            CompletableFuture<ListIpSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInvitationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInvitationsRequest, ListInvitationsResponse>()
                            .withOperationName("ListInvitations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInvitationsRequest));
            CompletableFuture<ListInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty administrator account.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembersRequest, ListMembersResponse>()
                            .withOperationName("ListMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMembersRequest));
            CompletableFuture<ListMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the accounts designated as GuardDuty delegated administrators. Only the organization's management account
     * can run this API operation.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOrganizationAdminAccountsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOrganizationAdminAccountsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizationAdminAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationAdminAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationAdminAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOrganizationAdminAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResponse>()
                            .withOperationName("ListOrganizationAdminAccounts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOrganizationAdminAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOrganizationAdminAccountsRequest));
            CompletableFuture<ListOrganizationAdminAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>detectorId</code>.
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return A Java Future containing the result of the ListPublishingDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListPublishingDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPublishingDestinationsResponse> listPublishingDestinations(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPublishingDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPublishingDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPublishingDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPublishingDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPublishingDestinationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPublishingDestinationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPublishingDestinationsRequest, ListPublishingDestinationsResponse>()
                            .withOperationName("ListPublishingDestinations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPublishingDestinationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPublishingDestinationsRequest));
            CompletableFuture<ListPublishingDestinationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, threat intel
     * sets, and publishing destination, with a limit of 50 tags per resource. When invoked, this operation returns all
     * assigned tags for a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the administrator account are returned.
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return A Java Future containing the result of the ListThreatIntelSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.ListThreatIntelSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListThreatIntelSetsResponse> listThreatIntelSets(
            ListThreatIntelSetsRequest listThreatIntelSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThreatIntelSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThreatIntelSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThreatIntelSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThreatIntelSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThreatIntelSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThreatIntelSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThreatIntelSetsRequest, ListThreatIntelSetsResponse>()
                            .withOperationName("ListThreatIntelSets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListThreatIntelSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listThreatIntelSetsRequest));
            CompletableFuture<ListThreatIntelSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the malware scan. Invoking this API will automatically create the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html">Service-linked
     * role</a> in the corresponding account.
     * </p>
     * <p>
     * When the malware scan starts, you can use the associated scan ID to track the status of the scan. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DescribeMalwareScans.html"
     * >DescribeMalwareScans</a>.
     * </p>
     *
     * @param startMalwareScanRequest
     * @return A Java Future containing the result of the StartMalwareScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>ConflictException A request conflict exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StartMalwareScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScan" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMalwareScanResponse> startMalwareScan(StartMalwareScanRequest startMalwareScanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMalwareScanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMalwareScanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMalwareScan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMalwareScanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMalwareScanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMalwareScanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMalwareScanRequest, StartMalwareScanResponse>()
                            .withOperationName("StartMalwareScan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMalwareScanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMalwareScanRequest));
            CompletableFuture<StartMalwareScanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of
     * accounts that you stopped monitoring with the <a
     * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_StopMonitoringMembers.html"
     * >StopMonitoringMembers</a> operation.
     * </p>
     *
     * @param startMonitoringMembersRequest
     * @return A Java Future containing the result of the StartMonitoringMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StartMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMonitoringMembersResponse> startMonitoringMembers(
            StartMonitoringMembersRequest startMonitoringMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMonitoringMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMonitoringMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMonitoringMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMonitoringMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMonitoringMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMonitoringMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMonitoringMembersRequest, StartMonitoringMembersResponse>()
                            .withOperationName("StartMonitoringMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMonitoringMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMonitoringMembersRequest));
            CompletableFuture<StartMonitoringMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops GuardDuty monitoring for the specified member accounts. Use the <code>StartMonitoringMembers</code>
     * operation to restart monitoring for those accounts.
     * </p>
     * <p>
     * With <code>autoEnableOrganizationMembers</code> configuration for your organization set to <code>ALL</code>,
     * you'll receive an error if you attempt to stop monitoring the member accounts in your organization.
     * </p>
     *
     * @param stopMonitoringMembersRequest
     * @return A Java Future containing the result of the StopMonitoringMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.StopMonitoringMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopMonitoringMembersResponse> stopMonitoringMembers(
            StopMonitoringMembersRequest stopMonitoringMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopMonitoringMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopMonitoringMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopMonitoringMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopMonitoringMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopMonitoringMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopMonitoringMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopMonitoringMembersRequest, StopMonitoringMembersResponse>()
                            .withOperationName("StopMonitoringMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopMonitoringMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopMonitoringMembersRequest));
            CompletableFuture<StopMonitoringMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Unarchives GuardDuty findings specified by the <code>findingIds</code>.
     * </p>
     *
     * @param unarchiveFindingsRequest
     * @return A Java Future containing the result of the UnarchiveFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UnarchiveFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UnarchiveFindingsResponse> unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(unarchiveFindingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unarchiveFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnarchiveFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UnarchiveFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UnarchiveFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UnarchiveFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UnarchiveFindingsRequest, UnarchiveFindingsResponse>()
                            .withOperationName("UnarchiveFindings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UnarchiveFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(unarchiveFindingsRequest));
            CompletableFuture<UnarchiveFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>AccessDeniedException An access denied exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the GuardDuty detector specified by the detector ID.
     * </p>
     * <p>
     * Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (
     * <code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime
     * Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateDetectorRequest
     * @return A Java Future containing the result of the UpdateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDetectorResponse> updateDetector(UpdateDetectorRequest updateDetectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDetectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDetectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDetectorRequest, UpdateDetectorResponse>()
                            .withOperationName("UpdateDetector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDetectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDetectorRequest));
            CompletableFuture<UpdateDetectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the filter specified by the filter name.
     * </p>
     *
     * @param updateFilterRequest
     * @return A Java Future containing the result of the UpdateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFilterResponse> updateFilter(UpdateFilterRequest updateFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFilterRequest, UpdateFilterResponse>()
                            .withOperationName("UpdateFilter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFilterRequest));
            CompletableFuture<UpdateFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Marks the specified GuardDuty findings as useful or not useful.
     * </p>
     *
     * @param updateFindingsFeedbackRequest
     * @return A Java Future containing the result of the UpdateFindingsFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateFindingsFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFindingsFeedbackResponse> updateFindingsFeedback(
            UpdateFindingsFeedbackRequest updateFindingsFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFindingsFeedbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFindingsFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFindingsFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFindingsFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFindingsFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFindingsFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFindingsFeedbackRequest, UpdateFindingsFeedbackResponse>()
                            .withOperationName("UpdateFindingsFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFindingsFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFindingsFeedbackRequest));
            CompletableFuture<UpdateFindingsFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the IPSet specified by the IPSet ID.
     * </p>
     *
     * @param updateIpSetRequest
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIpSetResponse> updateIPSet(UpdateIpSetRequest updateIpSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIpSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateIpSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIpSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIpSetRequest, UpdateIpSetResponse>()
                            .withOperationName("UpdateIPSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIpSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIpSetRequest));
            CompletableFuture<UpdateIpSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the malware scan settings.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateMalwareScanSettingsRequest
     * @return A Java Future containing the result of the UpdateMalwareScanSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateMalwareScanSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMalwareScanSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMalwareScanSettingsResponse> updateMalwareScanSettings(
            UpdateMalwareScanSettingsRequest updateMalwareScanSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMalwareScanSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMalwareScanSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMalwareScanSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMalwareScanSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMalwareScanSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMalwareScanSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMalwareScanSettingsRequest, UpdateMalwareScanSettingsResponse>()
                            .withOperationName("UpdateMalwareScanSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMalwareScanSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMalwareScanSettingsRequest));
            CompletableFuture<UpdateMalwareScanSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Contains information on member accounts to be updated.
     * </p>
     * <p>
     * Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (
     * <code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime
     * Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateMemberDetectorsRequest
     * @return A Java Future containing the result of the UpdateMemberDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateMemberDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMemberDetectorsResponse> updateMemberDetectors(
            UpdateMemberDetectorsRequest updateMemberDetectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMemberDetectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMemberDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMemberDetectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMemberDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMemberDetectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMemberDetectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMemberDetectorsRequest, UpdateMemberDetectorsResponse>()
                            .withOperationName("UpdateMemberDetectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMemberDetectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMemberDetectorsRequest));
            CompletableFuture<UpdateMemberDetectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures the delegated administrator account with the provided values. You must provide a value for either
     * <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>, but not both.
     * </p>
     * <p>
     * Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (
     * <code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime
     * Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOrganizationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOrganizationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOrganizationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse>()
                            .withOperationName("UpdateOrganizationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOrganizationConfigurationRequest));
            CompletableFuture<UpdateOrganizationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about the publishing destination specified by the <code>destinationId</code>.
     * </p>
     *
     * @param updatePublishingDestinationRequest
     * @return A Java Future containing the result of the UpdatePublishingDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdatePublishingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePublishingDestinationResponse> updatePublishingDestination(
            UpdatePublishingDestinationRequest updatePublishingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePublishingDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePublishingDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePublishingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePublishingDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePublishingDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePublishingDestinationRequest, UpdatePublishingDestinationResponse>()
                            .withOperationName("UpdatePublishingDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePublishingDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePublishingDestinationRequest));
            CompletableFuture<UpdatePublishingDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param updateThreatIntelSetRequest
     * @return A Java Future containing the result of the UpdateThreatIntelSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException A bad request exception object.</li>
     *         <li>InternalServerErrorException An internal server error exception object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GuardDutyException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GuardDutyAsyncClient.UpdateThreatIntelSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateThreatIntelSetResponse> updateThreatIntelSet(
            UpdateThreatIntelSetRequest updateThreatIntelSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateThreatIntelSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThreatIntelSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "GuardDuty");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThreatIntelSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThreatIntelSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThreatIntelSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThreatIntelSetRequest, UpdateThreatIntelSetResponse>()
                            .withOperationName("UpdateThreatIntelSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateThreatIntelSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateThreatIntelSetRequest));
            CompletableFuture<UpdateThreatIntelSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final GuardDutyServiceClientConfiguration serviceClientConfiguration() {
        return new GuardDutyServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GuardDutyException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        GuardDutyServiceClientConfigurationBuilder serviceConfigBuilder = new GuardDutyServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
