/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon EC2 instance runtime coverage details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageEc2InstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageEc2InstanceDetails.Builder, CoverageEc2InstanceDetails> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CoverageEc2InstanceDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CoverageEc2InstanceDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(CoverageEc2InstanceDetails::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<AgentDetails> AGENT_DETAILS_FIELD = SdkField.<AgentDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AgentDetails").getter(getter(CoverageEc2InstanceDetails::agentDetails))
            .setter(setter(Builder::agentDetails)).constructor(AgentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDetails").build()).build();

    private static final SdkField<String> MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagementType").getter(getter(CoverageEc2InstanceDetails::managementTypeAsString))
            .setter(setter(Builder::managementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_TYPE_FIELD, CLUSTER_ARN_FIELD, AGENT_DETAILS_FIELD, MANAGEMENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String instanceType;

    private final String clusterArn;

    private final AgentDetails agentDetails;

    private final String managementType;

    private CoverageEc2InstanceDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.clusterArn = builder.clusterArn;
        this.agentDetails = builder.agentDetails;
        this.managementType = builder.managementType;
    }

    /**
     * <p>
     * The Amazon EC2 instance ID.
     * </p>
     * 
     * @return The Amazon EC2 instance ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type of the Amazon EC2 instance.
     * </p>
     * 
     * @return The instance type of the Amazon EC2 instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The cluster ARN of the Amazon ECS cluster running on the Amazon EC2 instance.
     * </p>
     * 
     * @return The cluster ARN of the Amazon ECS cluster running on the Amazon EC2 instance.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * Information about the installed security agent.
     * </p>
     * 
     * @return Information about the installed security agent.
     */
    public final AgentDetails agentDetails() {
        return agentDetails;
    }

    /**
     * <p>
     * Indicates how the GuardDuty security agent is managed for this resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty security agent
     * updates for this resource.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managementType}
     * will return {@link ManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managementTypeAsString}.
     * </p>
     * 
     * @return Indicates how the GuardDuty security agent is managed for this resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty
     *         security agent updates for this resource.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
     *         </p>
     * @see ManagementType
     */
    public final ManagementType managementType() {
        return ManagementType.fromValue(managementType);
    }

    /**
     * <p>
     * Indicates how the GuardDuty security agent is managed for this resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty security agent
     * updates for this resource.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managementType}
     * will return {@link ManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managementTypeAsString}.
     * </p>
     * 
     * @return Indicates how the GuardDuty security agent is managed for this resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty
     *         security agent updates for this resource.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
     *         </p>
     * @see ManagementType
     */
    public final String managementTypeAsString() {
        return managementType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(managementTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageEc2InstanceDetails)) {
            return false;
        }
        CoverageEc2InstanceDetails other = (CoverageEc2InstanceDetails) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(agentDetails(), other.agentDetails())
                && Objects.equals(managementTypeAsString(), other.managementTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageEc2InstanceDetails").add("InstanceId", instanceId()).add("InstanceType", instanceType())
                .add("ClusterArn", clusterArn()).add("AgentDetails", agentDetails())
                .add("ManagementType", managementTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "AgentDetails":
            return Optional.ofNullable(clazz.cast(agentDetails()));
        case "ManagementType":
            return Optional.ofNullable(clazz.cast(managementTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageEc2InstanceDetails, T> g) {
        return obj -> g.apply((CoverageEc2InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageEc2InstanceDetails> {
        /**
         * <p>
         * The Amazon EC2 instance ID.
         * </p>
         * 
         * @param instanceId
         *        The Amazon EC2 instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type of the Amazon EC2 instance.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The cluster ARN of the Amazon ECS cluster running on the Amazon EC2 instance.
         * </p>
         * 
         * @param clusterArn
         *        The cluster ARN of the Amazon ECS cluster running on the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Information about the installed security agent.
         * </p>
         * 
         * @param agentDetails
         *        Information about the installed security agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentDetails(AgentDetails agentDetails);

        /**
         * <p>
         * Information about the installed security agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentDetails.Builder} avoiding the need
         * to create one manually via {@link AgentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #agentDetails(AgentDetails)}.
         * 
         * @param agentDetails
         *        a consumer that will call methods on {@link AgentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentDetails(AgentDetails)
         */
        default Builder agentDetails(Consumer<AgentDetails.Builder> agentDetails) {
            return agentDetails(AgentDetails.builder().applyMutation(agentDetails).build());
        }

        /**
         * <p>
         * Indicates how the GuardDuty security agent is managed for this resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty security
         * agent updates for this resource.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
         * </p>
         * </note>
         * 
         * @param managementType
         *        Indicates how the GuardDuty security agent is managed for this resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty
         *        security agent updates for this resource.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
         *        </p>
         * @see ManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagementType
         */
        Builder managementType(String managementType);

        /**
         * <p>
         * Indicates how the GuardDuty security agent is managed for this resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty security
         * agent updates for this resource.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
         * </p>
         * </note>
         * 
         * @param managementType
         *        Indicates how the GuardDuty security agent is managed for this resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the GuardDuty
         *        security agent updates for this resource.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>DISABLED</code> status doesn't apply to Amazon EC2 instances and Amazon EKS clusters.
         *        </p>
         * @see ManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagementType
         */
        Builder managementType(ManagementType managementType);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String instanceType;

        private String clusterArn;

        private AgentDetails agentDetails;

        private String managementType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageEc2InstanceDetails model) {
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            clusterArn(model.clusterArn);
            agentDetails(model.agentDetails);
            managementType(model.managementType);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final AgentDetails.Builder getAgentDetails() {
            return agentDetails != null ? agentDetails.toBuilder() : null;
        }

        public final void setAgentDetails(AgentDetails.BuilderImpl agentDetails) {
            this.agentDetails = agentDetails != null ? agentDetails.build() : null;
        }

        @Override
        public final Builder agentDetails(AgentDetails agentDetails) {
            this.agentDetails = agentDetails;
            return this;
        }

        public final String getManagementType() {
            return managementType;
        }

        public final void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @Override
        public final Builder managementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        @Override
        public final Builder managementType(ManagementType managementType) {
            this.managementType(managementType == null ? null : managementType.toString());
            return this;
        }

        @Override
        public CoverageEc2InstanceDetails build() {
            return new CoverageEc2InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
