/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the coverage statistic for the additional configuration of the feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationFeatureStatisticsAdditionalConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<OrganizationFeatureStatisticsAdditionalConfiguration.Builder, OrganizationFeatureStatisticsAdditionalConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OrganizationFeatureStatisticsAdditionalConfiguration::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> ENABLED_ACCOUNTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EnabledAccountsCount")
            .getter(getter(OrganizationFeatureStatisticsAdditionalConfiguration::enabledAccountsCount))
            .setter(setter(Builder::enabledAccountsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledAccountsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ENABLED_ACCOUNTS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer enabledAccountsCount;

    private OrganizationFeatureStatisticsAdditionalConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.enabledAccountsCount = builder.enabledAccountsCount;
    }

    /**
     * <p>
     * Name of the additional configuration within a feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeatureAdditionalConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the additional configuration within a feature.
     * @see OrgFeatureAdditionalConfiguration
     */
    public final OrgFeatureAdditionalConfiguration name() {
        return OrgFeatureAdditionalConfiguration.fromValue(name);
    }

    /**
     * <p>
     * Name of the additional configuration within a feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeatureAdditionalConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the additional configuration within a feature.
     * @see OrgFeatureAdditionalConfiguration
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Total number of accounts that have enabled the additional configuration.
     * </p>
     * 
     * @return Total number of accounts that have enabled the additional configuration.
     */
    public final Integer enabledAccountsCount() {
        return enabledAccountsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledAccountsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureStatisticsAdditionalConfiguration)) {
            return false;
        }
        OrganizationFeatureStatisticsAdditionalConfiguration other = (OrganizationFeatureStatisticsAdditionalConfiguration) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(enabledAccountsCount(), other.enabledAccountsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationFeatureStatisticsAdditionalConfiguration").add("Name", nameAsString())
                .add("EnabledAccountsCount", enabledAccountsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "EnabledAccountsCount":
            return Optional.ofNullable(clazz.cast(enabledAccountsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationFeatureStatisticsAdditionalConfiguration, T> g) {
        return obj -> g.apply((OrganizationFeatureStatisticsAdditionalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationFeatureStatisticsAdditionalConfiguration> {
        /**
         * <p>
         * Name of the additional configuration within a feature.
         * </p>
         * 
         * @param name
         *        Name of the additional configuration within a feature.
         * @see OrgFeatureAdditionalConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureAdditionalConfiguration
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the additional configuration within a feature.
         * </p>
         * 
         * @param name
         *        Name of the additional configuration within a feature.
         * @see OrgFeatureAdditionalConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureAdditionalConfiguration
         */
        Builder name(OrgFeatureAdditionalConfiguration name);

        /**
         * <p>
         * Total number of accounts that have enabled the additional configuration.
         * </p>
         * 
         * @param enabledAccountsCount
         *        Total number of accounts that have enabled the additional configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAccountsCount(Integer enabledAccountsCount);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer enabledAccountsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationFeatureStatisticsAdditionalConfiguration model) {
            name(model.name);
            enabledAccountsCount(model.enabledAccountsCount);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeatureAdditionalConfiguration name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Integer getEnabledAccountsCount() {
            return enabledAccountsCount;
        }

        public final void setEnabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
        }

        @Override
        public final Builder enabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
            return this;
        }

        @Override
        public OrganizationFeatureStatisticsAdditionalConfiguration build() {
            return new OrganizationFeatureStatisticsAdditionalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
