/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the behavior of the anomaly that is new to GuardDuty.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyUnusual implements SdkPojo, Serializable, ToCopyableBuilder<AnomalyUnusual.Builder, AnomalyUnusual> {
    private static final SdkField<Map<String, Map<String, AnomalyObject>>> BEHAVIOR_FIELD = SdkField
            .<Map<String, Map<String, AnomalyObject>>> builder(MarshallingType.MAP)
            .memberName("Behavior")
            .getter(getter(AnomalyUnusual::behavior))
            .setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, AnomalyObject>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<AnomalyObject> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(AnomalyObject::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Map<String, AnomalyObject>> behavior;

    private AnomalyUnusual(BuilderImpl builder) {
        this.behavior = builder.behavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the Behavior property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBehavior() {
        return behavior != null && !(behavior instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The behavior of the anomalous activity that caused GuardDuty to generate the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBehavior} method.
     * </p>
     * 
     * @return The behavior of the anomalous activity that caused GuardDuty to generate the finding.
     */
    public final Map<String, Map<String, AnomalyObject>> behavior() {
        return behavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBehavior() ? behavior() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyUnusual)) {
            return false;
        }
        AnomalyUnusual other = (AnomalyUnusual) obj;
        return hasBehavior() == other.hasBehavior() && Objects.equals(behavior(), other.behavior());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyUnusual").add("Behavior", hasBehavior() ? behavior() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Behavior":
            return Optional.ofNullable(clazz.cast(behavior()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyUnusual, T> g) {
        return obj -> g.apply((AnomalyUnusual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyUnusual> {
        /**
         * <p>
         * The behavior of the anomalous activity that caused GuardDuty to generate the finding.
         * </p>
         * 
         * @param behavior
         *        The behavior of the anomalous activity that caused GuardDuty to generate the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behavior(Map<String, ? extends Map<String, AnomalyObject>> behavior);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Map<String, AnomalyObject>> behavior = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyUnusual model) {
            behavior(model.behavior);
        }

        public final Map<String, Map<String, AnomalyObject.Builder>> getBehavior() {
            Map<String, Map<String, AnomalyObject.Builder>> result = BehaviorCopier.copyToBuilder(this.behavior);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBehavior(Map<String, ? extends Map<String, AnomalyObject.BuilderImpl>> behavior) {
            this.behavior = BehaviorCopier.copyFromBuilder(behavior);
        }

        @Override
        public final Builder behavior(Map<String, ? extends Map<String, AnomalyObject>> behavior) {
            this.behavior = BehaviorCopier.copy(behavior);
            return this;
        }

        @Override
        public AnomalyUnusual build() {
            return new AnomalyUnusual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
