/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.DataSourcesFreeTrial;
import software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureConfigurationResult;
import software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureConfigurationsResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountFreeTrialInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountFreeTrialInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountFreeTrialInfo.getter(AccountFreeTrialInfo::accountId)).setter(AccountFreeTrialInfo.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<DataSourcesFreeTrial> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(AccountFreeTrialInfo.getter(AccountFreeTrialInfo::dataSources)).setter(AccountFreeTrialInfo.setter(Builder::dataSources)).constructor(DataSourcesFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final SdkField<List<FreeTrialFeatureConfigurationResult>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(AccountFreeTrialInfo.getter(AccountFreeTrialInfo::features)).setter(AccountFreeTrialInfo.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeTrialFeatureConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final DataSourcesFreeTrial dataSources;
    private final List<FreeTrialFeatureConfigurationResult> features;

    private AccountFreeTrialInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
    }

    public final String accountId() {
        return this.accountId;
    }

    @Deprecated
    public final DataSourcesFreeTrial dataSources() {
        return this.dataSources;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<FreeTrialFeatureConfigurationResult> features() {
        return this.features;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountFreeTrialInfo)) {
            return false;
        }
        AccountFreeTrialInfo other = (AccountFreeTrialInfo)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.dataSources(), other.dataSources()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features());
    }

    public final String toString() {
        return ToString.builder((String)"AccountFreeTrialInfo").add("AccountId", (Object)this.accountId()).add("DataSources", (Object)this.dataSources()).add("Features", this.hasFeatures() ? this.features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountFreeTrialInfo, T> g) {
        return obj -> g.apply((AccountFreeTrialInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private DataSourcesFreeTrial dataSources;
        private List<FreeTrialFeatureConfigurationResult> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountFreeTrialInfo model) {
            this.accountId(model.accountId);
            this.dataSources(model.dataSources);
            this.features(model.features);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Deprecated
        public final DataSourcesFreeTrial.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(DataSourcesFreeTrial.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(DataSourcesFreeTrial dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<FreeTrialFeatureConfigurationResult.Builder> getFeatures() {
            List<FreeTrialFeatureConfigurationResult.Builder> result = FreeTrialFeatureConfigurationsResultsCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<FreeTrialFeatureConfigurationResult.BuilderImpl> features) {
            this.features = FreeTrialFeatureConfigurationsResultsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<FreeTrialFeatureConfigurationResult> features) {
            this.features = FreeTrialFeatureConfigurationsResultsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(FreeTrialFeatureConfigurationResult ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<FreeTrialFeatureConfigurationResult.Builder> ... features) {
            this.features(Stream.of(features).map(c -> (FreeTrialFeatureConfigurationResult)((FreeTrialFeatureConfigurationResult.Builder)FreeTrialFeatureConfigurationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AccountFreeTrialInfo build() {
            return new AccountFreeTrialInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountFreeTrialInfo> {
        public Builder accountId(String var1);

        @Deprecated
        public Builder dataSources(DataSourcesFreeTrial var1);

        @Deprecated
        default public Builder dataSources(Consumer<DataSourcesFreeTrial.Builder> dataSources) {
            return this.dataSources((DataSourcesFreeTrial)((DataSourcesFreeTrial.Builder)DataSourcesFreeTrial.builder().applyMutation(dataSources)).build());
        }

        public Builder features(Collection<FreeTrialFeatureConfigurationResult> var1);

        public Builder features(FreeTrialFeatureConfigurationResult ... var1);

        public Builder features(Consumer<FreeTrialFeatureConfigurationResult.Builder> ... var1);
    }
}

