/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about each finding type associated with the <code>groupedByFindingType</code> statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingTypeStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingTypeStatistics.Builder, FindingTypeStatistics> {
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingType").getter(getter(FindingTypeStatistics::findingType)).setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()).build();

    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastGeneratedAt").getter(getter(FindingTypeStatistics::lastGeneratedAt))
            .setter(setter(Builder::lastGeneratedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()).build();

    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFindings").getter(getter(FindingTypeStatistics::totalFindings))
            .setter(setter(Builder::totalFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPE_FIELD,
            LAST_GENERATED_AT_FIELD, TOTAL_FINDINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingType;

    private final Instant lastGeneratedAt;

    private final Integer totalFindings;

    private FindingTypeStatistics(BuilderImpl builder) {
        this.findingType = builder.findingType;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.totalFindings = builder.totalFindings;
    }

    /**
     * <p>
     * Name of the finding type.
     * </p>
     * 
     * @return Name of the finding type.
     */
    public final String findingType() {
        return findingType;
    }

    /**
     * <p>
     * The timestamp at which this finding type was last generated in your environment.
     * </p>
     * 
     * @return The timestamp at which this finding type was last generated in your environment.
     */
    public final Instant lastGeneratedAt() {
        return lastGeneratedAt;
    }

    /**
     * <p>
     * The total number of findings associated with generated for each distinct finding type.
     * </p>
     * 
     * @return The total number of findings associated with generated for each distinct finding type.
     */
    public final Integer totalFindings() {
        return totalFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingType());
        hashCode = 31 * hashCode + Objects.hashCode(lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(totalFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingTypeStatistics)) {
            return false;
        }
        FindingTypeStatistics other = (FindingTypeStatistics) obj;
        return Objects.equals(findingType(), other.findingType()) && Objects.equals(lastGeneratedAt(), other.lastGeneratedAt())
                && Objects.equals(totalFindings(), other.totalFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingTypeStatistics").add("FindingType", findingType())
                .add("LastGeneratedAt", lastGeneratedAt()).add("TotalFindings", totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingType":
            return Optional.ofNullable(clazz.cast(findingType()));
        case "LastGeneratedAt":
            return Optional.ofNullable(clazz.cast(lastGeneratedAt()));
        case "TotalFindings":
            return Optional.ofNullable(clazz.cast(totalFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingTypeStatistics, T> g) {
        return obj -> g.apply((FindingTypeStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingTypeStatistics> {
        /**
         * <p>
         * Name of the finding type.
         * </p>
         * 
         * @param findingType
         *        Name of the finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The timestamp at which this finding type was last generated in your environment.
         * </p>
         * 
         * @param lastGeneratedAt
         *        The timestamp at which this finding type was last generated in your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastGeneratedAt(Instant lastGeneratedAt);

        /**
         * <p>
         * The total number of findings associated with generated for each distinct finding type.
         * </p>
         * 
         * @param totalFindings
         *        The total number of findings associated with generated for each distinct finding type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFindings(Integer totalFindings);
    }

    static final class BuilderImpl implements Builder {
        private String findingType;

        private Instant lastGeneratedAt;

        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingTypeStatistics model) {
            findingType(model.findingType);
            lastGeneratedAt(model.lastGeneratedAt);
            totalFindings(model.totalFindings);
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final Integer getTotalFindings() {
            return totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        @Override
        public FindingTypeStatistics build() {
            return new FindingTypeStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
