/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about each resource type associated with the <code>groupedByResource</code> statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceStatistics.Builder, ResourceStatistics> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ResourceStatistics::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastGeneratedAt").getter(getter(ResourceStatistics::lastGeneratedAt))
            .setter(setter(Builder::lastGeneratedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResourceStatistics::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceStatistics::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFindings").getter(getter(ResourceStatistics::totalFindings)).setter(setter(Builder::totalFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            LAST_GENERATED_AT_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TOTAL_FINDINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Instant lastGeneratedAt;

    private final String resourceId;

    private final String resourceType;

    private final Integer totalFindings;

    private ResourceStatistics(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.totalFindings = builder.totalFindings;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The timestamp at which the statistics for this resource was last generated.
     * </p>
     * 
     * @return The timestamp at which the statistics for this resource was last generated.
     */
    public final Instant lastGeneratedAt() {
        return lastGeneratedAt;
    }

    /**
     * <p>
     * ID associated with each resource. The following list provides the mapping of the resource type and resource ID.
     * </p>
     * <p class="title">
     * <b>Mapping of resource and resource ID</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * AccessKey - <code>resource.accessKeyDetails.accessKeyId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Container - <code>resource.containerDetails.id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * ECSCluster - <code>resource.ecsClusterDetails.name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * EKSCluster - <code>resource.eksClusterDetails.name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance - <code>resource.instanceDetails.instanceId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * KubernetesCluster - <code>resource.kubernetesDetails.kubernetesWorkloadDetails.name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda - <code>resource.lambdaDetails.functionName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * RDSDBInstance - <code>resource.rdsDbInstanceDetails.dbInstanceIdentifier</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * S3Bucket - <code>resource.s3BucketDetails.name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * S3Object - <code>resource.s3BucketDetails.name</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID associated with each resource. The following list provides the mapping of the resource type and
     *         resource ID.</p>
     *         <p class="title">
     *         <b>Mapping of resource and resource ID</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AccessKey - <code>resource.accessKeyDetails.accessKeyId</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Container - <code>resource.containerDetails.id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ECSCluster - <code>resource.ecsClusterDetails.name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EKSCluster - <code>resource.eksClusterDetails.name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Instance - <code>resource.instanceDetails.instanceId</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KubernetesCluster - <code>resource.kubernetesDetails.kubernetesWorkloadDetails.name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lambda - <code>resource.lambdaDetails.functionName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDSDBInstance - <code>resource.rdsDbInstanceDetails.dbInstanceIdentifier</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3Bucket - <code>resource.s3BucketDetails.name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3Object - <code>resource.s3BucketDetails.name</code>
     *         </p>
     *         </li>
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The total number of findings associated with this resource.
     * </p>
     * 
     * @return The total number of findings associated with this resource.
     */
    public final Integer totalFindings() {
        return totalFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(totalFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatistics)) {
            return false;
        }
        ResourceStatistics other = (ResourceStatistics) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(lastGeneratedAt(), other.lastGeneratedAt())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(totalFindings(), other.totalFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceStatistics").add("AccountId", accountId()).add("LastGeneratedAt", lastGeneratedAt())
                .add("ResourceId", resourceId()).add("ResourceType", resourceType()).add("TotalFindings", totalFindings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "LastGeneratedAt":
            return Optional.ofNullable(clazz.cast(lastGeneratedAt()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "TotalFindings":
            return Optional.ofNullable(clazz.cast(totalFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatistics, T> g) {
        return obj -> g.apply((ResourceStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceStatistics> {
        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The timestamp at which the statistics for this resource was last generated.
         * </p>
         * 
         * @param lastGeneratedAt
         *        The timestamp at which the statistics for this resource was last generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastGeneratedAt(Instant lastGeneratedAt);

        /**
         * <p>
         * ID associated with each resource. The following list provides the mapping of the resource type and resource
         * ID.
         * </p>
         * <p class="title">
         * <b>Mapping of resource and resource ID</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * AccessKey - <code>resource.accessKeyDetails.accessKeyId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Container - <code>resource.containerDetails.id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * ECSCluster - <code>resource.ecsClusterDetails.name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * EKSCluster - <code>resource.eksClusterDetails.name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Instance - <code>resource.instanceDetails.instanceId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * KubernetesCluster - <code>resource.kubernetesDetails.kubernetesWorkloadDetails.name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda - <code>resource.lambdaDetails.functionName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * RDSDBInstance - <code>resource.rdsDbInstanceDetails.dbInstanceIdentifier</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * S3Bucket - <code>resource.s3BucketDetails.name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * S3Object - <code>resource.s3BucketDetails.name</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceId
         *        ID associated with each resource. The following list provides the mapping of the resource type and
         *        resource ID.</p>
         *        <p class="title">
         *        <b>Mapping of resource and resource ID</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AccessKey - <code>resource.accessKeyDetails.accessKeyId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Container - <code>resource.containerDetails.id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ECSCluster - <code>resource.ecsClusterDetails.name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EKSCluster - <code>resource.eksClusterDetails.name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Instance - <code>resource.instanceDetails.instanceId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KubernetesCluster - <code>resource.kubernetesDetails.kubernetesWorkloadDetails.name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda - <code>resource.lambdaDetails.functionName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDSDBInstance - <code>resource.rdsDbInstanceDetails.dbInstanceIdentifier</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3Bucket - <code>resource.s3BucketDetails.name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3Object - <code>resource.s3BucketDetails.name</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The total number of findings associated with this resource.
         * </p>
         * 
         * @param totalFindings
         *        The total number of findings associated with this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFindings(Integer totalFindings);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Instant lastGeneratedAt;

        private String resourceId;

        private String resourceType;

        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatistics model) {
            accountId(model.accountId);
            lastGeneratedAt(model.lastGeneratedAt);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            totalFindings(model.totalFindings);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getTotalFindings() {
            return totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        @Override
        public ResourceStatistics build() {
            return new ResourceStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
