/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents list a map of dates with a count of total findings generated on each date.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateStatistics implements SdkPojo, Serializable, ToCopyableBuilder<DateStatistics.Builder, DateStatistics> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Date")
            .getter(getter(DateStatistics::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastGeneratedAt").getter(getter(DateStatistics::lastGeneratedAt))
            .setter(setter(Builder::lastGeneratedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()).build();

    private static final SdkField<Double> SEVERITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Severity").getter(getter(DateStatistics::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFindings").getter(getter(DateStatistics::totalFindings)).setter(setter(Builder::totalFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD,
            LAST_GENERATED_AT_FIELD, SEVERITY_FIELD, TOTAL_FINDINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant date;

    private final Instant lastGeneratedAt;

    private final Double severity;

    private final Integer totalFindings;

    private DateStatistics(BuilderImpl builder) {
        this.date = builder.date;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.severity = builder.severity;
        this.totalFindings = builder.totalFindings;
    }

    /**
     * <p>
     * The timestamp when the total findings count is observed.
     * </p>
     * <p>
     * For example, <code>Date</code> would look like <code>"2024-09-05T17:00:00-07:00"</code> whereas
     * <code>LastGeneratedAt</code> would look like 2024-09-05T17:12:29-07:00".
     * </p>
     * 
     * @return The timestamp when the total findings count is observed.</p>
     *         <p>
     *         For example, <code>Date</code> would look like <code>"2024-09-05T17:00:00-07:00"</code> whereas
     *         <code>LastGeneratedAt</code> would look like 2024-09-05T17:12:29-07:00".
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The timestamp at which the last finding in the findings count, was generated.
     * </p>
     * 
     * @return The timestamp at which the last finding in the findings count, was generated.
     */
    public final Instant lastGeneratedAt() {
        return lastGeneratedAt;
    }

    /**
     * <p>
     * The severity of the findings generated on each date.
     * </p>
     * 
     * @return The severity of the findings generated on each date.
     */
    public final Double severity() {
        return severity;
    }

    /**
     * <p>
     * The total number of findings that were generated per severity level on each date.
     * </p>
     * 
     * @return The total number of findings that were generated per severity level on each date.
     */
    public final Integer totalFindings() {
        return totalFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(totalFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateStatistics)) {
            return false;
        }
        DateStatistics other = (DateStatistics) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(lastGeneratedAt(), other.lastGeneratedAt())
                && Objects.equals(severity(), other.severity()) && Objects.equals(totalFindings(), other.totalFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateStatistics").add("Date", date()).add("LastGeneratedAt", lastGeneratedAt())
                .add("Severity", severity()).add("TotalFindings", totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "LastGeneratedAt":
            return Optional.ofNullable(clazz.cast(lastGeneratedAt()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "TotalFindings":
            return Optional.ofNullable(clazz.cast(totalFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateStatistics, T> g) {
        return obj -> g.apply((DateStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateStatistics> {
        /**
         * <p>
         * The timestamp when the total findings count is observed.
         * </p>
         * <p>
         * For example, <code>Date</code> would look like <code>"2024-09-05T17:00:00-07:00"</code> whereas
         * <code>LastGeneratedAt</code> would look like 2024-09-05T17:12:29-07:00".
         * </p>
         * 
         * @param date
         *        The timestamp when the total findings count is observed.</p>
         *        <p>
         *        For example, <code>Date</code> would look like <code>"2024-09-05T17:00:00-07:00"</code> whereas
         *        <code>LastGeneratedAt</code> would look like 2024-09-05T17:12:29-07:00".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The timestamp at which the last finding in the findings count, was generated.
         * </p>
         * 
         * @param lastGeneratedAt
         *        The timestamp at which the last finding in the findings count, was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastGeneratedAt(Instant lastGeneratedAt);

        /**
         * <p>
         * The severity of the findings generated on each date.
         * </p>
         * 
         * @param severity
         *        The severity of the findings generated on each date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Double severity);

        /**
         * <p>
         * The total number of findings that were generated per severity level on each date.
         * </p>
         * 
         * @param totalFindings
         *        The total number of findings that were generated per severity level on each date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFindings(Integer totalFindings);
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private Instant lastGeneratedAt;

        private Double severity;

        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(DateStatistics model) {
            date(model.date);
            lastGeneratedAt(model.lastGeneratedAt);
            severity(model.severity);
            totalFindings(model.totalFindings);
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final Double getSeverity() {
            return severity;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getTotalFindings() {
            return totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        @Override
        public DateStatistics build() {
            return new DateStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
