/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the task in an ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsTaskDetails implements SdkPojo, Serializable, ToCopyableBuilder<EcsTaskDetails.Builder, EcsTaskDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EcsTaskDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefinitionArn").getter(getter(EcsTaskDetails::definitionArn)).setter(setter(Builder::definitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(EcsTaskDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> TASK_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TaskCreatedAt").getter(getter(EcsTaskDetails::taskCreatedAt)).setter(setter(Builder::taskCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(EcsTaskDetails::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartedBy").getter(getter(EcsTaskDetails::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(EcsTaskDetails::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("Volumes")
            .getter(getter(EcsTaskDetails::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField
            .<List<Container>> builder(MarshallingType.LIST)
            .memberName("Containers")
            .getter(getter(EcsTaskDetails::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Container> builder(MarshallingType.SDK_POJO)
                                            .constructor(Container::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(EcsTaskDetails::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchType").getter(getter(EcsTaskDetails::launchType)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DEFINITION_ARN_FIELD, VERSION_FIELD, TASK_CREATED_AT_FIELD, STARTED_AT_FIELD, STARTED_BY_FIELD, TAGS_FIELD,
            VOLUMES_FIELD, CONTAINERS_FIELD, GROUP_FIELD, LAUNCH_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String definitionArn;

    private final String version;

    private final Instant taskCreatedAt;

    private final Instant startedAt;

    private final String startedBy;

    private final List<Tag> tags;

    private final List<Volume> volumes;

    private final List<Container> containers;

    private final String group;

    private final String launchType;

    private EcsTaskDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.definitionArn = builder.definitionArn;
        this.version = builder.version;
        this.taskCreatedAt = builder.taskCreatedAt;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.tags = builder.tags;
        this.volumes = builder.volumes;
        this.containers = builder.containers;
        this.group = builder.group;
        this.launchType = builder.launchType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     * 
     * @return The ARN of the task definition that creates the task.
     */
    public final String definitionArn() {
        return definitionArn;
    }

    /**
     * <p>
     * The version counter for the task.
     * </p>
     * 
     * @return The version counter for the task.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was created.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task was created.
     */
    public final Instant taskCreatedAt() {
        return taskCreatedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task started.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * Contains the tag specified when a task is started.
     * </p>
     * 
     * @return Contains the tag specified when a task is started.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags of the ECS Task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the ECS Task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data volume definitions for the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return The list of data volume definitions for the task.
     */
    public final List<Volume> volumes() {
        return volumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The containers that's associated with the task.
     */
    public final List<Container> containers() {
        return containers;
    }

    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     * 
     * @return The name of the task group that's associated with the task.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * A capacity on which the task is running. For example, <code>Fargate</code> and <code>EC2</code>.
     * </p>
     * 
     * @return A capacity on which the task is running. For example, <code>Fargate</code> and <code>EC2</code>.
     */
    public final String launchType() {
        return launchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(definitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(taskCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(launchType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskDetails)) {
            return false;
        }
        EcsTaskDetails other = (EcsTaskDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(definitionArn(), other.definitionArn())
                && Objects.equals(version(), other.version()) && Objects.equals(taskCreatedAt(), other.taskCreatedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(startedBy(), other.startedBy())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes()) && hasContainers() == other.hasContainers()
                && Objects.equals(containers(), other.containers()) && Objects.equals(group(), other.group())
                && Objects.equals(launchType(), other.launchType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsTaskDetails").add("Arn", arn()).add("DefinitionArn", definitionArn())
                .add("Version", version()).add("TaskCreatedAt", taskCreatedAt()).add("StartedAt", startedAt())
                .add("StartedBy", startedBy()).add("Tags", hasTags() ? tags() : null)
                .add("Volumes", hasVolumes() ? volumes() : null).add("Containers", hasContainers() ? containers() : null)
                .add("Group", group()).add("LaunchType", launchType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DefinitionArn":
            return Optional.ofNullable(clazz.cast(definitionArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "TaskCreatedAt":
            return Optional.ofNullable(clazz.cast(taskCreatedAt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "StartedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "LaunchType":
            return Optional.ofNullable(clazz.cast(launchType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsTaskDetails, T> g) {
        return obj -> g.apply((EcsTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsTaskDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the task definition that creates the task.
         * </p>
         * 
         * @param definitionArn
         *        The ARN of the task definition that creates the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionArn(String definitionArn);

        /**
         * <p>
         * The version counter for the task.
         * </p>
         * 
         * @param version
         *        The version counter for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The Unix timestamp for the time when the task was created.
         * </p>
         * 
         * @param taskCreatedAt
         *        The Unix timestamp for the time when the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskCreatedAt(Instant taskCreatedAt);

        /**
         * <p>
         * The Unix timestamp for the time when the task started.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for the time when the task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * Contains the tag specified when a task is started.
         * </p>
         * 
         * @param startedBy
         *        Contains the tag specified when a task is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The tags of the ECS Task.
         * </p>
         * 
         * @param tags
         *        The tags of the ECS Task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags of the ECS Task.
         * </p>
         * 
         * @param tags
         *        The tags of the ECS Task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags of the ECS Task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The list of data volume definitions for the task.
         * </p>
         * 
         * @param volumes
         *        The list of data volume definitions for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * The list of data volume definitions for the task.
         * </p>
         * 
         * @param volumes
         *        The list of data volume definitions for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * The list of data volume definitions for the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Volume.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Volume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Volume.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);

        /**
         * <p>
         * The containers that's associated with the task.
         * </p>
         * 
         * @param containers
         *        The containers that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<Container> containers);

        /**
         * <p>
         * The containers that's associated with the task.
         * </p>
         * 
         * @param containers
         *        The containers that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Container... containers);

        /**
         * <p>
         * The containers that's associated with the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Container.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Container#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Container.Builder#build()} is called immediately and
         * its result is passed to {@link #containers(List<Container>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Container.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<Container>)
         */
        Builder containers(Consumer<Container.Builder>... containers);

        /**
         * <p>
         * The name of the task group that's associated with the task.
         * </p>
         * 
         * @param group
         *        The name of the task group that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * A capacity on which the task is running. For example, <code>Fargate</code> and <code>EC2</code>.
         * </p>
         * 
         * @param launchType
         *        A capacity on which the task is running. For example, <code>Fargate</code> and <code>EC2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchType(String launchType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String definitionArn;

        private String version;

        private Instant taskCreatedAt;

        private Instant startedAt;

        private String startedBy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();

        private String group;

        private String launchType;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsTaskDetails model) {
            arn(model.arn);
            definitionArn(model.definitionArn);
            version(model.version);
            taskCreatedAt(model.taskCreatedAt);
            startedAt(model.startedAt);
            startedBy(model.startedBy);
            tags(model.tags);
            volumes(model.volumes);
            containers(model.containers);
            group(model.group);
            launchType(model.launchType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDefinitionArn() {
            return definitionArn;
        }

        public final void setDefinitionArn(String definitionArn) {
            this.definitionArn = definitionArn;
        }

        @Override
        public final Builder definitionArn(String definitionArn) {
            this.definitionArn = definitionArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getTaskCreatedAt() {
            return taskCreatedAt;
        }

        public final void setTaskCreatedAt(Instant taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
        }

        @Override
        public final Builder taskCreatedAt(Instant taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainersCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder>... containers) {
            containers(Stream.of(containers).map(c -> Container.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public EcsTaskDetails build() {
            return new EcsTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
